/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSnapshot;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.SnapshotEvent;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.cluster.DistributedConfigurationUtils;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.management.cache.IdleVerifyResultV2;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.communication.TransmissionCancelledException;
import org.apache.ignite.internal.managers.communication.TransmissionHandler;
import org.apache.ignite.internal.managers.communication.TransmissionMeta;
import org.apache.ignite.internal.managers.communication.TransmissionPolicy;
import org.apache.ignite.internal.managers.encryption.EncryptionCacheKeyProvider;
import org.apache.ignite.internal.managers.encryption.GroupKey;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.managers.systemview.walker.SnapshotViewWalker;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.GridLocalConfigManager;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.AbstractSnapshotFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.DataStreamerUpdatesHandler;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotVerifyException;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IncrementalSnapshotAwareMessage;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IncrementalSnapshotFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IncrementalSnapshotMarkWalFuture;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IncrementalSnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IncrementalSnapshotVerificationTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotFilesFailureMessage;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotFilesRequestMessage;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotFinishedFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotFutureTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandler;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerRestoreTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerType;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadata;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadataVerificationTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadataVerificationTaskArg;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMetadataVerificationTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperationRequest;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsQuickVerifyHandler;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyHandler;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskArg;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotPartitionsVerifyTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotResponseRemoteFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotRestoreProcess;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotRestoreStatusTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotSender;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotWarningException;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.dump.CreateDumpFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.DataPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneGridKernalContext;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.tree.DataRow;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.compress.CompressionProcessor;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedConfigurationLifecycleListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedLongProperty;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedPropertyDispatcher;
import org.apache.ignite.internal.processors.marshaller.MappedName;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageImpl;
import org.apache.ignite.internal.processors.metric.MetricRegistryImpl;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.processors.task.TaskExecutionOptions;
import org.apache.ignite.internal.util.BasicRateLimiter;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.distributed.DistributedProcess;
import org.apache.ignite.internal.util.distributed.InitMessage;
import org.apache.ignite.internal.util.future.GridCompoundIdentityFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.io.GridFileUtils;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.systemview.view.SnapshotView;
import org.jetbrains.annotations.Nullable;

public class IgniteSnapshotManager
extends GridCacheSharedManagerAdapter
implements IgniteSnapshot,
PartitionsExchangeAware,
MetastorageLifecycleListener,
IgniteChangeGlobalStateSupport {
    public static final String DELTA_SUFFIX = ".delta";
    public static final String DELTA_IDX_SUFFIX = ".idx";
    public static final String PART_DELTA_TEMPLATE = "part-%d.bin.delta";
    public static final String INDEX_DELTA_NAME = "index.bin.delta";
    public static final String CP_SNAPSHOT_REASON = "Checkpoint started to enforce snapshot operation: %s";
    public static final String RMT_SNAPSHOT_PREFIX = "snapshot_";
    public static final String DFLT_SNAPSHOT_TMP_DIR = "snp";
    public static final String SNP_IN_PROGRESS_ERR_MSG = "Operation rejected due to the snapshot operation in progress.";
    public static final String SNP_NODE_STOPPING_ERR_MSG = "The operation is cancelled due to the local node is stopping";
    public static final String SNAPSHOT_METRICS = "snapshot";
    public static final String INCREMENTAL_SNAPSHOT_METRICS = MetricUtils.metricName("snapshot", "incremental");
    public static final String SNAPSHOT_METAFILE_EXT = ".smf";
    public static final String SNAPSHOT_METAFILE_TMP_EXT = ".tmp";
    public static final String SNAPSHOT_RUNNER_THREAD_PREFIX = "snapshot-runner";
    public static final String SNAPSHOT_TRANSFER_RATE_DMS_KEY = "snapshotTransferRate";
    public static final long DFLT_SNAPSHOT_TRANSFER_RATE_BYTES = 0L;
    public static final int SNAPSHOT_LIMITED_TRANSFER_BLOCK_SIZE_BYTES = 65536;
    public static final String SNP_RUNNING_DIR_KEY = "snapshot-running-dir";
    private static final String INC_SNP_DISABLED_KEY_PREFIX = "grp-inc-snp-disabled-";
    public static final boolean DFLT_IGNITE_SNAPSHOT_SEQUENTIAL_WRITE = true;
    public static final boolean DFLT_CHECK_ON_RESTORE = false;
    @Deprecated
    private static final String SNP_RUNNING_KEY = "snapshot-running";
    private static final String SNAPSHOT_STARTED_MSG = "Cluster-wide snapshot operation started: ";
    private static final String SNAPSHOT_FINISHED_MSG = "Cluster-wide snapshot operation finished successfully: ";
    public static final String SNAPSHOT_FINISHED_WRN_MSG = "Cluster-wide snapshot operation finished with warnings: ";
    private static final String SNAPSHOT_FAILED_MSG = "Cluster-wide snapshot operation failed: ";
    private static final Object DFLT_INITIAL_SNAPSHOT_TOPIC = GridTopic.TOPIC_SNAPSHOT.topic("rmt_snp");
    private static final String SNP_GRP_ID_PARAM = "grpId";
    private static final String SNP_PART_ID_PARAM = "partId";
    private static final String SNP_CACHE_DIR_NAME_PARAM = "cacheDirName";
    private static final String RQ_ID_NAME_PARAM = "rqId";
    private static final String SNP_PARTITIONS_CNT = "partsCnt";
    public static final String INC_SNP_DIR = "increments";
    public static final Pattern INC_SNP_NAME_PATTERN = U.fixedLengthNumberNamePattern(null);
    public static final String DUMP_LOCK = "dump.lock";
    private final ThreadLocal<ByteBuffer> locBuff;
    private final ConcurrentMap<String, AbstractSnapshotFutureTask<?>> locSnpTasks = new ConcurrentHashMap();
    private final GridBusyLock busyLock = new GridBusyLock();
    private final Object snpOpMux = new Object();
    private final DistributedProcess<SnapshotOperationRequest, SnapshotOperationResponse> startSnpProc;
    private final DistributedProcess<SnapshotOperationRequest, SnapshotOperationResponse> endSnpProc;
    private final Marshaller marsh;
    private final SnapshotRestoreProcess restoreCacheGrpProc;
    private final BasicRateLimiter transferRateLimiter = new BasicRateLimiter(0.0);
    private volatile PdsFolderSettings<?> pdsSettings;
    private volatile ReadWriteMetastorage metaStorage;
    private BiFunction<String, String, SnapshotSender> locSndrFactory = (x$0, x$1) -> new LocalSnapshotSender((String)x$0, (String)x$1);
    private BiFunction<String, UUID, SnapshotSender> rmtSndrFactory = this::remoteSnapshotSenderFactory;
    private volatile File locSnpDir;
    @Nullable
    private File tmpWorkDir;
    private volatile FileIOFactory ioFactory = new RandomAccessFileIOFactory();
    @Nullable
    private volatile FilePageStoreManager storeMgr;
    private volatile GridLocalConfigManager locCfgMgr;
    private DiscoveryEventListener discoLsnr;
    private ClusterSnapshotFuture clusterSnpFut;
    private volatile SnapshotOperationRequest clusterSnpReq;
    private volatile boolean recovered;
    private volatile ClusterSnapshotFuture lastSeenSnpFut = new ClusterSnapshotFuture();
    private volatile ClusterSnapshotFuture lastSeenIncSnpFut;
    private final SnapshotHandlers handlers = new SnapshotHandlers();
    private final SequentialRemoteSnapshotManager snpRmtMgr;
    private volatile UUID incSnpId;
    private volatile GridFutureAdapter<?> wrapMsgsFut;
    @Nullable
    private volatile IncrementalSnapshotMarkWalFuture markWalFut;
    private final DistributedLongProperty snapshotTransferRate = DistributedLongProperty.detachedLongProperty("snapshotTransferRate", "Snapshot transfer rate in bytes per second at which snapshot files are created. 0 means there is no limit.");
    private final boolean sequentialWrite = IgniteSystemProperties.getBoolean("IGNITE_SNAPSHOT_SEQUENTIAL_WRITE", true);

    public IgniteSnapshotManager(GridKernalContext ctx) {
        this.locBuff = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(ctx.config().getDataStorageConfiguration().getPageSize()).order(ByteOrder.nativeOrder()));
        this.startSnpProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.START_SNAPSHOT, this::initLocalSnapshotStartStage, this::processLocalSnapshotStartStageResult, SnapshotStartDiscoveryMessage::new);
        this.endSnpProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.END_SNAPSHOT, this::initLocalSnapshotEndStage, this::processLocalSnapshotEndStageResult, (reqId, req) -> new InitMessage<SnapshotOperationRequest>((UUID)reqId, DistributedProcess.DistributedProcessType.END_SNAPSHOT, (SnapshotOperationRequest)req, true));
        this.marsh = ctx.marshallerContext().jdkMarshaller();
        this.restoreCacheGrpProc = new SnapshotRestoreProcess(ctx, this.locBuff);
        this.snpRmtMgr = new SequentialRemoteSnapshotManager();
    }

    public static File partDeltaFile(File snapshotCacheDir, int partId) {
        return new File(snapshotCacheDir, IgniteSnapshotManager.partDeltaFileName(partId));
    }

    public static File partDeltaIndexFile(File delta) {
        return new File(delta.getParent(), delta.getName() + DELTA_IDX_SUFFIX);
    }

    public static String partDeltaFileName(int partId) {
        assert (partId <= 65500 || partId == 65535);
        return partId == 65535 ? INDEX_DELTA_NAME : String.format(PART_DELTA_TEMPLATE, partId);
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        GridKernalContext ctx = this.cctx.kernalContext();
        if (ctx.clientNode()) {
            return;
        }
        this.storeMgr = (FilePageStoreManager)this.cctx.pageStore();
        this.locCfgMgr = this.cctx.cache().configManager();
        this.pdsSettings = this.cctx.kernalContext().pdsFolderResolver().resolveFolders();
        boolean persistenceEnabled = GridCacheUtils.isPersistenceEnabled(this.cctx.gridConfig());
        if (persistenceEnabled) {
            this.tmpWorkDir = U.resolveWorkDirectory(this.pdsSettings.persistentStoreNodePath().getAbsolutePath(), DFLT_SNAPSHOT_TMP_DIR, true);
            U.ensureDirectory(this.tmpWorkDir, "temp directory for snapshot creation", this.log);
        }
        this.initLocalSnapshotDirectory(persistenceEnabled);
        ctx.internalSubscriptionProcessor().registerDistributedConfigurationListener(new DistributedConfigurationLifecycleListener(){

            @Override
            public void onReadyToRegister(DistributedPropertyDispatcher dispatcher) {
                IgniteSnapshotManager.this.snapshotTransferRate.addListener((name, oldVal, newVal) -> {
                    if (!Objects.equals(oldVal, newVal)) {
                        if (newVal < 0L) {
                            IgniteSnapshotManager.this.log.warning("The snapshot transfer rate cannot be negative, the value '" + newVal + "' is ignored.");
                            return;
                        }
                        IgniteSnapshotManager.this.transferRateLimiter.setRate(newVal.longValue());
                        if (IgniteSnapshotManager.this.log.isInfoEnabled()) {
                            IgniteSnapshotManager.this.log.info("The snapshot transfer rate " + (String)(newVal == 0L ? "is not limited." : "has been changed from '" + oldVal + "' to '" + newVal + "' bytes/sec."));
                        }
                    }
                });
                dispatcher.registerProperty(IgniteSnapshotManager.this.snapshotTransferRate);
            }

            @Override
            public void onReadyToWrite() {
                DistributedConfigurationUtils.setDefaultValue(IgniteSnapshotManager.this.snapshotTransferRate, 0L, IgniteSnapshotManager.this.log);
            }
        });
        this.handlers.initialize(ctx, ctx.pools().getSnapshotExecutorService());
        MetricRegistryImpl mreg = this.cctx.kernalContext().metric().registry(SNAPSHOT_METRICS);
        mreg.register("LastSnapshotStartTime", () -> this.lastSeenSnpFut.startTime, "The system time of the last cluster snapshot request start time on this node.");
        mreg.register("LastSnapshotEndTime", () -> this.lastSeenSnpFut.endTime, "The system time of the last cluster snapshot request end time on this node.");
        mreg.register("LastSnapshotName", () -> this.lastSeenSnpFut.name, String.class, "The name of last started cluster snapshot request on this node.");
        mreg.register("LastSnapshotErrorMessage", () -> this.lastSeenSnpFut.error() == null ? "" : this.lastSeenSnpFut.error().getMessage(), String.class, "The error message of last started cluster snapshot request which fail with an error. This value will be empty if last snapshot request has been completed successfully.");
        mreg.register("LocalSnapshotNames", () -> this.localSnapshotNames(null), List.class, "The list of names of all snapshots currently saved on the local node with respect to the configured via IgniteConfiguration snapshot working path.");
        mreg.register("LastRequestId", () -> Optional.ofNullable(this.lastSeenSnpFut.rqId).map(UUID::toString).orElse(""), String.class, "The ID of the last started snapshot operation.");
        mreg.register("CurrentSnapshotTotalSize", () -> {
            SnapshotFutureTask task = this.currentSnapshotTask(SnapshotFutureTask.class);
            return task == null ? -1L : task.totalSize();
        }, "Estimated size of current cluster snapshot in bytes on this node. The value may grow during snapshot creation.");
        mreg.register("CurrentSnapshotProcessedSize", () -> {
            SnapshotFutureTask task = this.currentSnapshotTask(SnapshotFutureTask.class);
            return task == null ? -1L : task.processedSize();
        }, "Processed size of current cluster snapshot in bytes on this node.");
        MetricRegistryImpl incSnpMReg = this.cctx.kernalContext().metric().registry(INCREMENTAL_SNAPSHOT_METRICS);
        incSnpMReg.register("snapshotName", () -> Optional.ofNullable(this.lastSeenIncSnpFut).map(f -> f.name).orElse(""), String.class, "The name of full snapshot for which the last incremental snapshot created on this node.");
        incSnpMReg.register("incrementIndex", () -> Optional.ofNullable(this.lastSeenIncSnpFut).map(f -> f.incIdx).orElse(0), "Ihe index of the last incremental snapshot created on this node.");
        incSnpMReg.register("startTime", () -> Optional.ofNullable(this.lastSeenIncSnpFut).map(f -> f.startTime).orElse(0L), "The system time of the last incremental snapshot creation start time on this node.");
        incSnpMReg.register("endTime", () -> Optional.ofNullable(this.lastSeenIncSnpFut).map(f -> f.endTime).orElse(0L), "The system time of the last incremental snapshot creation end time on this node.");
        incSnpMReg.register("error", () -> Optional.ofNullable(this.lastSeenIncSnpFut).map(GridFutureAdapter::error).map(Object::toString).orElse(""), String.class, "The error message of last started incremental snapshot on this node.");
        this.restoreCacheGrpProc.registerMetrics();
        this.cctx.exchange().registerExchangeAwareComponent(this);
        ctx.internalSubscriptionProcessor().registerMetastorageListener(this);
        this.discoLsnr = (evt, discoCache) -> {
            if (!this.busyLock.enterBusy()) {
                return;
            }
            try {
                UUID leftNodeId = evt.eventNode().id();
                if (evt.type() == 11 || evt.type() == 12) {
                    boolean reqNodeLeft;
                    SnapshotOperationRequest snpReq = this.clusterSnpReq;
                    String err = "Snapshot operation interrupted, because baseline node left the cluster: " + leftNodeId;
                    boolean bl = reqNodeLeft = snpReq != null && snpReq.nodes().contains(leftNodeId);
                    if (reqNodeLeft && snpReq.startStageEnded() && U.isLocalNodeCoordinator(ctx.discovery())) {
                        snpReq.error(new ClusterTopologyCheckedException(err));
                        this.endSnpProc.start(snpReq.requestId(), snpReq);
                    }
                    for (AbstractSnapshotFutureTask sctx : this.locSnpTasks.values()) {
                        if (!sctx.sourceNodeId().equals(leftNodeId) && (!reqNodeLeft || !snpReq.snapshotName().equals(sctx.snapshotName()))) continue;
                        sctx.acceptException(new ClusterTopologyCheckedException(err));
                    }
                    this.restoreCacheGrpProc.onNodeLeft(leftNodeId);
                    this.snpRmtMgr.onNodeLeft(leftNodeId);
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        };
        this.cctx.gridEvents().addDiscoveryEventListener(this.discoLsnr, 11, 12);
        this.cctx.gridIO().addMessageListener(DFLT_INITIAL_SNAPSHOT_TOPIC, (GridMessageListener)this.snpRmtMgr);
        this.cctx.kernalContext().io().addTransmissionHandler(DFLT_INITIAL_SNAPSHOT_TOPIC, this.snpRmtMgr);
        ctx.systemView().registerView(SNAPSHOT_METRICS, "Snapshot", new SnapshotViewWalker(), () -> F.flatCollections(F.transform(this.localSnapshotNames(null), name -> {
            ArrayList<SnapshotView> views = new ArrayList<SnapshotView>();
            for (SnapshotMetadata snapshotMetadata : this.readSnapshotMetadatas((String)name, null)) {
                List<File> dirs = this.snapshotCacheDirectories(snapshotMetadata.snapshotName(), null, snapshotMetadata.folderName(), grpName -> true);
                Collection<String> cacheGrps = F.viewReadOnly(dirs, FilePageStoreManager::cacheGroupName, new IgnitePredicate[0]);
                views.add(new SnapshotView(snapshotMetadata, cacheGrps));
            }
            for (IncrementalSnapshotMetadata incrementalSnapshotMetadata : this.readIncrementalSnapshotMetadatas((String)name)) {
                views.add(new SnapshotView(incrementalSnapshotMetadata));
            }
            return views;
        })), Function.identity());
        File[] files = this.locSnpDir.listFiles();
        if (files != null) {
            Arrays.stream(files).filter(File::isDirectory).map(dumpDir -> Paths.get(dumpDir.getAbsolutePath(), "db", this.pdsSettings.folderName(), DUMP_LOCK).toFile()).filter(File::exists).map(File::getParentFile).forEach(lockedDumpDir -> {
                this.log.warning("Found locked dump dir. This means, dump creation not finished prior to node fail. Directory will be deleted: " + lockedDumpDir);
                U.delete(lockedDumpDir);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stop0(boolean cancel) {
        this.busyLock.block();
        try {
            this.snpRmtMgr.stop();
            this.restoreCacheGrpProc.interrupt(new NodeStoppingException("Node is stopping."));
            for (AbstractSnapshotFutureTask sctx : this.locSnpTasks.values()) {
                sctx.acceptException(new NodeStoppingException(SNP_NODE_STOPPING_ERR_MSG));
            }
            this.locSnpTasks.clear();
            Object object = this.snpOpMux;
            synchronized (object) {
                if (this.clusterSnpFut != null) {
                    this.clusterSnpFut.onDone(new NodeStoppingException(SNP_NODE_STOPPING_ERR_MSG));
                    this.clusterSnpFut = null;
                }
            }
            this.cctx.kernalContext().io().removeMessageListener(DFLT_INITIAL_SNAPSHOT_TOPIC);
            this.cctx.kernalContext().io().removeTransmissionHandler(DFLT_INITIAL_SNAPSHOT_TOPIC);
            if (this.discoLsnr != null) {
                this.cctx.kernalContext().event().removeDiscoveryEventListener(this.discoLsnr, new int[0]);
            }
            this.cctx.exchange().unregisterExchangeAwareComponent(this);
        }
        finally {
            this.busyLock.unblock();
        }
    }

    @Override
    public void onActivate(GridKernalContext kctx) {
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        this.restoreCacheGrpProc.interrupt(new IgniteCheckedException("The cluster has been deactivated."));
    }

    public void deleteSnapshot(File snpDir, PdsFolderSettings<?> pdsSettings) {
        if (!snpDir.exists()) {
            return;
        }
        if (!snpDir.isDirectory()) {
            return;
        }
        String folderName = pdsSettings.folderName();
        try {
            File binDir = CacheObjectBinaryProcessorImpl.binaryWorkDir(snpDir.getAbsolutePath(), folderName);
            File nodeDbDir = new File(snpDir.getAbsolutePath(), IgniteSnapshotManager.databaseRelativePath(folderName));
            File smf = new File(snpDir, IgniteSnapshotManager.snapshotMetaFileName(U.maskForFileName(pdsSettings.consistentId().toString())));
            U.delete(binDir);
            U.delete(nodeDbDir);
            U.delete(smf);
            File marshDir = MarshallerContextImpl.mappingFileStoreWorkDir(snpDir.getAbsolutePath());
            this.deleteDirectory(marshDir);
            File binMetadataDfltDir = new File(snpDir, "db/binary_meta");
            File marshallerDfltDir = new File(snpDir, "db/marshaller");
            this.deleteDirectory(binMetadataDfltDir);
            this.deleteDirectory(marshallerDfltDir);
            File db = new File(snpDir, "db");
            db.delete();
            snpDir.delete();
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    private void deleteDirectory(File dir) throws IOException {
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                U.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) {
                dir.toFile().delete();
                if (IgniteSnapshotManager.this.log.isInfoEnabled() && e != null) {
                    IgniteSnapshotManager.this.log.info("Snapshot directory cleaned with an exception [dir=" + dir + ", e=" + e.getMessage() + "]");
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public File snapshotLocalDir(String snpName) {
        return this.snapshotLocalDir(snpName, null);
    }

    public File snapshotLocalDir(String snpName, @Nullable String snpPath) {
        assert (this.locSnpDir != null);
        assert (U.alphanumericUnderscore(snpName)) : snpName;
        return snpPath == null ? new File(this.locSnpDir, snpName) : new File(snpPath, snpName);
    }

    public File incrementalSnapshotLocalDir(String snpName, @Nullable String snpPath, int incIdx) {
        return new File(this.incrementalSnapshotsLocalRootDir(snpName, snpPath), U.fixedLengthNumberName(incIdx, null));
    }

    public File incrementalSnapshotsLocalRootDir(String snpName, @Nullable String snpPath) {
        return new File(this.snapshotLocalDir(snpName, snpPath), INC_SNP_DIR);
    }

    public static File incrementalSnapshotWalsDir(File incSnpDir, String consId) {
        String folderName = U.maskForFileName(consId);
        return incSnpDir.toPath().resolve("db/wal").resolve(folderName).toFile();
    }

    private File resolveSnapshotDir(String snpName, @Nullable String snpPath) throws IgniteCheckedException {
        File snpDir = this.snapshotLocalDir(snpName, snpPath);
        if (!snpDir.exists()) {
            throw new IgniteCheckedException("Snapshot directory doesn't exists: " + snpDir.getAbsolutePath());
        }
        return snpDir;
    }

    public File snapshotTmpDir() {
        assert (this.tmpWorkDir != null);
        return this.tmpWorkDir;
    }

    private void initLocalSnapshotDirectory(boolean create) {
        try {
            this.locSnpDir = IgniteSnapshotManager.resolveSnapshotWorkDirectory(this.cctx.kernalContext().config(), create);
            if (create) {
                U.ensureDirectory(this.locSnpDir, "snapshot work directory", this.log);
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    private IgniteInternalFuture<SnapshotOperationResponse> initLocalSnapshotStartStage(SnapshotOperationRequest req) {
        if (this.clusterSnpReq != null) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new IgniteCheckedException("Snapshot operation has been rejected. Another snapshot operation in progress [req=" + req + ", curr=" + this.clusterSnpReq + "]"));
        }
        this.clusterSnpReq = req;
        if (req.incremental()) {
            this.handleIncrementalSnapshotId(req.requestId(), this.cctx.discovery().topologyVersion());
        }
        if (!CU.baselineNode(this.cctx.localNode(), this.cctx.kernalContext().state().clusterState())) {
            return new GridFinishedFuture<SnapshotOperationResponse>();
        }
        HashSet<UUID> leftNodes = new HashSet<UUID>(req.nodes());
        leftNodes.removeAll(F.viewReadOnly(this.cctx.discovery().serverNodes(AffinityTopologyVersion.NONE), F.node2id(), new IgnitePredicate[0]));
        if (!leftNodes.isEmpty()) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new IgniteCheckedException("Some of baseline nodes left the cluster prior to snapshot operation start: " + leftNodes));
        }
        if (this.cctx.kernalContext().encryption().isMasterKeyChangeInProgress()) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new IgniteCheckedException("Snapshot operation has been rejected. Master key changing process is not finished yet."));
        }
        if (this.cctx.kernalContext().encryption().reencryptionInProgress()) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new IgniteCheckedException("Snapshot operation has been rejected. Caches re-encryption process is not finished yet."));
        }
        ArrayList<Integer> grpIds = new ArrayList<Integer>(F.viewReadOnly(req.groups(), GridCacheUtils::cacheId, new IgnitePredicate[0]));
        Collection<Integer> comprGrpIds = F.view(grpIds, i -> {
            CacheGroupDescriptor desc = this.cctx.cache().cacheGroupDescriptor((int)i);
            return desc != null && desc.config().getDiskPageCompression() != DiskPageCompression.DISABLED;
        });
        HashSet<Integer> leftGrps = new HashSet<Integer>(grpIds);
        leftGrps.removeAll(this.cctx.cache().cacheGroupDescriptors().keySet());
        boolean withMetaStorage = leftGrps.remove(MetaStorage.METASTORAGE_CACHE_ID);
        if (!leftGrps.isEmpty()) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new IgniteCheckedException("Some of requested cache groups doesn't exist on the local node [missed=" + leftGrps + ", nodeId=" + this.cctx.localNodeId() + "]"));
        }
        if (req.incremental()) {
            SnapshotMetadata meta;
            try {
                meta = this.readSnapshotMetadata(new File(this.snapshotLocalDir(req.snapshotName(), req.snapshotPath()), IgniteSnapshotManager.snapshotMetaFileName(this.cctx.localNode().consistentId().toString())));
                this.checkIncrementalCanBeCreated(req.snapshotName(), req.snapshotPath(), meta);
            }
            catch (IOException | IgniteCheckedException e) {
                return new GridFinishedFuture<SnapshotOperationResponse>(e);
            }
            return this.initLocalIncrementalSnapshot(req, meta);
        }
        return this.initLocalFullSnapshot(req, grpIds, comprGrpIds, withMetaStorage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIncrementalSnapshotId(UUID id, long topVer) {
        if (this.incSnpId != null) {
            return;
        }
        Object object = this.snpOpMux;
        synchronized (object) {
            if (this.incSnpId != null) {
                if (!this.incSnpId.equals(id)) {
                    U.warn(this.log, "Received incremental snapshot ID differs from the current [rcvId=" + id + ", currId=" + this.incSnpId + "]");
                }
                return;
            }
            this.wrapMsgsFut = new GridFutureAdapter();
            this.cctx.tm().txMessageTransformer((msg, tx) -> new IncrementalSnapshotAwareMessage((GridCacheMessage)msg, id, tx == null ? null : tx.incrementalSnapshotId(), topVer));
            this.markWalFut = GridCacheUtils.baselineNode(this.cctx.localNode(), this.cctx.kernalContext().state().clusterState()) ? new IncrementalSnapshotMarkWalFuture(this.cctx, id, topVer) : null;
            this.incSnpId = id;
        }
        if (this.markWalFut != null) {
            this.cctx.kernalContext().pools().getSnapshotExecutorService().submit(this.markWalFut::init);
        }
    }

    private IgniteInternalFuture<SnapshotOperationResponse> initLocalIncrementalSnapshot(SnapshotOperationRequest req, SnapshotMetadata meta) {
        WALPointer lowPtr;
        File incSnpDir = this.incrementalSnapshotLocalDir(req.snapshotName(), req.snapshotPath(), req.incrementIndex());
        if (req.incrementIndex() == 1) {
            lowPtr = meta.snapshotRecordPointer();
        } else {
            IncrementalSnapshotMetadata prevIncSnpMeta;
            int prevIdx = req.incrementIndex() - 1;
            try {
                prevIncSnpMeta = this.readIncrementalSnapshotMetadata(req.snapshotName(), req.snapshotPath(), prevIdx);
            }
            catch (IOException | IgniteCheckedException e) {
                return new GridFinishedFuture<SnapshotOperationResponse>(e);
            }
            lowPtr = prevIncSnpMeta.incrementalSnapshotPointer();
        }
        IgniteInternalFuture<SnapshotOperationResponse> task0 = this.registerTask(req.snapshotName(), new IncrementalSnapshotFutureTask(this.cctx, req.operationalNodeId(), req.requestId(), meta, req.snapshotPath(), req.incrementIndex(), lowPtr, this.markWalFut)).chain(fut -> {
            if (fut.error() != null) {
                throw F.wrap(fut.error());
            }
            assert (incSnpDir.exists()) : "Incremental snapshot directory must exists";
            IncrementalSnapshotMetadata incMeta = new IncrementalSnapshotMetadata(req.requestId(), req.snapshotName(), req.incrementIndex(), this.cctx.localNode().consistentId().toString(), this.pdsSettings.folderName(), this.clusterSnpReq.startTime(), (WALPointer)this.markWalFut.result());
            this.storeSnapshotMeta(incMeta, new File(incSnpDir, IgniteSnapshotManager.snapshotMetaFileName(this.pdsSettings.folderName())));
            return new SnapshotOperationResponse();
        });
        if (task0.isDone()) {
            return task0;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Incremental snapshot operation submited for execution [snpName=" + req.snapshotName() + ", incIdx=" + req.incrementIndex());
        }
        this.cctx.kernalContext().pools().getSnapshotExecutorService().submit(() -> {
            SnapshotOperationRequest snpReq = this.clusterSnpReq;
            AbstractSnapshotFutureTask task = (AbstractSnapshotFutureTask)this.locSnpTasks.get(snpReq.snapshotName());
            if (task == null) {
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Incremental snapshot operation started [snpName=" + req.snapshotName() + ", incIdx=" + req.incrementIndex());
            }
            this.writeSnapshotDirectoryToMetastorage(incSnpDir);
            task.start();
        });
        return task0;
    }

    public IncrementalSnapshotMetadata readIncrementalSnapshotMetadata(String snpName, @Nullable String snpPath, int incIdx) throws IgniteCheckedException, IOException {
        return (IncrementalSnapshotMetadata)this.readFromFile(new File(this.incrementalSnapshotLocalDir(snpName, snpPath, incIdx), IgniteSnapshotManager.snapshotMetaFileName(this.pdsSettings.folderName())));
    }

    private IgniteInternalFuture<SnapshotOperationResponse> initLocalFullSnapshot(SnapshotOperationRequest req, List<Integer> grpIds, Collection<Integer> comprGrpIds, boolean withMetaStorage) {
        if (!GridCacheUtils.isPersistenceEnabled(this.cctx.gridConfig()) && req.snapshotPath() == null) {
            this.initLocalSnapshotDirectory(true);
        }
        HashMap<Integer, Set<Integer>> parts = new HashMap<Integer, Set<Integer>>();
        for (Integer grpId : grpIds) {
            if (this.cctx.cache().cacheGroup(grpId) == null) continue;
            CacheGroupContext grpCtx = this.cctx.cache().cacheGroup(grpId);
            AffinityTopologyVersion topVer = grpCtx.affinity().lastVersion();
            if (req.onlyPrimary()) {
                HashSet<Integer> include = new HashSet<Integer>(grpCtx.affinity().primaryPartitions(this.cctx.localNodeId(), topVer));
                include.remove(65535);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Snapshot only primary partitions [grpId=" + grpId + ", grpName=" + grpCtx.cacheOrGroupName() + ", parts=" + include + "]");
                }
                parts.put(grpId, include);
                continue;
            }
            parts.put(grpId, null);
        }
        AbstractSnapshotFutureTask<?> task0 = this.registerSnapshotTask(req.snapshotName(), req.snapshotPath(), req.operationalNodeId(), req.requestId(), parts, withMetaStorage, req.dump(), req.compress(), req.encrypt(), this.locSndrFactory.apply(req.snapshotName(), req.snapshotPath()));
        if (withMetaStorage) {
            assert (task0 instanceof SnapshotFutureTask);
            ((DistributedMetaStorageImpl)this.cctx.kernalContext().distributedMetastorage()).suspend(((SnapshotFutureTask)task0).started());
        }
        return task0.chain(() -> {
            if (task0.error() != null) {
                throw F.wrap(task0.error());
            }
            try {
                Set<String> blts = req.nodes().stream().map(n -> this.cctx.discovery().node((UUID)n).consistentId().toString()).collect(Collectors.toSet());
                File snpDir = this.snapshotLocalDir(req.snapshotName(), req.snapshotPath());
                snpDir.mkdirs();
                SnapshotFutureTaskResult res = (SnapshotFutureTaskResult)task0.result();
                Serializable encKey = req.encrypt() ? ((CreateDumpFutureTask)task0).encryptionKey() : null;
                EncryptionSpi encSpi = this.cctx.gridConfig().getEncryptionSpi();
                SnapshotMetadata meta = new SnapshotMetadata(req.requestId(), req.snapshotName(), this.cctx.localNode().consistentId().toString(), this.pdsSettings.folderName(), req.compress(), this.cctx.gridConfig().getDataStorageConfiguration().getPageSize(), grpIds, this.clusterSnpReq.startTime(), comprGrpIds, blts, res.parts(), res.snapshotPointer(), encSpi.masterKeyDigest(), req.onlyPrimary(), req.dump(), encKey == null ? null : encSpi.encryptKey(encKey));
                SnapshotHandlerContext ctx = new SnapshotHandlerContext(meta, req.groups(), this.cctx.localNode(), snpDir, req.streamerWarning(), true);
                req.meta(meta);
                File smf = new File(snpDir, IgniteSnapshotManager.snapshotMetaFileName(this.cctx.localNode().consistentId().toString()));
                this.storeSnapshotMeta(req.meta(), smf);
                this.log.info("Snapshot metafile has been created: " + smf.getAbsolutePath());
                return new SnapshotOperationResponse(this.handlers.invokeAll(SnapshotHandlerType.CREATE, ctx));
            }
            catch (IgniteCheckedException e) {
                throw F.wrap(e);
            }
        }, (Executor)this.snapshotExecutorService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLocalSnapshotStartStageResult(UUID id, Map<UUID, SnapshotOperationResponse> res, Map<UUID, Throwable> err) {
        SnapshotOperationRequest snpReq = this.clusterSnpReq;
        if (snpReq != null && F.eq(id, snpReq.requestId()) && snpReq.incremental()) {
            this.cctx.tm().txMessageTransformer(null);
            GridCompoundIdentityFuture<IgniteInternalTx> activeTxsFut = new GridCompoundIdentityFuture<IgniteInternalTx>();
            for (IgniteInternalTx tx : this.cctx.tm().activeTransactions()) {
                activeTxsFut.add(tx.finishFuture());
            }
            activeTxsFut.markInitialized();
            activeTxsFut.listen(() -> this.wrapMsgsFut.onDone());
        }
        if (this.cctx.kernalContext().clientNode()) {
            return;
        }
        boolean cancelled = err.values().stream().anyMatch(e -> e instanceof IgniteFutureCancelledCheckedException);
        if (snpReq == null || !snpReq.requestId().equals(id)) {
            Iterator<IgniteInternalTx> iterator = this.snpOpMux;
            synchronized (iterator) {
                if (this.clusterSnpFut != null && this.clusterSnpFut.rqId.equals(id)) {
                    if (cancelled) {
                        this.clusterSnpFut.onDone(new IgniteFutureCancelledCheckedException("Execution of snapshot tasks has been cancelled by external process [err=" + err + ", snpReq=" + snpReq + "]"));
                    } else {
                        this.clusterSnpFut.onDone(new IgniteCheckedException("Snapshot operation has not been fully completed [err=" + err + ", snpReq=" + snpReq + "]"));
                    }
                    this.clusterSnpFut = null;
                }
                return;
            }
        }
        snpReq.startStageEnded(true);
        if (IgniteUtils.isLocalNodeCoordinator(this.cctx.discovery())) {
            HashSet<UUID> missed = new HashSet<UUID>(snpReq.nodes());
            missed.removeAll(res.keySet());
            missed.removeAll(err.keySet());
            if (cancelled) {
                snpReq.error(new IgniteFutureCancelledCheckedException("Execution of snapshot tasks has been cancelled by external process [err=" + err + ", missed=" + missed + "]"));
            } else if (!missed.isEmpty()) {
                snpReq.error(new ClusterTopologyCheckedException("Snapshot operation interrupted, because baseline node left the cluster. Uncompleted snapshot will be deleted [missed=" + missed + "]"));
            } else if (!F.isEmpty(err)) {
                snpReq.error(new IgniteCheckedException("Execution of local snapshot tasks fails. Uncompleted snapshot will be deleted [err=" + err + "]"));
            }
            this.completeHandlersAsyncIfNeeded(snpReq, res.values()).listen(f -> {
                if (f.error() != null) {
                    snpReq.error(f.error());
                }
                this.endSnpProc.start(snpReq.requestId(), snpReq);
            });
        }
    }

    public <M extends Serializable> void storeSnapshotMeta(M meta, File smf) {
        if (smf.exists()) {
            throw new IgniteException("Snapshot metafile must not exist: " + smf.getAbsolutePath());
        }
        try (OutputStream out = Files.newOutputStream(smf.toPath(), new OpenOption[0]);){
            byte[] bytes = U.marshal(this.marsh, meta);
            int blockSize = 65536;
            for (int off = 0; off < bytes.length; off += blockSize) {
                int len = Math.min(blockSize, bytes.length - off);
                this.transferRateLimiter.acquire(len);
                out.write(bytes, off, len);
            }
        }
        catch (IOException | IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    private IgniteInternalFuture<Void> completeHandlersAsyncIfNeeded(SnapshotOperationRequest req, Collection<SnapshotOperationResponse> res) {
        if (req.error() != null) {
            return new GridFinishedFuture<Void>();
        }
        HashMap<String, List> clusterHndResults = new HashMap<String, List>();
        for (SnapshotOperationResponse snpRes : res) {
            if (snpRes == null || snpRes.handlerResults() == null) continue;
            for (Map.Entry<String, SnapshotHandlerResult<Object>> entry : snpRes.handlerResults().entrySet()) {
                clusterHndResults.computeIfAbsent(entry.getKey(), v -> new ArrayList()).add(entry.getValue());
            }
        }
        if (clusterHndResults.isEmpty()) {
            return new GridFinishedFuture<Void>();
        }
        try {
            GridFutureAdapter<Void> resultFut = new GridFutureAdapter<Void>();
            this.handlers().execSvc.submit(() -> {
                try {
                    this.handlers.completeAll(SnapshotHandlerType.CREATE, req.snapshotName(), clusterHndResults, req.nodes(), req::warnings);
                    resultFut.onDone();
                }
                catch (Exception e) {
                    this.log.warning("The snapshot operation will be aborted due to a handler error [snapshot=" + req.snapshotName() + "].", e);
                    resultFut.onDone(e);
                }
            });
            return resultFut;
        }
        catch (RejectedExecutionException e) {
            return new GridFinishedFuture<Void>(e);
        }
    }

    private IgniteInternalFuture<SnapshotOperationResponse> initLocalSnapshotEndStage(SnapshotOperationRequest req) {
        GridFutureAdapter<SnapshotOperationResponse> prepFut;
        SnapshotOperationRequest snpReq = this.clusterSnpReq;
        if (snpReq == null || !F.eq(req.requestId(), snpReq.requestId())) {
            return new GridFinishedFuture<SnapshotOperationResponse>();
        }
        IgniteInternalFuture<Object> igniteInternalFuture = prepFut = req.incremental() ? this.wrapMsgsFut : new GridFinishedFuture();
        if (this.cctx.kernalContext().clientNode()) {
            return prepFut;
        }
        return prepFut.chain(() -> {
            try {
                if (req.error() != null) {
                    snpReq.error(req.error());
                    if (req.incremental()) {
                        U.delete(this.incrementalSnapshotLocalDir(req.snapshotName(), req.snapshotPath(), req.incrementIndex()));
                    } else {
                        this.deleteSnapshot(this.snapshotLocalDir(req.snapshotName(), req.snapshotPath()), this.pdsSettings);
                    }
                } else if (!F.isEmpty(req.warnings())) {
                    if (!IgniteUtils.isLocalNodeCoordinator(this.cctx.discovery())) {
                        snpReq.warnings(req.warnings());
                    }
                    snpReq.meta().warnings(Collections.unmodifiableList(req.warnings()));
                    this.storeWarnings(snpReq);
                }
                if (req.dump()) {
                    this.removeDumpLock(req.snapshotName());
                } else {
                    this.removeLastMetaStorageKey();
                    if (req.error() == null) {
                        Collection grpIds = req.groups().stream().map(GridCacheUtils::cacheId).collect(Collectors.toList());
                        this.enableIncrementalSnapshotsCreation(grpIds);
                    }
                }
            }
            catch (Exception e) {
                throw F.wrap(e);
            }
            return new SnapshotOperationResponse();
        }, (Executor)this.cctx.kernalContext().pools().getSnapshotExecutorService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeWarnings(SnapshotOperationRequest snpReq) {
        assert (!F.isEmpty(snpReq.warnings()));
        List<ClusterNode> snpNodes = this.cctx.kernalContext().cluster().get().nodes().stream().filter(n -> snpReq.nodes().contains(n.id())).collect(Collectors.toList());
        boolean oldestBaseline = U.oldest(snpNodes, n -> CU.baselineNode(n, this.cctx.kernalContext().state().clusterState())).equals(this.cctx.localNode());
        if (!oldestBaseline) {
            return;
        }
        File snpDir = this.snapshotLocalDir(snpReq.snapshotName(), snpReq.snapshotPath());
        File tempSmf = new File(snpDir, IgniteSnapshotManager.snapshotMetaFileName(this.cctx.localNode().consistentId().toString()) + SNAPSHOT_METAFILE_TMP_EXT);
        File smf = new File(snpDir, IgniteSnapshotManager.snapshotMetaFileName(this.cctx.localNode().consistentId().toString()));
        try {
            this.storeSnapshotMeta(snpReq.meta(), tempSmf);
            Files.move(tempSmf.toPath(), smf.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Snapshot metafile has been rewrited with the warnings: " + smf.getAbsolutePath());
            }
        }
        catch (Exception e) {
            this.log.error("Failed to store warnings of snapshot '" + snpReq.snapshotName() + "' to the snapshot metafile. Snapshot won't contain them. The warnings: [" + String.join((CharSequence)",", snpReq.warnings()) + "].", e);
        }
        finally {
            U.delete(tempSmf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLocalSnapshotEndStageResult(UUID id, Map<UUID, SnapshotOperationResponse> res, Map<UUID, Throwable> err) {
        SnapshotOperationRequest snpReq = this.clusterSnpReq;
        if (snpReq == null || !F.eq(id, snpReq.requestId())) {
            return;
        }
        HashSet<UUID> endFail = new HashSet<UUID>(snpReq.nodes());
        endFail.removeAll(res.keySet());
        if (snpReq.incremental()) {
            this.wrapMsgsFut = null;
            this.markWalFut = null;
            this.incSnpId = null;
            if (this.clusterSnpFut != null && endFail.isEmpty() && snpReq.error() == null) {
                this.warnAtomicCachesInIncrementalSnapshot(snpReq.snapshotName(), snpReq.incrementIndex(), snpReq.groups());
            }
        }
        this.clusterSnpReq = null;
        Object object = this.snpOpMux;
        synchronized (object) {
            if (this.clusterSnpFut != null) {
                if (endFail.isEmpty() && snpReq.error() == null) {
                    if (!F.isEmpty(snpReq.warnings())) {
                        String wrnsLst = U.nl() + "\t- " + String.join((CharSequence)(U.nl() + "\t- "), snpReq.warnings());
                        SnapshotWarningException wrn = new SnapshotWarningException("Snapshot task '" + snpReq.snapshotName() + "' completed with the warnings:" + wrnsLst);
                        this.clusterSnpFut.onDone(wrn);
                        this.log.warning(SNAPSHOT_FINISHED_WRN_MSG + snpReq + ". Warnings:" + wrnsLst);
                    } else {
                        this.clusterSnpFut.onDone();
                        if (this.log.isInfoEnabled()) {
                            this.log.info(SNAPSHOT_FINISHED_MSG + snpReq);
                        }
                    }
                } else if (snpReq.error() == null) {
                    this.clusterSnpFut.onDone(new IgniteCheckedException("Snapshot creation has been finished with an error. Local snapshot tasks may not finished completely or finalizing results fails [fail=" + endFail + ", err=" + err + "]"));
                } else {
                    this.clusterSnpFut.onDone(snpReq.error());
                }
                this.clusterSnpFut = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSnapshotCreating() {
        if (this.clusterSnpReq != null) {
            return true;
        }
        Object object = this.snpOpMux;
        synchronized (object) {
            return this.clusterSnpReq != null || this.clusterSnpFut != null;
        }
    }

    public void streamerWarning() {
        SnapshotOperationRequest snpTask = this.currentCreateRequest();
        if (snpTask != null && !snpTask.streamerWarning()) {
            snpTask.streamerWarning(true);
        }
    }

    @Nullable
    public SnapshotOperationRequest currentCreateRequest() {
        return this.clusterSnpReq;
    }

    public boolean isRestoring() {
        return this.restoreCacheGrpProc.restoringSnapshotName() != null;
    }

    public boolean isRestoring(String snpName) {
        return snpName.equals(this.restoreCacheGrpProc.restoringSnapshotName());
    }

    public boolean isRestoring(CacheConfiguration<?, ?> ccfg) {
        return this.restoreCacheGrpProc.isRestoring(ccfg);
    }

    public IgniteFuture<Boolean> restoreStatus(String snpName) {
        return this.executeRestoreManagementTask(SnapshotRestoreStatusTask.class, snpName);
    }

    public boolean sequentialWrite() {
        return this.sequentialWrite;
    }

    public Set<UUID> cacheStartRequiredAliveNodes(@Nullable IgniteUuid restoreId) {
        if (restoreId == null) {
            return Collections.emptySet();
        }
        return this.restoreCacheGrpProc.cacheStartRequiredAliveNodes(restoreId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> localSnapshotNames(@Nullable String snpPath) {
        if (this.cctx.kernalContext().clientNode()) {
            throw new UnsupportedOperationException("Client nodes can not perform this operation.");
        }
        if (this.locSnpDir == null) {
            return Collections.emptyList();
        }
        Object object = this.snpOpMux;
        synchronized (object) {
            File[] dirs = (snpPath == null ? this.locSnpDir : new File(snpPath)).listFiles(File::isDirectory);
            if (dirs == null) {
                return Collections.emptyList();
            }
            return Arrays.stream(dirs).map(File::getName).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int maxLocalIncrementSnapshot(String snpName, @Nullable String snpPath) {
        if (this.cctx.kernalContext().clientNode()) {
            throw new UnsupportedOperationException("Client and daemon nodes can not perform this operation.");
        }
        Object object = this.snpOpMux;
        synchronized (object) {
            File[] incDirs = this.incrementalSnapshotsLocalRootDir(snpName, snpPath).listFiles(File::isDirectory);
            if (incDirs == null) {
                return 0;
            }
            return Arrays.stream(incDirs).map(File::getName).filter(name -> INC_SNP_NAME_PATTERN.matcher((CharSequence)name).matches()).mapToInt(Integer::parseInt).max().orElse(0);
        }
    }

    @Override
    public IgniteFuture<Void> cancelSnapshot(String name) {
        return new IgniteFutureImpl<Void>(this.cancelSnapshot0(name).chain(() -> null));
    }

    private IgniteInternalFuture<Boolean> cancelSnapshot0(String name) {
        A.notNullOrEmpty(name, "Snapshot name must be not empty or null");
        this.cctx.kernalContext().security().authorize(SecurityPermission.ADMIN_SNAPSHOT);
        return this.cctx.kernalContext().closure().callAsync(GridClosureCallMode.BROADCAST, new CancelSnapshotCallable(null, name), TaskExecutionOptions.options(this.cctx.discovery().aliveServerNodes()).withFailoverDisabled());
    }

    public IgniteFuture<Boolean> cancelSnapshotOperation(UUID reqId) {
        A.notNull(reqId, "Snapshot operation request ID must be not null");
        this.cctx.kernalContext().security().authorize(SecurityPermission.ADMIN_SNAPSHOT);
        IgniteInternalFuture<Boolean> fut0 = this.cctx.kernalContext().closure().callAsync(GridClosureCallMode.BROADCAST, new CancelSnapshotCallable(reqId, null), TaskExecutionOptions.options(this.cctx.discovery().aliveServerNodes()).withFailoverDisabled());
        return new IgniteFutureImpl<Boolean>(fut0);
    }

    private boolean cancelLocalSnapshotOperations(UUID reqId) {
        A.notNull(reqId, "Snapshot operation request ID must be not null");
        if (this.cancelLocalSnapshotTask0(task -> reqId.equals(task.requestId()))) {
            return true;
        }
        return this.restoreCacheGrpProc.cancel(reqId, null).get();
    }

    public boolean cancelLocalSnapshotTask(String name) {
        A.notNullOrEmpty(name, "Snapshot name must be not null or empty");
        return this.cancelLocalSnapshotTask0(task -> name.equals(task.snapshotName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelLocalSnapshotTask0(Function<AbstractSnapshotFutureTask<?>, Boolean> filter) {
        ClusterSnapshotFuture fut0 = null;
        boolean canceled = false;
        this.busyLock.enterBusy();
        try {
            for (AbstractSnapshotFutureTask sctx : this.locSnpTasks.values()) {
                if (!filter.apply(sctx).booleanValue()) continue;
                canceled |= sctx.cancel();
            }
            Object object = this.snpOpMux;
            synchronized (object) {
                if (this.clusterSnpFut != null) {
                    fut0 = this.clusterSnpFut;
                }
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
        try {
            if (fut0 != null) {
                fut0.get();
            }
        }
        catch (IgniteCheckedException e) {
            if (e instanceof IgniteFutureCancelledCheckedException) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Expected cancelled exception: " + e.getMessage());
                }
            }
            throw new IgniteException(e);
        }
        return canceled;
    }

    @Override
    public IgniteFuture<Boolean> cancelSnapshotRestore(String name) {
        return new IgniteFutureImpl<Boolean>(this.cancelSnapshot0(name));
    }

    @Override
    public IgniteFuture<Void> createDump(String name, @Nullable Collection<String> cacheGrpNames) {
        return this.createSnapshot(name, null, cacheGrpNames, false, false, true, false, false);
    }

    @Deprecated
    public IgniteFuture<Boolean> cancelLocalRestoreTask(String name) {
        return this.restoreCacheGrpProc.cancel(null, name);
    }

    public IgniteInternalFuture<SnapshotPartitionsVerifyTaskResult> checkSnapshot(String name, @Nullable String snpPath) {
        return this.checkSnapshot(name, snpPath, -1);
    }

    public IgniteInternalFuture<SnapshotPartitionsVerifyTaskResult> checkSnapshot(String name, @Nullable String snpPath, int incIdx) {
        A.notNullOrEmpty(name, "Snapshot name cannot be null or empty.");
        A.ensure(U.alphanumericUnderscore(name), "Snapshot name must satisfy the following name pattern: a-zA-Z0-9_");
        this.cctx.kernalContext().security().authorize(SecurityPermission.ADMIN_SNAPSHOT);
        return this.checkSnapshot(name, snpPath, null, false, incIdx, true).chain(f -> {
            try {
                return (SnapshotPartitionsVerifyTaskResult)f.get();
            }
            catch (Throwable t) {
                throw new GridClosureException(t);
            }
        });
    }

    public IgniteInternalFuture<SnapshotPartitionsVerifyTaskResult> checkSnapshot(String name, @Nullable String snpPath, @Nullable Collection<String> grps, boolean includeCustomHandlers, int incIdx, boolean check) {
        A.notNullOrEmpty(name, "Snapshot name cannot be null or empty.");
        A.ensure(U.alphanumericUnderscore(name), "Snapshot name must satisfy the following name pattern: a-zA-Z0-9_");
        A.ensure(grps == null || grps.stream().filter(Objects::isNull).collect(Collectors.toSet()).isEmpty(), "Collection of cache groups names cannot contain null elements.");
        GridFutureAdapter<SnapshotPartitionsVerifyTaskResult> res = new GridFutureAdapter<SnapshotPartitionsVerifyTaskResult>();
        if (this.log.isInfoEnabled()) {
            this.log.info("The check snapshot procedure started [snpName=" + name + ", snpPath=" + snpPath + ", incIdx=" + incIdx + ", grps=" + grps + "]");
        }
        GridKernalContext kctx0 = this.cctx.kernalContext();
        Collection<ClusterNode> bltNodes = F.view(this.cctx.discovery().serverNodes(AffinityTopologyVersion.NONE), node -> CU.baselineNode(node, kctx0.state().clusterState()));
        Set<Integer> grpIds = grps == null ? Collections.emptySet() : F.viewReadOnly(grps, GridCacheUtils::cacheId, new IgnitePredicate[0]);
        SnapshotMetadataVerificationTaskArg taskArg = new SnapshotMetadataVerificationTaskArg(name, snpPath, incIdx, grpIds);
        kctx0.task().execute(SnapshotMetadataVerificationTask.class, taskArg, TaskExecutionOptions.options(bltNodes)).listen(f0 -> {
            SnapshotMetadataVerificationTaskResult metasRes = (SnapshotMetadataVerificationTaskResult)f0.result();
            if (f0.error() == null && F.isEmpty(metasRes.exceptions())) {
                Map<ClusterNode, List<SnapshotMetadata>> metas = metasRes.meta();
                Class cls = includeCustomHandlers ? SnapshotHandlerRestoreTask.class : (incIdx > 0 ? IncrementalSnapshotVerificationTask.class : SnapshotPartitionsVerifyTask.class);
                kctx0.task().execute(cls, new SnapshotPartitionsVerifyTaskArg(grps, metas, snpPath, incIdx, check), TaskExecutionOptions.options(new ArrayList<ClusterNode>(metas.keySet()))).listen(f1 -> {
                    if (f1.error() == null) {
                        res.onDone((SnapshotPartitionsVerifyTaskResult)f1.result());
                    } else if (f1.error() instanceof IgniteSnapshotVerifyException) {
                        res.onDone(new SnapshotPartitionsVerifyTaskResult(metas, new IdleVerifyResultV2(((IgniteSnapshotVerifyException)f1.error()).exceptions())));
                    } else {
                        res.onDone(f1.error());
                    }
                });
            } else if (f0.error() == null) {
                res.onDone(new IgniteSnapshotVerifyException(metasRes.exceptions()));
            } else if (f0.error() instanceof IgniteSnapshotVerifyException) {
                res.onDone(new SnapshotPartitionsVerifyTaskResult(null, new IdleVerifyResultV2(((IgniteSnapshotVerifyException)f0.error()).exceptions())));
            } else {
                res.onDone(f0.error());
            }
        });
        if (this.log.isInfoEnabled()) {
            res.listen(() -> this.log.info("The check snapshot procedure finished [snpName=" + name + ", snpPath=" + snpPath + ", incIdx=" + incIdx + ", grps=" + grps + "]"));
        }
        return res;
    }

    public List<File> snapshotCacheDirectories(String snpName, @Nullable String snpPath, String folderName, Predicate<String> names) {
        File snpDir = this.snapshotLocalDir(snpName, snpPath);
        if (!snpDir.exists()) {
            return Collections.emptyList();
        }
        return FilePageStoreManager.cacheDirectories(new File(snpDir, IgniteSnapshotManager.databaseRelativePath(folderName)), names);
    }

    public SnapshotMetadata readSnapshotMetadata(File snpDir, String consId) throws IgniteCheckedException, IOException {
        return this.readSnapshotMetadata(new File(snpDir, IgniteSnapshotManager.snapshotMetaFileName(consId)));
    }

    private SnapshotMetadata readSnapshotMetadata(File smf) throws IgniteCheckedException, IOException {
        SnapshotMetadata meta = (SnapshotMetadata)this.readFromFile(smf);
        String smfName = smf.getName().substring(0, smf.getName().length() - SNAPSHOT_METAFILE_EXT.length());
        if (!U.maskForFileName(meta.consistentId()).equals(smfName)) {
            throw new IgniteException("Error reading snapshot metadata [smfName=" + smfName + ", consId=" + U.maskForFileName(meta.consistentId()));
        }
        return meta;
    }

    public <T> T readFromFile(File smf) throws IgniteCheckedException, IOException {
        if (!smf.exists()) {
            throw new IgniteCheckedException("Snapshot metafile cannot be read due to it doesn't exist: " + smf);
        }
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(smf.toPath(), new OpenOption[0]));){
            Object t = this.marsh.unmarshal(in, U.resolveClassLoader(this.cctx.gridConfig()));
            return t;
        }
    }

    public List<SnapshotMetadata> readSnapshotMetadatas(String snpName, @Nullable String snpPath) {
        A.notNullOrEmpty(snpName, "Snapshot name cannot be null or empty.");
        A.ensure(U.alphanumericUnderscore(snpName), "Snapshot name must satisfy the following name pattern: a-zA-Z0-9_");
        File snpDir = this.snapshotLocalDir(snpName, snpPath);
        if (!snpDir.exists() || !snpDir.isDirectory()) {
            return Collections.emptyList();
        }
        ArrayList<File> smfs = new ArrayList<File>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(snpDir.toPath());){
            for (Path path : ds) {
                if (!Files.isRegularFile(path, new LinkOption[0]) || !path.getFileName().toString().toLowerCase().endsWith(SNAPSHOT_METAFILE_EXT)) continue;
                smfs.add(path.toFile());
            }
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
        if (smfs.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, SnapshotMetadata> metasMap = new HashMap<String, SnapshotMetadata>();
        SnapshotMetadata prev = null;
        try {
            for (File smf : smfs) {
                SnapshotMetadata curr = this.readSnapshotMetadata(smf);
                if (prev != null && !prev.sameSnapshot(curr)) {
                    throw new IgniteException("Snapshot metadata files are from different snapshots [prev=" + prev + ", curr=" + curr + "]");
                }
                metasMap.put(curr.consistentId(), curr);
                prev = curr;
            }
        }
        catch (IOException | IgniteCheckedException exception) {
            throw new IgniteException(exception);
        }
        SnapshotMetadata snapshotMetadata = (SnapshotMetadata)metasMap.remove(this.cctx.localNode().consistentId().toString());
        if (snapshotMetadata == null) {
            return new ArrayList<SnapshotMetadata>(metasMap.values());
        }
        ArrayList<SnapshotMetadata> result = new ArrayList<SnapshotMetadata>();
        result.add(snapshotMetadata);
        result.addAll(metasMap.values());
        return result;
    }

    public Collection<IncrementalSnapshotMetadata> readIncrementalSnapshotMetadatas(String snpName) {
        File[] incDirs = this.incrementalSnapshotsLocalRootDir(snpName, null).listFiles((dir, name) -> INC_SNP_NAME_PATTERN.matcher(name).matches());
        if (incDirs == null) {
            return Collections.emptyList();
        }
        ArrayList<IncrementalSnapshotMetadata> metas = new ArrayList<IncrementalSnapshotMetadata>();
        try {
            for (File incDir : incDirs) {
                for (File metaFile : incDir.listFiles((dir, name) -> name.endsWith(SNAPSHOT_METAFILE_EXT))) {
                    metas.add((IncrementalSnapshotMetadata)this.readFromFile(metaFile));
                }
            }
        }
        catch (IOException | IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        return metas;
    }

    @Override
    public IgniteFuture<Void> createSnapshot(String name) {
        return this.createSnapshot(name, null, false, false);
    }

    @Override
    public IgniteFuture<Void> createIncrementalSnapshot(String name) {
        return this.createSnapshot(name, null, true, false);
    }

    public IgniteFutureImpl<Void> createSnapshot(String name, @Nullable String snpPath, boolean incremental, boolean onlyPrimary) {
        return this.createSnapshot(name, snpPath, null, incremental, onlyPrimary, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteFutureImpl<Void> createSnapshot(String name, @Nullable String snpPath, @Nullable Collection<String> cacheGrpNames, boolean incremental, boolean onlyPrimary, boolean dump, boolean compress, boolean encrypt) {
        A.notNullOrEmpty(name, "Snapshot name cannot be null or empty.");
        A.ensure(U.alphanumericUnderscore(name), "Snapshot name must satisfy the following name pattern: a-zA-Z0-9_");
        A.ensure(!incremental || !onlyPrimary, "Only primary not supported for incremental snapshots");
        A.ensure(!dump || !incremental, "Incremental dump not supported");
        A.ensure(cacheGrpNames == null || dump, "Cache group names filter supported only for dump");
        A.ensure(!compress || dump, "Compression is supported only for dumps");
        try {
            ClusterSnapshotFuture snpFut0;
            this.cctx.kernalContext().security().authorize(SecurityPermission.ADMIN_SNAPSHOT);
            if (!this.cctx.kernalContext().state().clusterState().state().active()) {
                throw new IgniteException("Snapshot operation has been rejected. The cluster is inactive.");
            }
            DiscoveryDataClusterState clusterState = this.cctx.kernalContext().state().clusterState();
            if (!clusterState.hasBaselineTopology()) {
                throw new IgniteException("Snapshot operation has been rejected. The baseline topology is not configured for cluster.");
            }
            if (this.cctx.kernalContext().clientNode()) {
                ClusterNode crd = U.oldest(this.cctx.kernalContext().discovery().aliveServerNodes(), null);
                if (crd == null) {
                    throw new IgniteException("There is no alive server nodes in the cluster");
                }
                return new IgniteSnapshotFutureImpl(this.cctx.kernalContext().closure().callAsync(GridClosureCallMode.BALANCE, new CreateSnapshotCallable(name, cacheGrpNames, incremental, onlyPrimary, dump, compress, encrypt), TaskExecutionOptions.options(Collections.singletonList(crd)).withFailoverDisabled()));
            }
            A.ensure(!encrypt || dump, "Encryption key is supported only for dumps");
            A.ensure(!encrypt || this.cctx.gridConfig().getEncryptionSpi() != null, "Encryption SPI must be set to encrypt dump");
            if (!CU.isPersistenceEnabled(this.cctx.gridConfig()) && !dump) {
                throw new IgniteException("Create snapshot request has been rejected. Snapshots on an in-memory clusters are not allowed.");
            }
            int incIdx = -1;
            Object object = this.snpOpMux;
            synchronized (object) {
                if (this.clusterSnpFut != null && !this.clusterSnpFut.isDone()) {
                    throw new IgniteException("Create snapshot request has been rejected. The previous snapshot operation was not completed.");
                }
                if (this.clusterSnpReq != null) {
                    throw new IgniteException("Create snapshot request has been rejected. Parallel snapshot processes are not allowed.");
                }
                boolean snpExists = this.localSnapshotNames(snpPath).contains(name);
                if (!incremental && snpExists) {
                    throw new IgniteException("Create snapshot request has been rejected. Snapshot with given name already exists on local node.");
                }
                if (incremental) {
                    if (!this.cctx.gridConfig().getDataStorageConfiguration().isWalCompactionEnabled()) {
                        throw new IgniteException("Create incremental snapshot request has been rejected. WAL compaction must be enabled.");
                    }
                    if (!snpExists) {
                        throw new IgniteException("Create incremental snapshot request has been rejected. Base snapshot with given name doesn't exist on local node.");
                    }
                    incIdx = this.maxLocalIncrementSnapshot(name, snpPath) + 1;
                }
                if (this.isRestoring()) {
                    throw new IgniteException("Snapshot operation has been rejected. Cache group restore operation is currently in progress.");
                }
                this.clusterSnpFut = snpFut0 = new ClusterSnapshotFuture(UUID.randomUUID(), name, incIdx);
                if (incremental) {
                    this.lastSeenIncSnpFut = snpFut0;
                } else {
                    this.lastSeenSnpFut = snpFut0;
                }
            }
            HashSet<String> cacheGrpNames0 = cacheGrpNames == null ? null : new HashSet<String>(cacheGrpNames);
            List<String> grps = (dump ? this.cctx.cache().cacheGroupDescriptors().values() : this.cctx.cache().persistentGroups()).stream().map(CacheGroupDescriptor::cacheOrGroupName).filter(n -> cacheGrpNames0 == null || cacheGrpNames0.remove(n)).filter(cacheName -> this.cctx.cache().cacheType((String)cacheName) == CacheType.USER).collect(Collectors.toList());
            if (!F.isEmpty(cacheGrpNames0)) {
                this.log.warning("Unknown cache groups will not be included in snapshot [grps=" + cacheGrpNames0 + "]");
            }
            if (!dump) {
                grps.add("MetaStorage");
            } else if (grps.isEmpty()) {
                throw new IgniteException("Dump operation has been rejected. No cache group defined in cluster");
            }
            List<ClusterNode> srvNodes = this.cctx.discovery().serverNodes(AffinityTopologyVersion.NONE);
            snpFut0.listen(() -> {
                if (snpFut0.error() == null) {
                    this.recordSnapshotEvent(name, SNAPSHOT_FINISHED_MSG + grps, 150);
                } else {
                    String errMsgPref = snpFut0.error() instanceof SnapshotWarningException ? SNAPSHOT_FINISHED_WRN_MSG : SNAPSHOT_FAILED_MSG;
                    this.recordSnapshotEvent(name, errMsgPref + snpFut0.error().getMessage(), 151);
                }
            });
            HashSet<UUID> bltNodeIds = new HashSet<UUID>(F.viewReadOnly(srvNodes, F.node2id(), node -> CU.baselineNode(node, clusterState)));
            SnapshotOperationRequest snpOpReq = new SnapshotOperationRequest(snpFut0.rqId, this.cctx.localNodeId(), name, snpPath, grps, bltNodeIds, incremental, incIdx, onlyPrimary, dump, compress, encrypt);
            this.startSnpProc.start(snpFut0.rqId, snpOpReq);
            String msg = SNAPSHOT_STARTED_MSG + snpOpReq;
            this.recordSnapshotEvent(name, msg, 149);
            if (this.log.isInfoEnabled()) {
                this.log.info(msg);
            }
            return new IgniteFutureImpl<Void>(snpFut0);
        }
        catch (Exception e) {
            this.recordSnapshotEvent(name, SNAPSHOT_FAILED_MSG + e.getMessage(), 151);
            U.error(this.log, SNAPSHOT_FAILED_MSG, e);
            ClusterSnapshotFuture errSnpFut = new ClusterSnapshotFuture(name, e);
            if (incremental) {
                this.lastSeenIncSnpFut = errSnpFut;
            } else {
                this.lastSeenSnpFut = errSnpFut;
            }
            return new IgniteFinishedFutureImpl<Void>(e);
        }
    }

    void warnAtomicCachesInIncrementalSnapshot(String snpName, int incIdx, Collection<String> cacheGrps) {
        ArrayList<String> warnCaches = new ArrayList<String>();
        for (String cacheGrp : cacheGrps) {
            CacheGroupContext cgctx = this.cctx.cache().cacheGroup(CU.cacheId(cacheGrp));
            if (cgctx == null || !cgctx.hasAtomicCaches()) continue;
            for (GridCacheContext<?, ?> c : cgctx.caches()) {
                CacheConfiguration ccfg = c.config();
                if (ccfg.getAtomicityMode() != CacheAtomicityMode.ATOMIC || ccfg.getBackups() <= 0) continue;
                warnCaches.add(ccfg.getName());
            }
        }
        if (warnCaches.isEmpty()) {
            return;
        }
        U.warn(this.log, "Incremental snapshot [snpName=" + snpName + ", incIdx=" + incIdx + "] contains ATOMIC caches with backups: " + warnCaches + ". Please note, incremental snapshots doesn't guarantee consistency of restored atomic caches. It is highly recommended to verify these caches after restoring with the \"idle_verify\" command. If it is needed it's possible to repair inconsistent partitions with the \"consistency\" command. Please, check the \"Control Script\" section of Ignite docs for more information about these commands.");
    }

    @Override
    public IgniteFuture<Void> restoreSnapshot(String name, @Nullable Collection<String> grpNames) {
        return this.restoreSnapshot(name, null, grpNames, 0, false);
    }

    @Override
    public IgniteFuture<Void> restoreSnapshot(String name, @Nullable Collection<String> grpNames, int incIdx) {
        A.ensure(incIdx > 0, "Incremental snapshot index must be greater than 0.");
        return this.restoreSnapshot(name, null, grpNames, incIdx, false);
    }

    public IgniteFutureImpl<Void> restoreSnapshot(String name, @Nullable String snpPath, @Nullable Collection<String> grpNames) {
        return this.restoreSnapshot(name, snpPath, grpNames, 0, false);
    }

    public IgniteFutureImpl<Void> restoreSnapshot(String name, @Nullable String snpPath, @Nullable Collection<String> grpNames, int incIdx, boolean check) {
        A.notNullOrEmpty(name, "Snapshot name cannot be null or empty.");
        A.ensure(U.alphanumericUnderscore(name), "Snapshot name must satisfy the following name pattern: a-zA-Z0-9_");
        A.ensure(grpNames == null || !grpNames.isEmpty(), "List of cache group names cannot be empty.");
        this.cctx.kernalContext().security().authorize(SecurityPermission.ADMIN_SNAPSHOT);
        return this.restoreCacheGrpProc.start(name, snpPath, grpNames, incIdx, check);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metaStorage) throws IgniteCheckedException {
        Object object = this.snpOpMux;
        synchronized (object) {
            this.metaStorage = metaStorage;
            if (this.recovered) {
                this.removeLastMetaStorageKey();
            }
            this.recovered = false;
        }
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metaStorage) throws IgniteCheckedException {
        File snpDir;
        String snpDirName;
        this.restoreCacheGrpProc.cleanup();
        String snpName = (String)((Object)metaStorage.read(SNP_RUNNING_KEY));
        String string = snpDirName = snpName == null ? (String)((Object)metaStorage.read(SNP_RUNNING_DIR_KEY)) : null;
        File file = snpName != null ? this.snapshotLocalDir(snpName, null) : (snpDir = snpDirName != null ? new File(snpDirName) : null);
        if (snpDir == null) {
            return;
        }
        this.recovered = true;
        for (File tmp : this.snapshotTmpDir().listFiles()) {
            U.delete(tmp);
        }
        if (INC_SNP_NAME_PATTERN.matcher(snpDir.getName()).matches() && snpDir.getAbsolutePath().contains(INC_SNP_DIR)) {
            U.delete(snpDir);
        } else {
            this.deleteSnapshot(snpDir, this.pdsSettings);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Previous attempt to create snapshot fail due to the local node crash. All resources related to snapshot operation have been deleted: " + snpDir.getName());
        }
    }

    public static boolean isSnapshotOperation(DiscoveryEvent evt) {
        return !evt.eventNode().isClient() && evt.type() == 18 && ((DiscoveryCustomEvent)evt).customMessage() instanceof SnapshotStartDiscoveryMessage;
    }

    @Override
    public void onDoneBeforeTopologyUnlock(GridDhtPartitionsExchangeFuture fut) {
        if (this.clusterSnpReq == null || this.cctx.kernalContext().clientNode() || !IgniteSnapshotManager.isSnapshotOperation(fut.firstEvent())) {
            return;
        }
        SnapshotOperationRequest snpReq = this.clusterSnpReq;
        if (snpReq.incremental()) {
            return;
        }
        AbstractSnapshotFutureTask task = (AbstractSnapshotFutureTask)this.locSnpTasks.get(snpReq.snapshotName());
        if (task == null) {
            return;
        }
        if (task.start()) {
            this.cctx.database().forceNewCheckpoint(String.format("Start snapshot operation: %s", snpReq.snapshotName()), lsnr -> {});
            try {
                long start = U.currentTimeMillis();
                ((SnapshotFutureTask)task).started().get();
                if (this.log.isInfoEnabled()) {
                    this.log.info("Finished waiting for a synchronized checkpoint under topology lock [snpName=" + task.snapshotName() + ", time=" + (U.currentTimeMillis() - start) + "ms]");
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Fail to wait while cluster-wide snapshot operation started", e);
            }
        }
    }

    public IgniteInternalFuture<Void> requestRemoteSnapshotFiles(UUID rmtNodeId, UUID reqId, String snpName, @Nullable String rmtSnpPath, Map<Integer, Set<Integer>> parts, BooleanSupplier stopChecker, BiConsumer<@Nullable File, @Nullable Throwable> partHnd) throws IgniteCheckedException {
        assert (U.alphanumericUnderscore(snpName)) : snpName;
        assert (partHnd != null);
        ClusterNode rmtNode = this.cctx.discovery().node(rmtNodeId);
        if (rmtNode == null) {
            throw new ClusterTopologyCheckedException("Snapshot remote request cannot be performed. Remote node left the grid [rmtNodeId=" + rmtNodeId + "]");
        }
        RemoteSnapshotFilesRecevier fut = new RemoteSnapshotFilesRecevier(this, rmtNodeId, reqId, snpName, rmtSnpPath, parts, stopChecker, partHnd);
        this.snpRmtMgr.submit(fut);
        return fut;
    }

    public void onCacheGroupsStopped(List<Integer> grps) {
        Collection<AbstractSnapshotFutureTask> tasks = F.view(this.locSnpTasks.values(), t -> t instanceof SnapshotFutureTask || t instanceof CreateDumpFutureTask);
        for (AbstractSnapshotFutureTask sctx : tasks) {
            HashSet<Integer> retain = new HashSet<Integer>(grps);
            retain.retainAll(sctx.affectedCacheGroups());
            if (retain.isEmpty()) continue;
            sctx.acceptException(new IgniteCheckedException("Snapshot has been interrupted due to some of the required cache groups stopped: " + retain));
        }
    }

    public static String snapshotMetaFileName(String consId) {
        return U.maskForFileName(consId) + SNAPSHOT_METAFILE_EXT;
    }

    public StandaloneGridKernalContext createStandaloneKernalContext(CompressionProcessor cmpProc, File snpDir, String folderName) throws IgniteCheckedException {
        return new StandaloneGridKernalContext(this.log, cmpProc, CacheObjectBinaryProcessorImpl.resolveBinaryWorkDir(snpDir.getAbsolutePath(), folderName), MarshallerContextImpl.resolveMappingFileStoreWorkDir(snpDir.getAbsolutePath()));
    }

    public GridCloseableIterator<CacheDataRow> partitionRowIterator(GridKernalContext ctx, String grpName, int partId, FilePageStore pageStore) throws IgniteCheckedException {
        CacheObjectContext coctx = new CacheObjectContext(ctx, grpName, null, false, false, false, false, false);
        GridCacheSharedContext sctx = GridCacheSharedContext.builder().build(ctx, null);
        return new DataPageIterator(sctx, coctx, pageStore, partId);
    }

    public GridCloseableIterator<CacheDataRow> partitionRowIterator(String snpName, String folderName, String grpName, int partId, @Nullable EncryptionCacheKeyProvider encrKeyProvider) throws IgniteCheckedException {
        File snpDir = this.resolveSnapshotDir(snpName, null);
        File nodePath = new File(snpDir, IgniteSnapshotManager.databaseRelativePath(folderName));
        if (!nodePath.exists()) {
            throw new IgniteCheckedException("Consistent id directory doesn't exists: " + nodePath.getAbsolutePath());
        }
        List<File> grps = FilePageStoreManager.cacheDirectories(nodePath, name -> name.equals(grpName));
        if (F.isEmpty(grps)) {
            throw new IgniteCheckedException("The snapshot cache group not found [dir=" + snpDir.getAbsolutePath() + ", grpName=" + grpName + "]");
        }
        if (grps.size() > 1) {
            throw new IgniteCheckedException("The snapshot cache group directory cannot be uniquely identified [dir=" + snpDir.getAbsolutePath() + ", grpName=" + grpName + "]");
        }
        File snpPart = FilePageStoreManager.getPartitionFile(new File(this.snapshotLocalDir(snpName, null), IgniteSnapshotManager.databaseRelativePath(folderName)), grps.get(0).getName(), partId);
        int grpId = CU.cacheId(grpName);
        final FilePageStore pageStore = (FilePageStore)this.storeMgr.getPageStoreFactory(grpId, encrKeyProvider == null || encrKeyProvider.getActiveKey(grpId) == null ? null : encrKeyProvider).createPageStore(GroupPartitionId.getTypeByPartId(partId), snpPart::toPath, val -> {});
        final GridCloseableIterator<CacheDataRow> partIter = this.partitionRowIterator(this.cctx.kernalContext(), grpName, partId, pageStore);
        return new GridCloseableIteratorAdapter<CacheDataRow>(){

            @Override
            protected CacheDataRow onNext() throws IgniteCheckedException {
                return (CacheDataRow)partIter.nextX();
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                return partIter.hasNextX();
            }

            @Override
            protected void onClose() {
                U.closeQuiet(pageStore);
            }
        };
    }

    AbstractSnapshotFutureTask<?> registerSnapshotTask(String snpName, @Nullable String snpPath, UUID srcNodeId, UUID reqId, Map<Integer, Set<Integer>> parts, boolean withMetaStorage, boolean dump, boolean compress, boolean encrypt, SnapshotSender snpSndr) {
        AbstractSnapshotFutureTask<?> task = this.registerTask(snpName, dump ? new CreateDumpFutureTask(this.cctx, srcNodeId, reqId, snpName, this.snapshotLocalDir(snpName, snpPath), this.ioFactory, this.transferRateLimiter, snpSndr, parts, compress, encrypt) : new SnapshotFutureTask(this.cctx, srcNodeId, reqId, snpName, this.tmpWorkDir, this.ioFactory, snpSndr, parts, withMetaStorage, this.locBuff));
        if (!withMetaStorage) {
            for (Integer grpId : parts.keySet()) {
                if (!this.cctx.cache().isEncrypted(grpId)) continue;
                task.onDone(new IgniteCheckedException("Snapshot contains encrypted cache group " + grpId + " but doesn't include metastore. Metastore is required because it holds encryption keys required to start with encrypted caches contained in the snapshot."));
                return task;
            }
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractSnapshotFutureTask<?> registerTask(String rqId, AbstractSnapshotFutureTask<?> task) {
        if (!this.busyLock.enterBusy()) {
            return new SnapshotFinishedFutureTask(new IgniteCheckedException("Snapshot manager is stopping [locNodeId=" + this.cctx.localNodeId() + "]"));
        }
        try {
            AbstractSnapshotFutureTask<?> prev = this.locSnpTasks.putIfAbsent(rqId, task);
            if (prev != null) {
                SnapshotFinishedFutureTask snapshotFinishedFutureTask = new SnapshotFinishedFutureTask(new IgniteCheckedException("Snapshot with requested name is already scheduled: " + rqId));
                return snapshotFinishedFutureTask;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Snapshot task has been registered on local node [sctx=" + this + ", task=" + task.getClass().getSimpleName() + ", topVer=" + this.cctx.discovery().topologyVersionEx() + "]");
            }
            task.listen(() -> this.locSnpTasks.remove(rqId));
            AbstractSnapshotFutureTask<?> abstractSnapshotFutureTask = task;
            return abstractSnapshotFutureTask;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public <T extends AbstractSnapshotFutureTask<?>> T currentSnapshotTask(Class<T> snpTaskCls) {
        SnapshotOperationRequest req = this.clusterSnpReq;
        if (req == null) {
            return null;
        }
        AbstractSnapshotFutureTask task = (AbstractSnapshotFutureTask)this.locSnpTasks.get(req.snapshotName());
        if (task == null || task.getClass() != snpTaskCls) {
            return null;
        }
        return (T)task;
    }

    void localSnapshotSenderFactory(BiFunction<String, String, SnapshotSender> factory) {
        this.locSndrFactory = factory;
    }

    BiFunction<String, String, SnapshotSender> localSnapshotSenderFactory() {
        return this.locSndrFactory;
    }

    void remoteSnapshotSenderFactory(BiFunction<String, UUID, SnapshotSender> factory) {
        this.rmtSndrFactory = factory;
    }

    RemoteSnapshotSender remoteSnapshotSenderFactory(String rqId, UUID nodeId) {
        return new RemoteSnapshotSender(this.log, this.cctx.kernalContext().pools().getSnapshotExecutorService(), this.cctx.gridIO().openTransmissionSender(nodeId, DFLT_INITIAL_SNAPSHOT_TOPIC), rqId);
    }

    public void writeSnapshotDirectoryToMetastorage(File snpLocDir) {
        this.cctx.database().checkpointReadLock();
        try {
            assert (this.metaStorage != null && this.metaStorage.read(SNP_RUNNING_DIR_KEY) == null) : "The previous snapshot hasn't been completed correctly";
            this.metaStorage.write(SNP_RUNNING_DIR_KEY, (Serializable)((Object)snpLocDir.getAbsolutePath()));
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        finally {
            this.cctx.database().checkpointReadUnlock();
        }
    }

    private void removeLastMetaStorageKey() throws IgniteCheckedException {
        this.cctx.database().checkpointReadLock();
        try {
            this.metaStorage.remove(SNP_RUNNING_DIR_KEY);
            this.metaStorage.remove(SNP_RUNNING_KEY);
        }
        finally {
            this.cctx.database().checkpointReadUnlock();
        }
    }

    private void removeDumpLock(String dumpName) throws IgniteCheckedException {
        File lock = new File(IgniteSnapshotManager.nodeDumpDirectory(this.snapshotLocalDir(dumpName, null), this.cctx), DUMP_LOCK);
        if (!lock.exists()) {
            return;
        }
        if (!lock.delete()) {
            throw new IgniteCheckedException("Lock file can't be deleted: " + lock);
        }
    }

    public static File nodeDumpDirectory(File dumpDir, GridCacheSharedContext<?, ?> cctx) throws IgniteCheckedException {
        return new File(dumpDir, IgniteSnapshotManager.databaseRelativePath(cctx.kernalContext().pdsFolderResolver().resolveFolders().folderName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableIncrementalSnapshotsCreation(MetaStorage metaStorage, int grpId) {
        this.cctx.database().checkpointReadLock();
        try {
            metaStorage.write(IgniteSnapshotManager.incrementalSnapshotCreationDisabledKey(grpId), Boolean.valueOf(true));
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to disable incremental snapshot creation for the cache group: " + grpId, e);
        }
        finally {
            this.cctx.database().checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableIncrementalSnapshotsCreation(Collection<Integer> grpIds) {
        this.cctx.database().checkpointReadLock();
        try {
            for (int g : grpIds) {
                this.metaStorage.remove(IgniteSnapshotManager.incrementalSnapshotCreationDisabledKey(g));
            }
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to allow incremental snapshot creation for group: " + grpIds, e);
        }
        finally {
            this.cctx.database().checkpointReadUnlock();
        }
    }

    public static String incrementalSnapshotCreationDisabledKey(int grpId) {
        return INC_SNP_DISABLED_KEY_PREFIX + grpId;
    }

    void recordSnapshotEvent(final String snpName, final String msg, final int type) {
        if (!this.cctx.gridEvents().isRecordable(type) || !this.cctx.gridEvents().hasListener(type)) {
            return;
        }
        this.cctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

            @Override
            public void run() {
                IgniteSnapshotManager.this.cctx.gridEvents().record(new SnapshotEvent(IgniteSnapshotManager.this.cctx.localNode(), msg, snpName, type));
            }
        });
    }

    ExecutorService snapshotExecutorService() {
        return this.cctx.kernalContext().pools().getSnapshotExecutorService();
    }

    public void ioFactory(FileIOFactory ioFactory) {
        this.ioFactory = ioFactory;
    }

    public FileIOFactory ioFactory() {
        return this.ioFactory;
    }

    AbstractSnapshotFutureTask<?> lastScheduledSnapshotResponseRemoteTask(UUID nodeId) {
        return this.locSnpTasks.values().stream().filter(t -> t instanceof SnapshotResponseRemoteFutureTask).filter(t -> t.sourceNodeId().equals(nodeId)).findFirst().orElse(null);
    }

    static String databaseRelativePath(String folderName) {
        return Paths.get("db", folderName).toString();
    }

    public static File resolveSnapshotWorkDirectory(IgniteConfiguration cfg) {
        return IgniteSnapshotManager.resolveSnapshotWorkDirectory(cfg, true);
    }

    public static File resolveSnapshotWorkDirectory(IgniteConfiguration cfg, boolean create) {
        try {
            return U.resolveWorkDirectory(cfg.getWorkDirectory() == null ? U.defaultWorkDirectory() : cfg.getWorkDirectory(), cfg.getSnapshotPath(), false, create);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    static void copy(FileIOFactory factory, File from, File to, long length) {
        IgniteSnapshotManager.copy(factory, from, to, length, null);
    }

    static void copy(FileIOFactory factory, File from, File to, long length, @Nullable BasicRateLimiter rateLimiter) {
        try (FileIO src = factory.create(from, StandardOpenOption.READ);
             FileChannel dest = new FileOutputStream(to).getChannel();){
            if (src.size() < length) {
                throw new IgniteException("The source file to copy is not long enough [expected=" + length + ", actual=" + src.size() + "]");
            }
            boolean unlimited = rateLimiter == null || rateLimiter.isUnlimited();
            long written = 0L;
            while (written < length) {
                if (unlimited) {
                    written += src.transferTo(written, length - written, dest);
                    continue;
                }
                long blockLen = Math.min(length - written, 65536L);
                rateLimiter.acquire(blockLen);
                long blockWritten = 0L;
                while ((blockWritten += src.transferTo(written + blockWritten, blockLen - blockWritten, dest)) < blockLen) {
                }
                written += blockWritten;
            }
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new IgniteInterruptedException((InterruptedException)e.getCause());
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    private IgniteFuture<Boolean> executeRestoreManagementTask(Class<? extends ComputeTask<String, Boolean>> taskCls, String snpName) {
        this.cctx.kernalContext().security().authorize(SecurityPermission.ADMIN_SNAPSHOT);
        Collection<ClusterNode> bltNodes = F.view(this.cctx.discovery().serverNodes(AffinityTopologyVersion.NONE), node -> CU.baselineNode(node, this.cctx.kernalContext().state().clusterState()));
        return new IgniteFutureImpl<Boolean>(this.cctx.kernalContext().task().execute(taskCls, snpName, TaskExecutionOptions.options(bltNodes)));
    }

    private void checkIncrementalCanBeCreated(String name, @Nullable String snpPath, SnapshotMetadata meta) throws IgniteCheckedException, IOException {
        File snpDir = this.snapshotLocalDir(name, snpPath);
        IgniteWriteAheadLogManager wal = this.cctx.wal();
        if (wal == null) {
            throw new IgniteCheckedException("Create incremental snapshot request has been rejected. WAL must be enabled.");
        }
        File archiveDir = wal.archiveDir();
        if (archiveDir == null) {
            throw new IgniteCheckedException("Create incremental snapshot request has been rejected. WAL archive must be enabled.");
        }
        GridFileUtils.ensureHardLinkAvailable(archiveDir.toPath(), snpDir.toPath());
        Set aliveNodesConsIds = this.cctx.discovery().aliveServerNodes().stream().map(node -> node.consistentId().toString()).collect(Collectors.toSet());
        for (String consId : meta.baselineNodes()) {
            if (aliveNodesConsIds.contains(consId)) continue;
            throw new IgniteCheckedException("Create incremental snapshot request has been rejected. Node from full snapshot offline [consistentId=" + consId + "]");
        }
        File rootSnpCachesDir = new File(snpDir, IgniteSnapshotManager.databaseRelativePath(meta.folderName()));
        for (int grpId : meta.cacheGroupIds()) {
            if (grpId == MetaStorage.METASTORAGE_CACHE_ID) continue;
            if (this.metaStorage.read(IgniteSnapshotManager.incrementalSnapshotCreationDisabledKey(grpId)) != null) {
                throw new IgniteCheckedException("Create incremental snapshot request has been rejected. WAL was disabled since previous snapshot for cache group [groupId=" + grpId + "]");
            }
            CacheGroupContext gctx = this.cctx.kernalContext().cache().cacheGroup(grpId);
            if (gctx == null) {
                throw new IgniteCheckedException("Create incremental snapshot request has been rejected. Cache group destroyed [groupId=" + grpId + "]");
            }
            if (gctx.config().isEncryptionEnabled()) {
                throw new IgniteCheckedException("Create incremental snapshot request has been rejected. Encrypted cache groups not supported [groupId=" + grpId + "]");
            }
            List<File> snpCacheDir = FilePageStoreManager.cacheDirectories(rootSnpCachesDir, grpName -> gctx.cacheOrGroupName().equals(grpName));
            if (snpCacheDir.isEmpty()) {
                throw new IgniteCheckedException("Create incremental snapshot request has been rejected. Cache group directory not found [groupId=" + grpId + "]");
            }
            assert (snpCacheDir.size() == 1) : "Single snapshot cache directory must be found";
            for (File snpDataFile : FilePageStoreManager.cacheDataFiles(snpCacheDir.get(0))) {
                StoredCacheData snpCacheData = GridLocalConfigManager.readCacheData(snpDataFile, this.cctx.kernalContext().marshallerContext().jdkMarshaller(), this.cctx.kernalContext().config());
                byte[] snpCacheDataBytes = Files.readAllBytes(snpDataFile.toPath());
                File nodeDataFile = new File(snpDataFile.getAbsolutePath().replace(rootSnpCachesDir.getAbsolutePath(), this.pdsSettings.persistentStoreNodePath().getAbsolutePath()));
                if (!nodeDataFile.exists()) {
                    throw new IgniteCheckedException("Create incremental snapshot request has been rejected. Cache destroyed [cacheId=" + snpCacheData.cacheId() + ", cacheName=" + snpCacheData.config().getName() + "]");
                }
                byte[] nodeCacheDataBytes = Files.readAllBytes(nodeDataFile.toPath());
                if (Arrays.equals(snpCacheDataBytes, nodeCacheDataBytes)) continue;
                throw new IgniteCheckedException(IgniteSnapshotManager.cacheChangedException(snpCacheData.cacheId(), snpCacheData.config().getName()));
            }
        }
    }

    public static String cacheChangedException(int cacheId, String name) {
        return "Create incremental snapshot request has been rejected. Cache changed [cacheId=" + cacheId + ", cacheName=" + name + "]";
    }

    protected SnapshotHandlers handlers() {
        return this.handlers;
    }

    @Nullable
    public UUID incrementalSnapshotId() {
        return this.incSnpId;
    }

    @FunctionalInterface
    private static interface Factory<E1, E2, R> {
        public R create(E1 var1, E2 var2) throws IOException;
    }

    private static class IgniteSnapshotFutureImpl
    extends IgniteFutureImpl<Void> {
        public IgniteSnapshotFutureImpl(IgniteInternalFuture<Void> fut) {
            super(fut);
        }

        @Override
        protected IgniteException convertException(IgniteCheckedException e) {
            if (e instanceof IgniteClientDisconnectedCheckedException) {
                return new IgniteException("Client disconnected. Snapshot result is unknown", U.convertException(e));
            }
            SnapshotWarningException wrn = X.cause(e, SnapshotWarningException.class);
            if (wrn != null) {
                return new IgniteException(wrn.getMessage());
            }
            return new IgniteException("Snapshot has not been created", U.convertException(e));
        }
    }

    @GridInternal
    private static class CancelSnapshotCallable
    implements IgniteCallable<Boolean> {
        private static final long serialVersionUID = 0L;
        private final String snpName;
        private final UUID reqId;
        @IgniteInstanceResource
        private transient IgniteEx ignite;

        public CancelSnapshotCallable(UUID reqId, String snpName) {
            this.reqId = reqId;
            this.snpName = snpName;
        }

        @Override
        public Boolean call() throws Exception {
            if (this.reqId != null) {
                return this.ignite.context().cache().context().snapshotMgr().cancelLocalSnapshotOperations(this.reqId);
            }
            if (this.ignite.context().cache().context().snapshotMgr().cancelLocalSnapshotTask(this.snpName)) {
                return true;
            }
            return this.ignite.context().cache().context().snapshotMgr().cancelLocalRestoreTask(this.snpName).get();
        }
    }

    @GridInternal
    private static class CreateSnapshotCallable
    implements IgniteCallable<Void> {
        private static final long serialVersionUID = 0L;
        private final String snpName;
        @Nullable
        private final Collection<String> cacheGrpNames;
        private final boolean incremental;
        private final boolean onlyPrimary;
        private final boolean dump;
        private final boolean comprParts;
        private final boolean encrypt;
        @IgniteInstanceResource
        private transient IgniteEx ignite;

        public CreateSnapshotCallable(String snpName, @Nullable Collection<String> cacheGrpNames, boolean incremental, boolean onlyPrimary, boolean dump, boolean comprParts, boolean encrypt) {
            this.snpName = snpName;
            this.cacheGrpNames = cacheGrpNames;
            this.incremental = incremental;
            this.onlyPrimary = onlyPrimary;
            this.dump = dump;
            this.comprParts = comprParts;
            this.encrypt = encrypt;
        }

        @Override
        public Void call() {
            if (this.incremental) {
                this.ignite.snapshot().createIncrementalSnapshot(this.snpName).get();
            } else {
                this.ignite.context().cache().context().snapshotMgr().createSnapshot(this.snpName, null, this.cacheGrpNames, false, this.onlyPrimary, this.dump, this.comprParts, this.encrypt).get();
            }
            return null;
        }
    }

    public static class ClusterSnapshotFuture
    extends GridFutureAdapter<Void> {
        final UUID rqId;
        final String name;
        final long startTime;
        @Nullable
        final Integer incIdx;
        volatile long endTime;
        volatile IgniteCheckedException interruptEx;

        public ClusterSnapshotFuture() {
            this.onDone();
            this.rqId = null;
            this.name = "";
            this.startTime = 0L;
            this.endTime = 0L;
            this.incIdx = null;
        }

        public ClusterSnapshotFuture(String name, Exception err) {
            this.onDone(err);
            this.name = name;
            this.startTime = U.currentTimeMillis();
            this.endTime = 0L;
            this.rqId = null;
            this.incIdx = null;
        }

        public ClusterSnapshotFuture(UUID rqId, String name, @Nullable Integer incIdx) {
            this.rqId = rqId;
            this.name = name;
            this.incIdx = incIdx;
            this.startTime = U.currentTimeMillis();
        }

        @Override
        protected boolean onDone(@Nullable Void res, @Nullable Throwable err, boolean cancel) {
            this.endTime = U.currentTimeMillis();
            return super.onDone(res, err, cancel);
        }

        public UUID requestId() {
            return this.rqId;
        }
    }

    private static class SnapshotStartDiscoveryMessage
    extends InitMessage<SnapshotOperationRequest>
    implements SnapshotDiscoveryMessage {
        private static final long serialVersionUID = 0L;
        private final boolean needExchange;

        public SnapshotStartDiscoveryMessage(UUID procId, SnapshotOperationRequest req) {
            super(procId, DistributedProcess.DistributedProcessType.START_SNAPSHOT, req, req.incremental());
            this.needExchange = !req.incremental();
        }

        @Override
        public boolean needExchange() {
            return this.needExchange;
        }

        @Override
        public boolean needAssignPartitions() {
            return false;
        }

        @Override
        public String toString() {
            return S.toString(SnapshotStartDiscoveryMessage.class, this, super.toString());
        }
    }

    private static class SnapshotOperationResponse
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final Map<String, SnapshotHandlerResult<Object>> hndResults;

        public SnapshotOperationResponse() {
            this(null);
        }

        public SnapshotOperationResponse(Map<String, SnapshotHandlerResult<Object>> hndResults) {
            this.hndResults = hndResults;
        }

        @Nullable
        public Map<String, SnapshotHandlerResult<Object>> handlerResults() {
            return this.hndResults;
        }
    }

    class DeltaSortedIterator
    extends DeltaIterator {
        public static final int DELTA_SORT_BATCH_SIZE = 500000;
        private final FileIO idxIo;
        private int id;
        private Iterator<Integer> sortedIter;

        DeltaSortedIterator(File delta, FileIOFactory ioFactory) throws IOException {
            super(delta, ioFactory);
            File deltaIdx = IgniteSnapshotManager.partDeltaIndexFile(delta);
            FileIO fileIO = this.idxIo = this.pagesCnt > 0 ? IgniteSnapshotManager.this.ioFactory.create(deltaIdx, StandardOpenOption.READ) : null;
            assert (deltaIdx.length() % 4L == 0L) : "Wrong delta index size: " + deltaIdx.length();
            assert (deltaIdx.length() / 4L == (long)this.pagesCnt) : "Wrong delta index pages count: " + deltaIdx.length();
        }

        @Override
        public boolean hasNext() {
            if (this.sortedIter == null || !this.sortedIter.hasNext()) {
                this.advance();
            }
            return this.sortedIter.hasNext();
        }

        @Override
        public ByteBuffer next() {
            this.readPage((long)this.sortedIter.next().intValue() * (long)this.pageSize);
            return this.pageBuf;
        }

        private void advance() {
            TreeMap<Integer, Integer> sorted = new TreeMap<Integer, Integer>();
            while (this.id < this.pagesCnt && sorted.size() < 500000) {
                this.pageBuf.clear();
                try {
                    this.idxIo.readFully(this.pageBuf);
                }
                catch (IOException e) {
                    throw new IgniteException(e);
                }
                this.pageBuf.flip();
                while (this.pageBuf.hasRemaining()) {
                    sorted.put(this.pageBuf.getInt(), this.id++);
                }
            }
            this.sortedIter = sorted.values().iterator();
        }

        @Override
        public void close() throws IOException {
            super.close();
            U.closeQuiet(this.idxIo);
        }
    }

    private class DeltaIterator
    implements Iterator<ByteBuffer>,
    Closeable {
        protected final File delta;
        private final FileIO fileIo;
        protected final long totalBytes;
        protected final int pageSize;
        protected final int pagesCnt;
        protected final ByteBuffer pageBuf;
        private long pos;

        DeltaIterator(File delta, FileIOFactory ioFactory) throws IOException {
            this.pageSize = IgniteSnapshotManager.this.cctx.kernalContext().config().getDataStorageConfiguration().getPageSize();
            this.delta = delta;
            this.fileIo = ioFactory.create(delta, StandardOpenOption.READ);
            this.totalBytes = this.fileIo.size();
            assert (this.totalBytes % (long)this.pageSize == 0L) : "Given file with delta pages has incorrect size: " + this.totalBytes;
            this.pagesCnt = (int)(this.totalBytes / (long)this.pageSize);
            this.pageBuf = ByteBuffer.allocate(this.pageSize).order(ByteOrder.nativeOrder());
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.totalBytes;
        }

        @Override
        public ByteBuffer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.readPage(this.pos);
            this.pos += (long)this.pageSize;
            return this.pageBuf;
        }

        protected void readPage(long pos) {
            this.pageBuf.clear();
            try {
                long read = this.fileIo.readFully(this.pageBuf, pos);
                assert (read == (long)this.pageBuf.capacity());
            }
            catch (IOException e) {
                throw new IgniteException(e);
            }
            this.pageBuf.flip();
            if (IgniteSnapshotManager.this.log.isDebugEnabled()) {
                IgniteSnapshotManager.this.log.debug("Read page given delta file [path=" + this.delta.getName() + ", pageId=" + PageIO.getPageId(this.pageBuf) + ", index=" + PageIdUtils.pageIndex(PageIO.getPageId(this.pageBuf)) + ", pos=" + pos + ", pagesCnt=" + this.pagesCnt + ", crcBuff=" + FastCrc.calcCrc(this.pageBuf, this.pageBuf.limit()) + ", crcPage=" + PageIO.getCrc(this.pageBuf) + "]");
                this.pageBuf.rewind();
            }
        }

        @Override
        public void close() throws IOException {
            this.fileIo.close();
        }
    }

    private class LocalSnapshotSender
    extends SnapshotSender {
        private final File snpLocDir;
        private File dbDir;
        private final int pageSize;
        private final Factory<File, FileIOFactory, DeltaIterator> deltaIterFactory;

        public LocalSnapshotSender(@Nullable String snpName, String snpPath) {
            super(IgniteSnapshotManager.this.log, IgniteSnapshotManager.this.cctx.kernalContext().pools().getSnapshotExecutorService());
            this.deltaIterFactory = IgniteSnapshotManager.this.sequentialWrite() ? (x$0, x$1) -> new DeltaSortedIterator((File)x$0, (FileIOFactory)x$1) : (x$0, x$1) -> new DeltaIterator((File)x$0, (FileIOFactory)x$1);
            this.snpLocDir = IgniteSnapshotManager.this.snapshotLocalDir(snpName, snpPath);
            this.pageSize = IgniteSnapshotManager.this.cctx.kernalContext().config().getDataStorageConfiguration().getPageSize();
        }

        @Override
        protected void init(int partsCnt) {
            this.dbDir = new File(this.snpLocDir, IgniteSnapshotManager.databaseRelativePath(IgniteSnapshotManager.this.pdsSettings.folderName()));
            if (this.dbDir.exists()) {
                throw new IgniteException("Snapshot with given name already exists [snpName=" + this.snpLocDir.getName() + ", absPath=" + this.dbDir.getAbsolutePath() + "]");
            }
            IgniteSnapshotManager.this.writeSnapshotDirectoryToMetastorage(this.snpLocDir);
            try {
                U.ensureDirectory(this.dbDir, "snapshot work directory for a local snapshot sender", this.log);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void sendCacheConfig0(File ccfg, String cacheDirName) {
            assert (this.dbDir != null);
            try {
                File cacheDir = U.resolveWorkDirectory(this.dbDir.getAbsolutePath(), cacheDirName, false);
                File targetCacheCfg = new File(cacheDir, ccfg.getName());
                IgniteSnapshotManager.copy(IgniteSnapshotManager.this.ioFactory, ccfg, targetCacheCfg, ccfg.length(), IgniteSnapshotManager.this.transferRateLimiter);
                StoredCacheData cacheData = IgniteSnapshotManager.this.locCfgMgr.readCacheData(targetCacheCfg);
                if (cacheData.config().isEncryptionEnabled()) {
                    EncryptionSpi encSpi = IgniteSnapshotManager.this.cctx.kernalContext().config().getEncryptionSpi();
                    GroupKey gKey = IgniteSnapshotManager.this.cctx.kernalContext().encryption().getActiveKey(CU.cacheGroupId(cacheData.config()));
                    cacheData.groupKeyEncrypted(new GroupKeyEncrypted(gKey.id(), encSpi.encryptKey(gKey.key())));
                    IgniteSnapshotManager.this.locCfgMgr.writeCacheData(cacheData, targetCacheCfg);
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void sendMarshallerMeta0(List<Map<Integer, MappedName>> mappings) {
            if (mappings == null) {
                return;
            }
            try {
                MarshallerContextImpl.saveMappings(IgniteSnapshotManager.this.cctx.kernalContext(), mappings, this.snpLocDir);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void sendBinaryMeta0(Collection<BinaryType> types) {
            if (types == null) {
                return;
            }
            IgniteSnapshotManager.this.cctx.kernalContext().cacheObjects().saveMetadata(types, this.snpLocDir);
        }

        @Override
        public void sendPart0(File part, String cacheDirName, GroupPartitionId pair, Long len) {
            try {
                if (len == 0L) {
                    return;
                }
                File cacheDir = U.resolveWorkDirectory(this.dbDir.getAbsolutePath(), cacheDirName, false);
                File snpPart = new File(cacheDir, part.getName());
                if (!snpPart.exists() || snpPart.delete()) {
                    snpPart.createNewFile();
                }
                IgniteSnapshotManager.copy(IgniteSnapshotManager.this.ioFactory, part, snpPart, len, IgniteSnapshotManager.this.transferRateLimiter);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partition has been snapshot [snapshotDir=" + this.dbDir.getAbsolutePath() + ", cacheDirName=" + cacheDirName + ", part=" + part.getName() + ", length=" + part.length() + ", snapshot=" + snpPart.getName() + "]");
                }
            }
            catch (IOException | IgniteCheckedException ex) {
                throw new IgniteException(ex);
            }
        }

        @Override
        public void sendDelta0(File delta, String cacheDirName, GroupPartitionId pair) {
            boolean encrypted;
            File snpPart = FilePageStoreManager.getPartitionFile(this.dbDir, cacheDirName, pair.getPartitionId());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Start partition snapshot recovery with the given delta page file [part=" + snpPart + ", delta=" + delta + "]");
            }
            FileIOFactory ioFactory = (encrypted = IgniteSnapshotManager.this.cctx.cache().isEncrypted(pair.getGroupId())) ? ((FilePageStoreManager)IgniteSnapshotManager.this.cctx.pageStore()).encryptedFileIoFactory(IgniteSnapshotManager.this.ioFactory, pair.getGroupId()) : IgniteSnapshotManager.this.ioFactory;
            try (DeltaIterator deltaIter = this.deltaIterFactory.create(delta, ioFactory);
                 FilePageStore pageStore = (FilePageStore)IgniteSnapshotManager.this.storeMgr.getPageStoreFactory(pair.getGroupId(), encrypted).createPageStore(GroupPartitionId.getTypeByPartId(pair.getPartitionId()), snpPart::toPath, v -> {});){
                pageStore.beginRecover();
                while (deltaIter.hasNext()) {
                    IgniteSnapshotManager.this.transferRateLimiter.acquire(this.pageSize);
                    ByteBuffer page = deltaIter.next();
                    long pageId = PageIO.getPageId(page);
                    pageStore.write(pageId, page, 0, false);
                }
                pageStore.finishRecover();
            }
            catch (IOException | IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        protected void close0(@Nullable Throwable th) {
            if (th == null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("The Local snapshot sender closed. All resources released [dbNodeSnpDir=" + this.dbDir + "]");
                }
            } else {
                IgniteSnapshotManager.this.deleteSnapshot(this.snpLocDir, IgniteSnapshotManager.this.pdsSettings);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Local snapshot sender closed due to an error occurred: " + th.getMessage());
                }
            }
        }
    }

    private static class RemoteSnapshotSender
    extends SnapshotSender {
        private final GridIoManager.TransmissionSender sndr;
        private final String rqId;
        private int partsCnt;

        public RemoteSnapshotSender(IgniteLogger log, Executor exec, GridIoManager.TransmissionSender sndr, String rqId) {
            super(log, exec);
            this.sndr = sndr;
            this.rqId = rqId;
        }

        @Override
        protected void init(int partsCnt) {
            this.partsCnt = partsCnt;
        }

        @Override
        public void sendPart0(File part, String cacheDirName, GroupPartitionId pair, Long len) {
            try {
                assert (part.exists());
                assert (len > 0L) : "Requested partitions has incorrect file length [pair=" + pair + ", cacheDirName=" + cacheDirName + "]";
                this.sndr.send(part, 0L, len, this.transmissionParams(this.rqId, cacheDirName, pair), TransmissionPolicy.FILE);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Partition file has been sent [part=" + part.getName() + ", pair=" + pair + ", grpName=" + FilePageStoreManager.cacheGroupName(new File(cacheDirName)) + ", length=" + len + "]");
                }
            }
            catch (TransmissionCancelledException e) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Transmission partition file has been interrupted [part=" + part.getName() + ", pair=" + pair + "]");
                }
            }
            catch (IOException | InterruptedException | IgniteCheckedException e) {
                U.error(this.log, "Error sending partition file [part=" + part.getName() + ", pair=" + pair + ", length=" + len + "]", e);
                throw new IgniteException(e);
            }
        }

        @Override
        public void sendDelta0(File delta, String cacheDirName, GroupPartitionId pair) {
            throw new UnsupportedOperationException("Sending files by chunks of data is not supported: " + delta.getAbsolutePath());
        }

        private Map<String, Serializable> transmissionParams(String rqId, String cacheDirName, GroupPartitionId pair) {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put(IgniteSnapshotManager.SNP_GRP_ID_PARAM, Integer.valueOf(pair.getGroupId()));
            params.put(IgniteSnapshotManager.SNP_PART_ID_PARAM, Integer.valueOf(pair.getPartitionId()));
            params.put(IgniteSnapshotManager.SNP_CACHE_DIR_NAME_PARAM, (Serializable)((Object)cacheDirName));
            params.put(IgniteSnapshotManager.RQ_ID_NAME_PARAM, (Serializable)((Object)rqId));
            params.put(IgniteSnapshotManager.SNP_PARTITIONS_CNT, Integer.valueOf(this.partsCnt));
            return params;
        }

        @Override
        public void close0(@Nullable Throwable th) {
            U.closeQuiet(this.sndr);
            if (th == null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("The remote snapshot sender closed normally [snpName=" + this.rqId + "]");
                }
            } else {
                U.warn(this.log, "The remote snapshot sender closed due to an error occurred while processing snapshot operation [snpName=" + this.rqId + "]", th);
            }
        }
    }

    private class SequentialRemoteSnapshotManager
    implements TransmissionHandler,
    GridMessageListener {
        private volatile RemoteSnapshotFilesRecevier active;
        private final Queue<RemoteSnapshotFilesRecevier> queue = new ConcurrentLinkedDeque<RemoteSnapshotFilesRecevier>();
        private boolean stopping;

        private SequentialRemoteSnapshotManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void submit(RemoteSnapshotFilesRecevier next) {
            assert (next != null);
            SequentialRemoteSnapshotManager sequentialRemoteSnapshotManager = this;
            synchronized (sequentialRemoteSnapshotManager) {
                if (this.stopping) {
                    next.acceptException(new IgniteException(IgniteSnapshotManager.SNP_NODE_STOPPING_ERR_MSG));
                    return;
                }
                if (this.active != null && !this.active.isDone()) {
                    this.queue.offer(next);
                    return;
                }
                this.active = next;
                this.active.listen(this::scheduleNext);
            }
            next.init();
        }

        private void scheduleNext() {
            RemoteSnapshotFilesRecevier next = this.queue.poll();
            while (next != null && next.isDone()) {
                next = this.queue.poll();
            }
            if (next == null) {
                this.active = null;
                return;
            }
            this.submit(next);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            RemoteSnapshotFilesRecevier r;
            SequentialRemoteSnapshotManager sequentialRemoteSnapshotManager = this;
            synchronized (sequentialRemoteSnapshotManager) {
                this.stopping = true;
            }
            IgniteException ex = new IgniteException(IgniteSnapshotManager.SNP_NODE_STOPPING_ERR_MSG);
            while ((r = this.queue.poll()) != null) {
                r.acceptException(ex);
            }
            if (this.active != null) {
                this.active.acceptException(ex);
            }
        }

        public void onNodeLeft(UUID nodeId) {
            ClusterTopologyCheckedException ex = new ClusterTopologyCheckedException("The node from which a snapshot has been requested left the grid");
            this.queue.forEach(r -> {
                if (r.stopChecker.getAsBoolean() || r.rmtNodeId.equals(nodeId)) {
                    r.acceptException(ex);
                }
            });
            RemoteSnapshotFilesRecevier task = this.active;
            if (task != null && !task.isDone() && (task.stopChecker.getAsBoolean() || task.rmtNodeId.equals(nodeId))) {
                task.acceptException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            block18: {
                if (!IgniteSnapshotManager.this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    if (msg instanceof SnapshotFilesRequestMessage) {
                        SnapshotFilesRequestMessage reqMsg0 = (SnapshotFilesRequestMessage)msg;
                        String rqId = reqMsg0.id();
                        String snpName = reqMsg0.snapshotName();
                        try {
                            SequentialRemoteSnapshotManager sequentialRemoteSnapshotManager = this;
                            synchronized (sequentialRemoteSnapshotManager) {
                                AbstractSnapshotFutureTask<?> task = IgniteSnapshotManager.this.lastScheduledSnapshotResponseRemoteTask(nodeId);
                                if (task != null) {
                                    task.cancel();
                                    IgniteSnapshotManager.this.log.info("Snapshot request has been cancelled due to another request received [prevSnpResp=" + task + ", msg0=" + reqMsg0 + "]");
                                }
                            }
                            AbstractSnapshotFutureTask<?> task = IgniteSnapshotManager.this.registerTask(rqId, new SnapshotResponseRemoteFutureTask(IgniteSnapshotManager.this.cctx, nodeId, reqMsg0.requestId(), snpName, reqMsg0.snapshotPath(), IgniteSnapshotManager.this.rmtSndrFactory.apply(rqId, nodeId), reqMsg0.parts()));
                            task.listen(() -> {
                                if (task.error() == null) {
                                    return;
                                }
                                U.error(IgniteSnapshotManager.this.log, "Failed to process request of creating a snapshot [from=" + nodeId + ", msg=" + reqMsg0 + "]", task.error());
                                try {
                                    IgniteSnapshotManager.this.cctx.gridIO().sendToCustomTopic(nodeId, DFLT_INITIAL_SNAPSHOT_TOPIC, (Message)new SnapshotFilesFailureMessage(reqMsg0.id(), task.error().getMessage()), (byte)2);
                                }
                                catch (IgniteCheckedException ex0) {
                                    U.error(IgniteSnapshotManager.this.log, "Fail to send the response message with processing snapshot request error [request=" + reqMsg0 + ", nodeId=" + nodeId + "]", ex0);
                                }
                            });
                            task.start();
                        }
                        catch (Throwable t) {
                            U.error(IgniteSnapshotManager.this.log, "Error processing snapshot file request message error [request=" + reqMsg0 + ", nodeId=" + nodeId + "]", t);
                            IgniteSnapshotManager.this.cctx.gridIO().sendToCustomTopic(nodeId, DFLT_INITIAL_SNAPSHOT_TOPIC, (Message)new SnapshotFilesFailureMessage(reqMsg0.id(), t.getMessage()), (byte)2);
                        }
                        break block18;
                    }
                    if (msg instanceof SnapshotFilesFailureMessage) {
                        SnapshotFilesFailureMessage respMsg0 = (SnapshotFilesFailureMessage)msg;
                        RemoteSnapshotFilesRecevier task = this.active;
                        if (task == null || !task.reqId.equals(respMsg0.id())) {
                            if (IgniteSnapshotManager.this.log.isInfoEnabled()) {
                                IgniteSnapshotManager.this.log.info("A stale snapshot response message has been received. Will be ignored [fromNodeId=" + nodeId + ", response=" + respMsg0 + "]");
                            }
                            return;
                        }
                        if (respMsg0.errorMessage() != null) {
                            task.acceptException(new IgniteCheckedException("Request cancelled. The snapshot operation stopped on the remote node with an error: " + respMsg0.errorMessage()));
                        }
                    }
                }
                catch (Throwable e) {
                    U.error(IgniteSnapshotManager.this.log, "Processing snapshot request from remote node fails with an error", e);
                    IgniteSnapshotManager.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                }
                finally {
                    IgniteSnapshotManager.this.busyLock.leaveBusy();
                }
            }
        }

        @Override
        public void onEnd(UUID nodeId) {
            RemoteSnapshotFilesRecevier task = this.active;
            if (task == null) {
                return;
            }
            assert (task.partsLeft.get() == 0) : task;
            assert (task.rmtNodeId.equals(nodeId));
            if (IgniteSnapshotManager.this.log.isInfoEnabled()) {
                IgniteSnapshotManager.this.log.info("Requested snapshot from remote node has been fully received [rqId=" + task.reqId + ", task=" + task + "]");
            }
            task.onDone((Void)null);
        }

        @Override
        public void onException(UUID nodeId, Throwable ex) {
            RemoteSnapshotFilesRecevier task = this.active;
            if (task == null) {
                return;
            }
            assert (task.rmtNodeId.equals(nodeId));
            task.acceptException(ex);
        }

        @Override
        public String filePath(UUID nodeId, TransmissionMeta fileMeta) {
            Integer partId = (Integer)fileMeta.params().get(IgniteSnapshotManager.SNP_PART_ID_PARAM);
            String cacheDirName = (String)((Object)fileMeta.params().get(IgniteSnapshotManager.SNP_CACHE_DIR_NAME_PARAM));
            String rqId = (String)((Object)fileMeta.params().get(IgniteSnapshotManager.RQ_ID_NAME_PARAM));
            Integer partsCnt = (Integer)fileMeta.params().get(IgniteSnapshotManager.SNP_PARTITIONS_CNT);
            RemoteSnapshotFilesRecevier task = this.active;
            if (task == null || task.isDone() || !task.reqId.equals(rqId)) {
                throw new TransmissionCancelledException("Stale snapshot transmission will be ignored [rqId=" + rqId + ", meta=" + fileMeta + ", task=" + task + "]");
            }
            assert (task.reqId.equals(rqId) && task.rmtNodeId.equals(nodeId)) : "Another transmission in progress [task=" + task + ", nodeId=" + rqId + "]";
            IgniteSnapshotManager.this.busyLock.enterBusy();
            try {
                task.partsLeft.compareAndSet(-1, partsCnt);
                File cacheDir = FilePageStoreManager.cacheWorkDir(IgniteSnapshotManager.this.storeMgr.workDir(), cacheDirName);
                File tmpCacheDir = U.resolveWorkDirectory(IgniteSnapshotManager.this.storeMgr.workDir().getAbsolutePath(), SnapshotRestoreProcess.formatTmpDirName(cacheDir).getName(), false);
                String string = Paths.get(tmpCacheDir.getAbsolutePath(), FilePageStoreManager.getPartitionFileName(partId)).toString();
                return string;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                IgniteSnapshotManager.this.busyLock.leaveBusy();
            }
        }

        @Override
        public Consumer<ByteBuffer> chunkHandler(UUID nodeId, TransmissionMeta initMeta) {
            throw new UnsupportedOperationException("Loading file by chunks is not supported: " + nodeId);
        }

        @Override
        public Consumer<File> fileHandler(UUID nodeId, TransmissionMeta initMeta) {
            final Integer grpId = (Integer)initMeta.params().get(IgniteSnapshotManager.SNP_GRP_ID_PARAM);
            final Integer partId = (Integer)initMeta.params().get(IgniteSnapshotManager.SNP_PART_ID_PARAM);
            final String rqId = (String)((Object)initMeta.params().get(IgniteSnapshotManager.RQ_ID_NAME_PARAM));
            assert (grpId != null);
            assert (partId != null);
            assert (rqId != null);
            final RemoteSnapshotFilesRecevier task = this.active;
            if (task == null || task.isDone() || !task.reqId.equals(rqId)) {
                throw new TransmissionCancelledException("Stale snapshot transmission will be ignored [rqId=" + rqId + ", meta=" + initMeta + ", task=" + task + "]");
            }
            return new Consumer<File>(){

                @Override
                public void accept(File file) {
                    RemoteSnapshotFilesRecevier task0 = SequentialRemoteSnapshotManager.this.active;
                    if (task0 == null || !task0.equals(task) || task0.isDone()) {
                        throw new TransmissionCancelledException("Snapshot request is cancelled [rqId=" + rqId + ", grpId=" + grpId + ", partId=" + partId + "]");
                    }
                    if (!IgniteSnapshotManager.this.busyLock.enterBusy()) {
                        throw new IgniteException(IgniteSnapshotManager.SNP_NODE_STOPPING_ERR_MSG);
                    }
                    try {
                        task0.acceptFile(file);
                    }
                    finally {
                        IgniteSnapshotManager.this.busyLock.leaveBusy();
                    }
                }
            };
        }
    }

    private static class RemoteSnapshotFilesRecevier
    extends GridFutureAdapter<Void> {
        private final String reqId = "snapshot_" + U.maskForFileName(UUID.randomUUID().toString());
        private final IgniteSnapshotManager snpMgr;
        private final SnapshotFilesRequestMessage initMsg;
        private final UUID rmtNodeId;
        private final BooleanSupplier stopChecker;
        private final BiConsumer<File, Throwable> partHnd;
        private final Path dir;
        private final AtomicInteger partsLeft = new AtomicInteger(-1);

        public RemoteSnapshotFilesRecevier(IgniteSnapshotManager snpMgr, UUID rmtNodeId, UUID reqId, String snpName, @Nullable String rmtSnpPath, Map<Integer, Set<Integer>> parts, BooleanSupplier stopChecker, BiConsumer<@Nullable File, @Nullable Throwable> partHnd) {
            this.dir = Paths.get(snpMgr.tmpWorkDir.getAbsolutePath(), this.reqId);
            this.initMsg = new SnapshotFilesRequestMessage(this.reqId, reqId, snpName, rmtSnpPath, parts);
            this.snpMgr = snpMgr;
            this.rmtNodeId = rmtNodeId;
            this.stopChecker = stopChecker;
            this.partHnd = partHnd;
        }

        public synchronized void init() {
            if (this.isDone()) {
                return;
            }
            try {
                ClusterNode rmtNode = this.snpMgr.cctx.discovery().node(this.rmtNodeId);
                if (rmtNode == null) {
                    throw new ClusterTopologyCheckedException("Snapshot remote request cannot be performed. Remote node left the grid [rmtNodeId=" + this.rmtNodeId + "]");
                }
                this.snpMgr.cctx.gridIO().sendOrderedMessage(rmtNode, DFLT_INITIAL_SNAPSHOT_TOPIC, this.initMsg, (byte)2, Long.MAX_VALUE, true);
                if (this.snpMgr.log.isInfoEnabled()) {
                    this.snpMgr.log.info("Snapshot request is sent to the remote node [rmtNodeId=" + this.rmtNodeId + ", snpName=" + this.initMsg.snapshotName() + ", rqId=" + this.reqId + "]");
                }
            }
            catch (Throwable t) {
                this.onDone(t);
            }
        }

        public synchronized void acceptException(Throwable ex) {
            if (this.isDone()) {
                return;
            }
            try {
                this.partHnd.accept(null, ex);
            }
            catch (Throwable t) {
                ex.addSuppressed(t);
            }
            this.onDone(ex);
        }

        public synchronized void acceptFile(File part) {
            if (this.isDone()) {
                return;
            }
            if (this.stopChecker.getAsBoolean()) {
                TransmissionCancelledException err = new TransmissionCancelledException("Future cancelled prior to the all requested partitions processed.");
                this.acceptException(err);
                throw err;
            }
            try {
                this.partHnd.accept(part, null);
            }
            catch (IgniteInterruptedException e) {
                throw new TransmissionCancelledException(e.getMessage());
            }
            this.partsLeft.decrementAndGet();
        }

        @Override
        protected synchronized boolean onDone(@Nullable Void res, @Nullable Throwable err, boolean cancel) {
            U.delete(this.dir);
            return super.onDone(res, err, cancel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoteSnapshotFilesRecevier fut = (RemoteSnapshotFilesRecevier)o;
            return Objects.equals(this.reqId, fut.reqId);
        }

        public int hashCode() {
            return this.reqId.hashCode();
        }

        @Override
        public String toString() {
            return S.toString(RemoteSnapshotFilesRecevier.class, this);
        }
    }

    private static class DataPageIterator
    extends GridCloseableIteratorAdapter<CacheDataRow> {
        private static final long serialVersionUID = 0L;
        @GridToStringExclude
        private final PageStore store;
        private final int partId;
        private final GridCacheSharedContext<?, ?> sctx;
        private final CacheObjectContext coctx;
        private final ByteBuffer locBuff;
        private final ByteBuffer fragmentBuff;
        private final int pages;
        private final BitSet tailPages;
        private final BitSet readPages;
        private final Deque<CacheDataRow> rows = new LinkedList<CacheDataRow>();
        private final CompressionProcessor compressProc;
        private boolean secondScanComplete;
        private int currIdx;

        public DataPageIterator(GridCacheSharedContext<?, ?> sctx, CacheObjectContext coctx, PageStore store, int partId) throws IgniteCheckedException {
            this.store = store;
            this.partId = partId;
            this.coctx = coctx;
            this.sctx = sctx;
            this.compressProc = sctx.kernalContext().compress();
            store.ensure();
            this.pages = store.pages();
            this.tailPages = new BitSet(this.pages);
            this.readPages = new BitSet(this.pages);
            this.locBuff = ByteBuffer.allocateDirect(store.getPageSize()).order(ByteOrder.nativeOrder());
            this.fragmentBuff = ByteBuffer.allocateDirect(store.getPageSize()).order(ByteOrder.nativeOrder());
        }

        @Override
        protected CacheDataRow onNext() throws IgniteCheckedException {
            if (this.secondScanComplete && this.rows.isEmpty()) {
                throw new NoSuchElementException("[partId=" + this.partId + ", store=" + this.store + ", skipPages=" + this.readPages + "]");
            }
            return this.rows.poll();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected boolean onHasNext() throws IgniteCheckedException {
            if (this.secondScanComplete && this.rows.isEmpty()) {
                return false;
            }
            try {
                while (this.currIdx < 2 * this.pages && this.rows.isEmpty()) {
                    block13: {
                        block14: {
                            first = this.currIdx < this.pages;
                            pageIdx = this.currIdx % this.pages;
                            if (this.readPages.get(pageIdx) || !first && this.tailPages.get(pageIdx)) break block13;
                            if (this.readPageFromStore(PageIdUtils.pageId(this.partId, (byte)1, pageIdx), this.locBuff)) break block14;
                            DataPageIterator.setBit(this.readPages, pageIdx);
                            break block13;
                        }
                        pageAddr = GridUnsafe.bufferAddress(this.locBuff);
                        io = (DataPageIO)PageIO.getPageIO(1, PageIO.getVersion(pageAddr));
                        freeSpace = io.getFreeSpace(pageAddr);
                        rowsCnt = io.getDirectCount(pageAddr);
                        if (!first) ** GOTO lbl-1000
                        if (rowsCnt == 0) {
                            DataPageIterator.setBit(this.readPages, pageIdx);
                        } else if (freeSpace == 0 && rowsCnt == 1) {
                            payload = io.readPayload(pageAddr, 0, this.locBuff.capacity());
                            link = payload.nextLink();
                            if (link != 0L) {
                                DataPageIterator.setBit(this.tailPages, PageIdUtils.pageIndex(PageIdUtils.pageId(link)));
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            DataPageIterator.setBit(this.readPages, pageIdx);
                            for (itemId = 0; itemId < rowsCnt; ++itemId) {
                                row = new DataRow();
                                row.partition(this.partId);
                                row.initFromPageBuffer(this.sctx, this.coctx, new IgniteThrowableFunction<Long, ByteBuffer>(){

                                    @Override
                                    public ByteBuffer apply(Long nextPageId) throws IgniteCheckedException {
                                        boolean success = this.readPageFromStore(nextPageId, fragmentBuff);
                                        assert (success) : "Only FLAG_DATA pages allowed: " + PageIdUtils.toDetailString(nextPageId);
                                        DataPageIterator.setBit(readPages, PageIdUtils.pageIndex(nextPageId));
                                        return fragmentBuff;
                                    }
                                }, this.locBuff, itemId, false, CacheDataRowAdapter.RowData.FULL, false);
                                this.rows.add(row);
                            }
                        }
                    }
                    ++this.currIdx;
                }
                if (this.currIdx == 2 * this.pages) {
                    this.secondScanComplete = true;
                    set = true;
                    for (j = 0; j < this.pages; ++j) {
                        set &= this.readPages.get(j);
                    }
                    if (!DataPageIterator.$assertionsDisabled && !set) {
                        throw new AssertionError((Object)("readPages=" + this.readPages + ", pages=" + this.pages));
                    }
                }
                return this.rows.isEmpty() == false;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteCheckedException("Error during iteration through page store: " + this, e);
            }
        }

        private static void setBit(BitSet bitSet, int idx) {
            boolean bit = bitSet.get(idx);
            assert (!bit) : "Bit with given index already set: " + idx;
            bitSet.set(idx);
        }

        private boolean readPageFromStore(long pageId, ByteBuffer buff) throws IgniteCheckedException {
            buff.clear();
            boolean read = this.store.read(pageId, buff, true);
            assert (read) : PageIdUtils.toDetailString(pageId);
            if (PageIO.getCompressionType(buff) != 0) {
                this.compressProc.decompressPage(buff, this.store.getPageSize());
            }
            return PageIO.getType(buff) == PageIdUtils.flag(pageId);
        }

        public String toString() {
            return S.toString(DataPageIterator.class, this, super.toString());
        }
    }

    protected static class SnapshotHandlers {
        private final Map<SnapshotHandlerType, List<SnapshotHandler<Object>>> handlers = new EnumMap<SnapshotHandlerType, List<SnapshotHandler<Object>>>(SnapshotHandlerType.class);
        private ExecutorService execSvc;

        protected SnapshotHandlers() {
        }

        private void initialize(GridKernalContext ctx, ExecutorService execSvc) {
            this.execSvc = execSvc;
            this.registerHandler(new SnapshotPartitionsVerifyHandler(ctx.cache().context()));
            this.registerHandler(new DataStreamerUpdatesHandler());
            this.registerHandler(new SnapshotPartitionsQuickVerifyHandler(ctx.cache().context()));
            SnapshotHandler[] extHnds = (SnapshotHandler[])ctx.plugins().extensions(SnapshotHandler.class);
            if (extHnds == null) {
                return;
            }
            for (SnapshotHandler extHnd : extHnds) {
                this.registerHandler(extHnd);
            }
        }

        @Nullable
        protected Map<String, SnapshotHandlerResult<Object>> invokeAll(SnapshotHandlerType type, SnapshotHandlerContext ctx) throws IgniteCheckedException {
            List<SnapshotHandler<Object>> handlers = this.handlers.get((Object)type);
            if (F.isEmpty(handlers)) {
                return null;
            }
            if (handlers.size() == 1) {
                SnapshotHandler<Object> hnd2 = handlers.get(0);
                return F.asMap(hnd2.getClass().getName(), this.invoke(hnd2, ctx));
            }
            return U.doInParallel(this.execSvc, handlers, hnd -> new T2<String, SnapshotHandlerResult<Object>>(hnd.getClass().getName(), this.invoke((SnapshotHandler<Object>)hnd, ctx))).stream().collect(Collectors.toMap(IgniteBiTuple::getKey, IgniteBiTuple::getValue));
        }

        protected void completeAll(SnapshotHandlerType type, String snpName, Map<String, List<SnapshotHandlerResult<?>>> res, Collection<UUID> reqNodes, Consumer<List<String>> wrnsHnd) throws Exception {
            if (res.isEmpty()) {
                return;
            }
            List<SnapshotHandler<Object>> hnds = this.handlers.get((Object)type);
            if (hnds == null || hnds.size() != res.size()) {
                throw new IgniteCheckedException("Snapshot handlers configuration mismatch (number of local snapshot handlers differs from the remote one). The current operation will be aborted [locHnds=" + (hnds == null ? "" : F.viewReadOnly(hnds, h -> h.getClass().getName(), new IgnitePredicate[0]).toString()) + ", rmtHnds=" + res.keySet() + "].");
            }
            ArrayList<String> wrns = new ArrayList<String>();
            for (SnapshotHandler<Object> hnd : hnds) {
                List nodesRes = res.get(hnd.getClass().getName());
                if (nodesRes == null || nodesRes.size() < reqNodes.size()) {
                    HashSet<UUID> missing = new HashSet<UUID>(reqNodes);
                    if (nodesRes != null) {
                        missing.removeAll(F.viewReadOnly(nodesRes, r -> r.node().id(), new IgnitePredicate[0]));
                    }
                    throw new IgniteCheckedException("Snapshot handlers configuration mismatch, \"" + hnd.getClass().getName() + "\" handler is missing on the remote node(s). The current operation will be aborted [missing=" + missing + "].");
                }
                try {
                    hnd.complete(snpName, nodesRes);
                }
                catch (SnapshotWarningException e) {
                    wrns.add(e.getMessage());
                }
            }
            if (!F.isEmpty(wrns)) {
                wrnsHnd.accept(wrns);
            }
        }

        private SnapshotHandlerResult<Object> invoke(SnapshotHandler<Object> hnd, SnapshotHandlerContext ctx) {
            try {
                return new SnapshotHandlerResult<Object>(hnd.invoke(ctx), null, ctx.localNode());
            }
            catch (Exception e) {
                U.error(null, "Error invoking snapshot handler", e);
                return new SnapshotHandlerResult<Object>(null, e, ctx.localNode());
            }
        }

        private void registerHandler(SnapshotHandler hnd) {
            this.handlers.computeIfAbsent(hnd.type(), v -> new ArrayList()).add(hnd);
        }
    }
}

