/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBiVisitor;
import org.apache.calcite.rex.RexLambdaRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RexLambda
extends RexNode {
    private final List<RexLambdaRef> parameters;
    private final RexNode expression;

    RexLambda(List<RexLambdaRef> parameters, RexNode expression) {
        this.parameters = ImmutableList.copyOf(parameters);
        this.expression = Objects.requireNonNull(expression, "expression");
    }

    @Override
    public RelDataType getType() {
        return this.expression.getType();
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.LAMBDA;
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitLambda(this);
    }

    @Override
    public <R, P> R accept(RexBiVisitor<R, P> visitor, P arg) {
        return visitor.visitLambda(this, arg);
    }

    public RexNode getExpression() {
        return this.expression;
    }

    public List<RexLambdaRef> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        return this == o || o instanceof RexLambda && this.expression.equals(((RexLambda)o).expression) && this.parameters.equals(((RexLambda)o).parameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.parameters);
    }

    @Override
    public String toString() {
        if (this.digest == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            for (Ord ord : Ord.zip(this.parameters)) {
                RexLambdaRef parameter = (RexLambdaRef)ord.e;
                if (ord.i != 0) {
                    sb.append(", ");
                }
                sb.append(parameter.getName());
            }
            sb.append(") -> ");
            sb.append(this.expression);
            this.digest = sb.toString();
        }
        return this.digest;
    }
}

