/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.schema;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.raft.Marshaller;
import org.apache.ignite.internal.raft.util.OptimizedMarshaller;
import org.apache.ignite.internal.table.distributed.schema.CatalogVersionSufficiency;
import org.apache.ignite.internal.table.distributed.schema.PartitionCommandsMarshaller;
import org.apache.ignite.raft.jraft.Node;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.RaftServerService;
import org.apache.ignite.raft.jraft.rpc.RpcRequestClosure;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.impl.core.AppendEntriesRequestInterceptor;
import org.jetbrains.annotations.Nullable;

public class CheckCatalogVersionOnAppendEntries
implements AppendEntriesRequestInterceptor {
    private static final IgniteLogger LOG = Loggers.forClass(CheckCatalogVersionOnAppendEntries.class);
    private final CatalogService catalogService;

    public CheckCatalogVersionOnAppendEntries(CatalogService catalogService) {
        this.catalogService = catalogService;
    }

    @Nullable
    public Message intercept(RaftServerService service, RpcRequests.AppendEntriesRequest request, RpcRequestClosure done) {
        if (request.entriesList() == null || request.data() == null) {
            return null;
        }
        Node node = (Node)service;
        ByteBuffer allData = request.data().asReadOnlyBuffer().order(OptimizedMarshaller.ORDER);
        int offset = 0;
        for (RaftOutter.EntryMeta entry : request.entriesList()) {
            int requiredCatalogVersion = CheckCatalogVersionOnAppendEntries.readRequiredCatalogVersionForMeta(allData, entry, node.getOptions().getCommandsMarshaller());
            if (requiredCatalogVersion != -1 && !CatalogVersionSufficiency.isMetadataAvailableFor(requiredCatalogVersion, this.catalogService)) {
                LOG.warn("Metadata not yet available, rejecting AppendEntriesRequest with EBUSY [group={}, requiredLevel={}].", new Object[]{request.groupId(), requiredCatalogVersion});
                return RaftRpcFactory.DEFAULT.newResponse(node.getRaftOptions().getRaftMessagesFactory(), RaftError.EBUSY, "Metadata not yet available, rejecting AppendEntriesRequest with EBUSY [group=%s, requiredLevel=%d].", new Object[]{request.groupId(), requiredCatalogVersion});
            }
            allData.position(offset += (int)entry.dataLen());
        }
        return null;
    }

    private static int readRequiredCatalogVersionForMeta(ByteBuffer allData, RaftOutter.EntryMeta entry, Marshaller commandsMarshaller) {
        if (entry.type() != EnumOutter.EntryType.ENTRY_TYPE_DATA) {
            return -1;
        }
        if (!(commandsMarshaller instanceof PartitionCommandsMarshaller)) {
            return -1;
        }
        PartitionCommandsMarshaller partitionCommandsMarshaller = (PartitionCommandsMarshaller)commandsMarshaller;
        long dataLen = entry.dataLen();
        if (dataLen > 0L) {
            return partitionCommandsMarshaller.readRequiredCatalogVersion(allData);
        }
        return -1;
    }
}

