/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.metrics;

import java.util.List;
import java.util.Objects;
import java.util.function.IntSupplier;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.IntGauge;
import org.apache.ignite.internal.metrics.Metric;

public class SqlClientMetricSource
extends AbstractMetricSource<Holder> {
    public static final String NAME = "sql.client";
    public static final String METRIC_OPEN_CURSORS = "OpenCursors";
    private final IntSupplier numberOfOpenCursorsSupplier;

    public SqlClientMetricSource(IntSupplier numberOfOpenCursorsSupplier) {
        super(NAME);
        this.numberOfOpenCursorsSupplier = Objects.requireNonNull(numberOfOpenCursorsSupplier);
    }

    protected Holder createHolder() {
        return new Holder();
    }

    protected class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final IntGauge numberOfOpenCursors;

        protected Holder() {
            this.numberOfOpenCursors = new IntGauge(SqlClientMetricSource.METRIC_OPEN_CURSORS, "Number of current open cursors", SqlClientMetricSource.this.numberOfOpenCursorsSupplier);
        }

        public Iterable<Metric> metrics() {
            return List.of(this.numberOfOpenCursors);
        }
    }
}

