/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.config.ini;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ignite.internal.cli.config.CliConfigKeys;
import org.apache.ignite.internal.cli.config.ConfigManager;
import org.apache.ignite.internal.cli.config.Profile;
import org.apache.ignite.internal.cli.config.exception.ConfigInitializationException;
import org.apache.ignite.internal.cli.config.exception.ProfileNotFoundException;
import org.apache.ignite.internal.cli.config.ini.IniConfig;
import org.apache.ignite.internal.cli.config.ini.IniFile;
import org.apache.ignite.internal.cli.config.ini.IniProfile;
import org.apache.ignite.internal.cli.config.ini.IniSection;
import org.apache.ignite.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite.internal.cli.logger.CliLoggers;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.util.OperatingSystem;

public class IniConfigManager
implements ConfigManager {
    private static final IgniteLogger LOG = CliLoggers.forClass(IniConfigManager.class);
    private static final String DEFAULT_PROFILE_NAME = "default";
    private final IniFile configFile;
    private final IniFile secretConfigFile;
    private String currentProfileName;

    public IniConfigManager(File configFile, File secretConfigFile) {
        this.configFile = this.configFile(configFile);
        this.secretConfigFile = this.secretConfigFile(secretConfigFile);
        this.currentProfileName = IniConfigManager.findCurrentProfileName(this.configFile);
    }

    private IniFile configFile(File file) {
        IniFile configFile;
        try {
            configFile = new IniFile(file);
            IniConfigManager.findCurrentProfileName(configFile);
        }
        catch (IOException | NoSuchElementException e) {
            LOG.warn("User config is corrupted or doesn't exist.", (Throwable)e);
            try {
                configFile = IniConfigManager.createDefaultConfig(file);
            }
            catch (Exception ex) {
                throw new IgniteCliException("Couldn't create default config", ex);
            }
        }
        return configFile;
    }

    private IniFile secretConfigFile(File file) {
        IniFile configFile;
        try {
            if (OperatingSystem.current() != OperatingSystem.WINDOWS) {
                Set<PosixFilePermission> posixFilePermissions = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
                if (!IniConfigManager.secretPermission().equals(posixFilePermissions)) {
                    throw new IgniteCliException("The secret configuration file must have 700 permissions");
                }
            }
            configFile = new IniFile(file);
        }
        catch (IOException e) {
            LOG.warn("User secret config is corrupted or doesn't exist.", (Throwable)e);
            try {
                configFile = IniConfigManager.createDefaultSecretConfig(file);
            }
            catch (Exception ex) {
                throw new IgniteCliException("Couldn't create secret default config", ex);
            }
        }
        return configFile;
    }

    private static String findCurrentProfileName(IniFile configFile) {
        IniSection topLevelSection = configFile.getTopLevelSection();
        IniSection section = configFile.getSections().stream().findFirst().orElseThrow();
        String currentProfile = topLevelSection.getProperty("current_profile");
        if (currentProfile == null) {
            topLevelSection.setProperty("current_profile", section.getName());
            currentProfile = section.getName();
        }
        return currentProfile;
    }

    @Override
    public Profile getCurrentProfile() {
        return this.getProfile(this.currentProfileName);
    }

    @Override
    public Profile getProfile(String profile) {
        IniSection section = this.configFile.getSection(profile);
        if (section == null) {
            throw new ProfileNotFoundException(profile);
        }
        IniSection secretSection = this.secretConfigFile.getOrCreateSection(profile);
        IniConfig config = new IniConfig(section, this.configFile::store);
        IniConfig secretConfig = new IniConfig(secretSection, this.secretConfigFile::store);
        return new IniProfile(section.getName(), config, secretConfig);
    }

    @Override
    public Profile createProfile(String profileName) {
        IniSection section = this.configFile.createSection(profileName);
        IniSection secretSection = this.secretConfigFile.createSection(profileName);
        IniConfig config = new IniConfig(section, this.configFile::store);
        IniConfig secretConfig = new IniConfig(secretSection, this.secretConfigFile::store);
        return new IniProfile(profileName, config, secretConfig);
    }

    @Override
    public void setCurrentProfile(String profileName) {
        IniSection section = this.configFile.getSection(profileName);
        if (section == null) {
            throw new ProfileNotFoundException(profileName);
        }
        this.currentProfileName = profileName;
        this.configFile.getTopLevelSection().setProperty("current_profile", profileName);
        this.configFile.store();
    }

    @Override
    public Collection<String> getProfileNames() {
        return this.configFile.getSectionNames();
    }

    private static IniFile createDefaultConfig(File file) {
        try {
            file.getParentFile().mkdirs();
            file.delete();
            file.createNewFile();
            IniFile ini = new IniFile(file);
            ini.getTopLevelSection().setProperty("current_profile", DEFAULT_PROFILE_NAME);
            IniSection defaultSection = ini.createSection(DEFAULT_PROFILE_NAME);
            defaultSection.setProperty(CliConfigKeys.CLUSTER_URL.value(), "http://localhost:10300");
            defaultSection.setProperty(CliConfigKeys.JDBC_URL.value(), "jdbc:ignite:thin://127.0.0.1:10800");
            defaultSection.setProperty(CliConfigKeys.SQL_MULTILINE.value(), "true");
            defaultSection.setProperty(CliConfigKeys.SYNTAX_HIGHLIGHTING.value(), "true");
            ini.store();
            return ini;
        }
        catch (IOException e) {
            throw new ConfigInitializationException(file.getAbsolutePath(), e);
        }
    }

    private static IniFile createDefaultSecretConfig(File file) {
        try {
            file.getParentFile().mkdirs();
            file.delete();
            if (OperatingSystem.current() == OperatingSystem.WINDOWS) {
                Files.createFile(file.toPath(), new FileAttribute[0]);
            } else {
                Files.createFile(file.toPath(), PosixFilePermissions.asFileAttribute(IniConfigManager.secretPermission()));
            }
            IniFile ini = new IniFile(file);
            IniSection defaultSection = ini.createSection(DEFAULT_PROFILE_NAME);
            defaultSection.setProperty(CliConfigKeys.REST_KEY_STORE_PATH.value(), "");
            defaultSection.setProperty(CliConfigKeys.REST_KEY_STORE_PASSWORD.value(), "");
            defaultSection.setProperty(CliConfigKeys.REST_TRUST_STORE_PATH.value(), "");
            defaultSection.setProperty(CliConfigKeys.REST_TRUST_STORE_PASSWORD.value(), "");
            defaultSection.setProperty(CliConfigKeys.JDBC_KEY_STORE_PATH.value(), "");
            defaultSection.setProperty(CliConfigKeys.JDBC_KEY_STORE_PASSWORD.value(), "");
            defaultSection.setProperty(CliConfigKeys.JDBC_TRUST_STORE_PATH.value(), "");
            defaultSection.setProperty(CliConfigKeys.JDBC_TRUST_STORE_PASSWORD.value(), "");
            defaultSection.setProperty(CliConfigKeys.JDBC_CLIENT_AUTH.value(), "");
            defaultSection.setProperty(CliConfigKeys.BASIC_AUTHENTICATION_USERNAME.value(), "");
            defaultSection.setProperty(CliConfigKeys.BASIC_AUTHENTICATION_PASSWORD.value(), "");
            ini.store();
            return ini;
        }
        catch (IOException e) {
            throw new ConfigInitializationException(file.getAbsolutePath(), e);
        }
    }

    private static Set<PosixFilePermission> secretPermission() {
        return Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
    }
}

