/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview.walker;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.processors.query.stat.view.StatisticsColumnPartitionDataView;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;

public class StatisticsColumnPartitionDataViewWalker
implements SystemViewRowAttributeWalker<StatisticsColumnPartitionDataView> {
    public static final String SCHEMA_FILTER = "schema";
    public static final String TYPE_FILTER = "type";
    public static final String NAME_FILTER = "name";
    public static final String COLUMN_FILTER = "column";
    public static final String PARTITION_FILTER = "partition";
    private static final List<String> FILTRABLE_ATTRS = Collections.unmodifiableList(F.asList(new String[]{"schema", "type", "name", "column", "partition"}));

    @Override
    public List<String> filtrableAttributes() {
        return FILTRABLE_ATTRS;
    }

    @Override
    public void visitAll(SystemViewRowAttributeWalker.AttributeVisitor v) {
        v.accept(0, SCHEMA_FILTER, String.class);
        v.accept(1, TYPE_FILTER, String.class);
        v.accept(2, NAME_FILTER, String.class);
        v.accept(3, COLUMN_FILTER, String.class);
        v.accept(4, PARTITION_FILTER, Integer.TYPE);
        v.accept(5, "rowsCount", Long.TYPE);
        v.accept(6, "updateCounter", Long.TYPE);
        v.accept(7, "distinct", Long.TYPE);
        v.accept(8, "nulls", Long.TYPE);
        v.accept(9, "total", Long.TYPE);
        v.accept(10, "size", Integer.TYPE);
        v.accept(11, "version", Long.TYPE);
        v.accept(12, "lastUpdateTime", Long.TYPE);
    }

    @Override
    public void visitAll(StatisticsColumnPartitionDataView row, SystemViewRowAttributeWalker.AttributeWithValueVisitor v) {
        v.accept(0, SCHEMA_FILTER, String.class, row.schema());
        v.accept(1, TYPE_FILTER, String.class, row.type());
        v.accept(2, NAME_FILTER, String.class, row.name());
        v.accept(3, COLUMN_FILTER, String.class, row.column());
        v.acceptInt(4, PARTITION_FILTER, row.partition());
        v.acceptLong(5, "rowsCount", row.rowsCount());
        v.acceptLong(6, "updateCounter", row.updateCounter());
        v.acceptLong(7, "distinct", row.distinct());
        v.acceptLong(8, "nulls", row.nulls());
        v.acceptLong(9, "total", row.total());
        v.acceptInt(10, "size", row.size());
        v.acceptLong(11, "version", row.version());
        v.acceptLong(12, "lastUpdateTime", row.lastUpdateTime());
    }

    @Override
    public int count() {
        return 13;
    }
}

