/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.util;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.pagememory.util.PageIdUtils;
import org.apache.ignite3.internal.pagememory.util.PageUtils;

public class PartitionlessLinks {
    public static final int PARTITIONLESS_LINK_SIZE_BYTES = 6;

    public static long readPartitionless(int partitionId, long pageAddr, int offset) {
        int tag = PageUtils.getShort(pageAddr, offset) & 0xFFFF;
        int pageIdx = PageUtils.getInt(pageAddr, offset + 2);
        if (pageIdx == 0) {
            assert (tag == 0) : tag;
            return 0L;
        }
        byte flags = (byte)tag;
        int itemId = tag >>> 8;
        long pageId = PageIdUtils.pageId(partitionId, flags, pageIdx);
        return PageIdUtils.link(pageId, itemId);
    }

    public static int writePartitionless(long addr, long link) {
        PageUtils.putShort(addr, 0, (short)PageIdUtils.tag(link));
        PageUtils.putInt(addr + 2L, 0, PageIdUtils.pageIndex(link));
        return 6;
    }

    public static void writeToBuffer(ByteBuffer buffer, long link) {
        buffer.putShort((short)PageIdUtils.tag(link));
        buffer.putInt(PageIdUtils.pageIndex(link));
    }
}

