/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.azure;

import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;

public class TcpDiscoveryAzureBlobStoreIpFinder
extends TcpDiscoveryIpFinderAdapter {
    private static final byte[] OBJECT_CONTENT = new byte[0];
    @LoggerResource
    private IgniteLogger log;
    private String accountName;
    private String accountKey;
    private String endPoint;
    private String containerName;
    StorageSharedKeyCredential credential;
    private BlobServiceClient blobServiceClient;
    private BlobContainerClient blobContainerClient;
    private final AtomicBoolean initGuard = new AtomicBoolean();
    private final CountDownLatch initLatch = new CountDownLatch(1);

    public TcpDiscoveryAzureBlobStoreIpFinder() {
        this.setShared(true);
    }

    public Collection<InetSocketAddress> getRegisteredAddresses() throws IgniteSpiException {
        this.init();
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        HashSet<String> seenBlobNames = new HashSet<String>();
        for (BlobItem blobItem : this.blobContainerClient.listBlobs()) {
            try {
                if (blobItem.isDeleted()) continue;
                addrs.add(this.addrFromString(blobItem.getName()));
                seenBlobNames.add(blobItem.getName());
            }
            catch (Exception e) {
                throw new IgniteSpiException("Failed to get content from the container: " + this.containerName, (Throwable)e);
            }
        }
        return addrs;
    }

    public void registerAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        assert (!F.isEmpty(addrs));
        this.init();
        for (InetSocketAddress addr : addrs) {
            try {
                String key = URLEncoder.encode(this.keyFromAddr(addr), StandardCharsets.UTF_8.name());
                BlockBlobClient blobClient = this.blobContainerClient.getBlobClient(key).getBlockBlobClient();
                blobClient.upload((InputStream)new ByteArrayInputStream(OBJECT_CONTENT), (long)OBJECT_CONTENT.length);
            }
            catch (UnsupportedEncodingException e) {
                throw new IgniteSpiException("Unable to encode URL due to error " + e.getMessage(), (Throwable)e);
            }
            catch (BlobStorageException e) {
                if (e.getStatusCode() == 409) continue;
                throw new IgniteSpiException("Failed to upload blob with exception " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void unregisterAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
        assert (!F.isEmpty(addrs));
        this.init();
        for (InetSocketAddress addr : addrs) {
            String key = this.keyFromAddr(addr);
            try {
                this.blobContainerClient.getBlobClient(key).delete();
            }
            catch (Exception e) {
                if (e.getMessage().contains("InterruptedException") && (!(e instanceof BlobStorageException) || ((BlobStorageException)((Object)e)).getErrorCode() == BlobErrorCode.BLOB_NOT_FOUND)) continue;
                throw new IgniteSpiException("Failed to delete entry [containerName=" + this.containerName + ", entry=" + key + ']', (Throwable)e);
            }
        }
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryAzureBlobStoreIpFinder setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryAzureBlobStoreIpFinder setAccountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryAzureBlobStoreIpFinder setAccountEndpoint(String endPoint) {
        this.endPoint = endPoint;
        return this;
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryAzureBlobStoreIpFinder setContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() throws IgniteSpiException {
        if (this.initGuard.compareAndSet(false, true)) {
            if (this.accountKey == null || this.accountName == null || this.containerName == null || this.endPoint == null) {
                throw new IgniteSpiException("One or more of the required parameters is not set [accountName=" + this.accountName + ", accountKey=" + this.accountKey + ", containerName=" + this.containerName + ", endPoint=" + this.endPoint + "]");
            }
            try {
                this.credential = new StorageSharedKeyCredential(this.accountName, this.accountKey);
                this.blobServiceClient = new BlobServiceClientBuilder().endpoint(this.endPoint).credential(this.credential).buildClient();
                this.blobContainerClient = this.blobServiceClient.getBlobContainerClient(this.containerName);
                if (this.blobContainerClient.exists()) return;
                U.warn((IgniteLogger)this.log, (Object)("Container doesn't exist, will create it [containerName=" + this.containerName + "]"));
                this.blobContainerClient.create();
                return;
            }
            finally {
                this.initLatch.countDown();
            }
        }
        try {
            U.await((CountDownLatch)this.initLatch);
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new IgniteSpiException("Thread has been interrupted.", (Throwable)e);
        }
        try {
            if (this.blobContainerClient.exists()) return;
            throw new IgniteSpiException("IpFinder has not been initialized properly");
        }
        catch (Exception e) {
            if (e.getCause() instanceof InterruptedException) return;
            throw e;
        }
    }

    private InetSocketAddress addrFromString(String key) throws IgniteSpiException {
        int port;
        String[] res = key.split("#");
        if (res.length != 2) {
            throw new IgniteSpiException("Invalid address string: " + key);
        }
        try {
            port = Integer.parseInt(res[1]);
        }
        catch (NumberFormatException ignored) {
            throw new IgniteSpiException("Invalid port number: " + res[1]);
        }
        return new InetSocketAddress(res[0], port);
    }

    private String keyFromAddr(InetSocketAddress addr) {
        return addr.getAddress().getHostAddress() + "#" + addr.getPort();
    }

    public TcpDiscoveryAzureBlobStoreIpFinder setShared(boolean shared) {
        super.setShared(shared);
        return this;
    }

    public String toString() {
        return S.toString(TcpDiscoveryAzureBlobStoreIpFinder.class, (Object)((Object)this));
    }
}

