/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.ResourceHttpContent;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class ResourceContentFactory
implements HttpContent.Factory {
    private final ResourceFactory _factory;
    private final MimeTypes _mimeTypes;
    private final boolean _gzip;

    public ResourceContentFactory(ResourceFactory factory, MimeTypes mimeTypes, boolean gzip) {
        this._factory = factory;
        this._mimeTypes = mimeTypes;
        this._gzip = gzip;
    }

    @Override
    public HttpContent getContent(String pathInContext, int maxBufferSize) throws IOException {
        try {
            Resource resource = this._factory.getResource(pathInContext);
            HttpContent loaded = this.load(pathInContext, resource, maxBufferSize);
            return loaded;
        }
        catch (Throwable t) {
            throw (InvalidPathException)new InvalidPathException(pathInContext, "Invalid PathInContext").initCause(t);
        }
    }

    private HttpContent load(String pathInContext, Resource resource, int maxBufferSize) throws IOException {
        String pathInContextGz;
        Resource resourceGz;
        if (resource == null || !resource.exists()) {
            return null;
        }
        if (resource.isDirectory()) {
            return new ResourceHttpContent(resource, this._mimeTypes.getMimeByExtension(resource.toString()), maxBufferSize);
        }
        String mt = this._mimeTypes.getMimeByExtension(pathInContext);
        if (this._gzip && (resourceGz = this._factory.getResource(pathInContextGz = pathInContext + ".gz")).exists() && resourceGz.lastModified() >= resource.lastModified() && resourceGz.length() < resource.length()) {
            return new ResourceHttpContent(resource, mt, maxBufferSize, new ResourceHttpContent(resourceGz, this._mimeTypes.getMimeByExtension(pathInContextGz), maxBufferSize));
        }
        return new ResourceHttpContent(resource, mt, maxBufferSize);
    }

    public String toString() {
        return "ResourceContentFactory[" + this._factory + "]@" + this.hashCode();
    }
}

