/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;

public class INodesInPath {
    public static final Log LOG = LogFactory.getLog(INodesInPath.class);
    private final byte[][] path;
    private final INode[] inodes;
    private final boolean isSnapshot;
    private final int snapshotId;

    private static boolean isDotSnapshotDir(byte[] pathComponent) {
        return pathComponent != null && Arrays.equals(HdfsConstants.DOT_SNAPSHOT_DIR_BYTES, pathComponent);
    }

    static INodesInPath fromINode(INode inode) {
        INode tmp;
        int depth = 0;
        for (tmp = inode; tmp != null; tmp = tmp.getParent()) {
            ++depth;
        }
        byte[][] path = new byte[depth][];
        INode[] inodes = new INode[depth];
        int index = depth;
        for (tmp = inode; tmp != null; tmp = tmp.getParent()) {
            path[--index] = tmp.getKey();
            inodes[index] = tmp;
        }
        return new INodesInPath(inodes, path);
    }

    private static String constructPath(byte[][] components, int start, int end) {
        StringBuilder buf = new StringBuilder();
        for (int i = start; i < end; ++i) {
            buf.append(DFSUtil.bytes2String(components[i]));
            if (i >= end - 1) continue;
            buf.append("/");
        }
        return buf.toString();
    }

    static INodesInPath resolve(INodeDirectory startingDir, byte[][] components, boolean resolveLink) throws UnresolvedLinkException {
        Preconditions.checkArgument((startingDir.compareTo(components[0]) == 0 ? 1 : 0) != 0);
        INode curNode = startingDir;
        int inodeNum = 0;
        INode[] inodes = new INode[components.length];
        boolean isSnapshot = false;
        int snapshotId = 0x7FFFFFFE;
        for (int count = 0; count < components.length && curNode != null; ++count) {
            INodeDirectory dir;
            boolean lastComp = count == components.length - 1;
            inodes[inodeNum++] = curNode;
            boolean isRef = curNode.isReference();
            boolean isDir = curNode.isDirectory();
            INodeDirectory iNodeDirectory = dir = isDir ? curNode.asDirectory() : null;
            if (!isRef && isDir && dir.isWithSnapshot()) {
                if (!isSnapshot && INodesInPath.shouldUpdateLatestId(dir.getDirectoryWithSnapshotFeature().getLastSnapshotId(), snapshotId)) {
                    snapshotId = dir.getDirectoryWithSnapshotFeature().getLastSnapshotId();
                }
            } else if (isRef && isDir && !lastComp && !isSnapshot) {
                int dstSnapshotId = curNode.asReference().getDstSnapshotId();
                if (snapshotId == 0x7FFFFFFE || dstSnapshotId != 0x7FFFFFFE && dstSnapshotId >= snapshotId) {
                    DirectoryWithSnapshotFeature sf;
                    int lastSnapshot = 0x7FFFFFFE;
                    if (curNode.isDirectory() && (sf = curNode.asDirectory().getDirectoryWithSnapshotFeature()) != null) {
                        lastSnapshot = sf.getLastSnapshotId();
                    }
                    snapshotId = lastSnapshot;
                }
            }
            if (curNode.isSymlink() && (!lastComp || resolveLink)) {
                String path = INodesInPath.constructPath(components, 0, components.length);
                String preceding = INodesInPath.constructPath(components, 0, count);
                String remainder = INodesInPath.constructPath(components, count + 1, components.length);
                String link = DFSUtil.bytes2String(components[count]);
                String target = curNode.asSymlink().getSymlinkString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("UnresolvedPathException  path: " + path + " preceding: " + preceding + " count: " + count + " link: " + link + " target: " + target + " remainder: " + remainder));
                }
                throw new UnresolvedPathException(path, preceding, remainder, target);
            }
            if (lastComp || !isDir) break;
            byte[] childName = components[count + 1];
            if (INodesInPath.isDotSnapshotDir(childName) && dir.isSnapshottable()) {
                isSnapshot = true;
                if (++count == components.length - 1) break;
                Snapshot s = dir.getSnapshot(components[count + 1]);
                if (s == null) {
                    curNode = null;
                    continue;
                }
                curNode = s.getRoot();
                snapshotId = s.getId();
                continue;
            }
            curNode = dir.getChild(childName, isSnapshot ? snapshotId : 0x7FFFFFFE);
        }
        if (isSnapshot && !INodesInPath.isDotSnapshotDir(components[components.length - 1])) {
            INode[] newNodes = new INode[components.length - 1];
            System.arraycopy(inodes, 0, newNodes, 0, newNodes.length);
            inodes = newNodes;
        }
        return new INodesInPath(inodes, components, isSnapshot, snapshotId);
    }

    private static boolean shouldUpdateLatestId(int sid, int snapshotId) {
        return snapshotId == 0x7FFFFFFE || sid != 0x7FFFFFFE && Snapshot.ID_INTEGER_COMPARATOR.compare(snapshotId, sid) < 0;
    }

    public static INodesInPath replace(INodesInPath iip, int pos, INode inode) {
        Preconditions.checkArgument((iip.length() > 0 && pos > 0 && pos < iip.length() ? 1 : 0) != 0);
        if (iip.getINode(pos) == null) {
            Preconditions.checkState((iip.getINode(pos - 1) != null ? 1 : 0) != 0);
        }
        INode[] inodes = new INode[iip.inodes.length];
        System.arraycopy(iip.inodes, 0, inodes, 0, inodes.length);
        inodes[pos] = inode;
        return new INodesInPath(inodes, iip.path, iip.isSnapshot, iip.snapshotId);
    }

    public static INodesInPath append(INodesInPath iip, INode child, byte[] childName) {
        Preconditions.checkArgument((!iip.isSnapshot && iip.length() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((iip.getLastINode() != null && iip.getLastINode().isDirectory() ? 1 : 0) != 0);
        INode[] inodes = new INode[iip.length() + 1];
        System.arraycopy(iip.inodes, 0, inodes, 0, inodes.length - 1);
        inodes[inodes.length - 1] = child;
        byte[][] path = new byte[iip.path.length + 1][];
        System.arraycopy(iip.path, 0, path, 0, path.length - 1);
        path[path.length - 1] = childName;
        return new INodesInPath(inodes, path, false, iip.snapshotId);
    }

    private INodesInPath(INode[] inodes, byte[][] path, boolean isSnapshot, int snapshotId) {
        Preconditions.checkArgument((inodes != null && path != null ? 1 : 0) != 0);
        this.inodes = inodes;
        this.path = path;
        this.isSnapshot = isSnapshot;
        this.snapshotId = snapshotId;
    }

    private INodesInPath(INode[] inodes, byte[][] path) {
        this(inodes, path, false, 0x7FFFFFFE);
    }

    public int getLatestSnapshotId() {
        Preconditions.checkState((!this.isSnapshot ? 1 : 0) != 0);
        return this.snapshotId;
    }

    public int getPathSnapshotId() {
        return this.isSnapshot ? this.snapshotId : 0x7FFFFFFE;
    }

    public INode getINode(int i) {
        int index;
        if (this.inodes == null || this.inodes.length == 0) {
            throw new NoSuchElementException("inodes is null or empty");
        }
        int n = index = i >= 0 ? i : this.inodes.length + i;
        if (index < this.inodes.length && index >= 0) {
            return this.inodes[index];
        }
        throw new NoSuchElementException("inodes.length == " + this.inodes.length);
    }

    public INode getLastINode() {
        return this.getINode(-1);
    }

    byte[] getLastLocalName() {
        return this.path[this.path.length - 1];
    }

    public byte[][] getPathComponents() {
        return this.path;
    }

    public String getPath() {
        return DFSUtil.byteArray2PathString(this.path);
    }

    public String getParentPath() {
        return this.getPath(this.path.length - 1);
    }

    public String getPath(int pos) {
        return DFSUtil.byteArray2PathString(this.path, 0, pos);
    }

    public List<String> getPath(int offset, int length) {
        Preconditions.checkArgument((offset >= 0 && length >= 0 && offset + length <= this.path.length ? 1 : 0) != 0);
        ImmutableList.Builder components = ImmutableList.builder();
        for (int i = offset; i < offset + length; ++i) {
            components.add((Object)DFSUtil.bytes2String(this.path[i]));
        }
        return components.build();
    }

    public int length() {
        return this.inodes.length;
    }

    public List<INode> getReadOnlyINodes() {
        return Collections.unmodifiableList(Arrays.asList(this.inodes));
    }

    public INode[] getINodesArray() {
        INode[] retArr = new INode[this.inodes.length];
        System.arraycopy(this.inodes, 0, retArr, 0, this.inodes.length);
        return retArr;
    }

    private INodesInPath getAncestorINodesInPath(int length) {
        Preconditions.checkArgument((length >= 0 && length < this.inodes.length ? 1 : 0) != 0);
        Preconditions.checkState((!this.isSnapshot() ? 1 : 0) != 0);
        INode[] anodes = new INode[length];
        byte[][] apath = new byte[length][];
        System.arraycopy(this.inodes, 0, anodes, 0, length);
        System.arraycopy(this.path, 0, apath, 0, length);
        return new INodesInPath(anodes, apath, false, this.snapshotId);
    }

    public INodesInPath getParentINodesInPath() {
        return this.inodes.length > 1 ? this.getAncestorINodesInPath(this.inodes.length - 1) : null;
    }

    public INodesInPath getExistingINodes() {
        int i;
        Preconditions.checkState((!this.isSnapshot() ? 1 : 0) != 0);
        for (i = 0; i < this.inodes.length && this.inodes[i] != null; ++i) {
        }
        INode[] existing = new INode[i];
        byte[][] existingPath = new byte[i][];
        System.arraycopy(this.inodes, 0, existing, 0, i);
        System.arraycopy(this.path, 0, existingPath, 0, i);
        return new INodesInPath(existing, existingPath, false, this.snapshotId);
    }

    boolean isSnapshot() {
        return this.isSnapshot;
    }

    private static String toString(INode inode) {
        return inode == null ? null : inode.getLocalName();
    }

    public String toString() {
        return this.toString(true);
    }

    private String toString(boolean vaildateObject) {
        if (vaildateObject) {
            this.validate();
        }
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append(": path = ").append(DFSUtil.byteArray2PathString(this.path)).append("\n  inodes = ");
        if (this.inodes == null) {
            b.append("null");
        } else if (this.inodes.length == 0) {
            b.append("[]");
        } else {
            b.append("[").append(INodesInPath.toString(this.inodes[0]));
            for (int i = 1; i < this.inodes.length; ++i) {
                b.append(", ").append(INodesInPath.toString(this.inodes[i]));
            }
            b.append("], length=").append(this.inodes.length);
        }
        b.append("\n  isSnapshot        = ").append(this.isSnapshot).append("\n  snapshotId        = ").append(this.snapshotId);
        return b.toString();
    }

    void validate() {
        int i = 0;
        if (this.inodes[i] != null) {
            ++i;
            while (i < this.inodes.length && this.inodes[i] != null) {
                INodeDirectory parent_i = this.inodes[i].getParent();
                INodeDirectory parent_i_1 = this.inodes[i - 1].getParent();
                if (!(parent_i == this.inodes[i - 1] || parent_i_1 != null && parent_i_1.isSnapshottable() && parent_i == parent_i_1)) {
                    throw new AssertionError((Object)("inodes[" + i + "].getParent() != inodes[" + (i - 1) + "]\n  inodes[" + i + "]=" + this.inodes[i].toDetailString() + "\n  inodes[" + (i - 1) + "]=" + this.inodes[i - 1].toDetailString() + "\n this=" + this.toString(false)));
                }
                ++i;
            }
        }
        if (i != this.inodes.length) {
            throw new AssertionError((Object)("i = " + i + " != " + this.inodes.length + ", this=" + this.toString(false)));
        }
    }
}

