/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.utils;

import java.io.File;
import java.io.IOException;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.utils.LineBufferedProcess;
import org.apache.livy.utils.LivySparkUtils$;
import org.apache.livy.utils.LivySparkUtils$$anonfun$sparkScalaVersion$1$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SortedMap;
import scala.collection.SortedMap$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;
import scala.util.matching.Regex;
import scala.util.matching.UnanchoredRegex;

public final class LivySparkUtils$
implements Logging {
    public static final LivySparkUtils$ MODULE$;
    private final SortedMap<Tuple2<Object, Object>, String> org$apache$livy$utils$LivySparkUtils$$_defaultSparkScalaVersion;
    private final Tuple2<Object, Object> MIN_VERSION;
    private final Tuple2<Object, Object> MAX_VERSION;
    private final UnanchoredRegex sparkVersionRegex;
    private final UnanchoredRegex scalaVersionRegex;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new LivySparkUtils$();
    }

    private Logger logger$lzycompute() {
        LivySparkUtils$ livySparkUtils$ = this;
        synchronized (livySparkUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public SortedMap<Tuple2<Object, Object>, String> org$apache$livy$utils$LivySparkUtils$$_defaultSparkScalaVersion() {
        return this.org$apache$livy$utils$LivySparkUtils$$_defaultSparkScalaVersion;
    }

    private Tuple2<Object, Object> MIN_VERSION() {
        return this.MIN_VERSION;
    }

    private Tuple2<Object, Object> MAX_VERSION() {
        return this.MAX_VERSION;
    }

    private UnanchoredRegex sparkVersionRegex() {
        return this.sparkVersionRegex;
    }

    private UnanchoredRegex scalaVersionRegex() {
        return this.scalaVersionRegex;
    }

    public void testSparkHome(LivyConf livyConf) {
        String sparkHome2 = (String)livyConf.sparkHome().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalArgumentException("Livy requires the SPARK_HOME environment variable");
            }
        });
        Predef$.MODULE$.require(new File(sparkHome2).isDirectory(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "SPARK_HOME path does not exist";
            }
        });
    }

    public void testSparkSubmit(LivyConf livyConf) {
        try {
            this.testSparkVersion((String)this.sparkSubmitVersion(livyConf)._1());
            return;
        }
        catch (IOException iOException) {
            throw new IOException("Failed to run spark-submit executable", iOException);
        }
    }

    public void testSparkVersion(String version) {
        Tuple2<Object, Object> v = this.formatSparkVersion(version);
        Predef$.MODULE$.require(Ordering.Implicits$.MODULE$.infixOrderingOps(v, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$greater$eq(this.MIN_VERSION()), (Function0)new Serializable(v){
            public static final long serialVersionUID = 0L;
            private final Tuple2 v$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported Spark version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.v$1}));
            }
            {
                this.v$1 = v$1;
            }
        });
        if (Ordering.Implicits$.MODULE$.infixOrderingOps(v, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$greater$eq(this.MAX_VERSION())) {
            this.warn((Function0<Object>)new Serializable(v){
                public static final long serialVersionUID = 0L;
                private final Tuple2 v$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Current Spark ", " is not verified in Livy, please use it carefully"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.v$1}));
                }
                {
                    this.v$1 = v$1;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<String, Option<String>> sparkSubmitVersion(LivyConf livyConf) {
        void var6_6;
        void var5_5;
        String sparkSubmit2 = livyConf.sparkSubmit();
        ProcessBuilder pb = new ProcessBuilder(sparkSubmit2, "--version");
        pb.redirectErrorStream(true);
        pb.redirectInput(ProcessBuilder.Redirect.PIPE);
        Object object = LivyConf$.MODULE$.TEST_MODE() ? pb.environment().put("LIVY_TEST_CLASSPATH", (String)package$.MODULE$.props().apply((Object)"java.class.path")) : BoxedUnit.UNIT;
        LineBufferedProcess process = new LineBufferedProcess(pb.start(), 200);
        int exitCode = process.waitFor();
        String output = process.inputIterator().mkString("\n");
        String sparkVersion = "";
        String string = output;
        Option option = ((Regex)this.sparkVersionRegex()).unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String version;
            String version2;
            sparkVersion = version2 = (String)((LinearSeqOptimized)option.get()).apply(0);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            String string2 = output;
            Option option2 = ((Regex)this.scalaVersionRegex()).unapplySeq((CharSequence)string2);
            Object object2 = !option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0 && new StringOps(Predef$.MODULE$.augmentString(version = (String)((LinearSeqOptimized)option2.get()).apply(0))).nonEmpty() ? new Some((Object)this.formatScalaVersion(version)) : None$.MODULE$;
            None$ scalaVersion = object2;
            return new Tuple2((Object)sparkVersion, (Object)scalaVersion);
        }
        Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)var5_5);
        void arg$macro$2 = var6_6;
        throw new IOException(new StringOps("Unable to determine spark-submit version [%s]:\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2})));
    }

    public String sparkScalaVersion(Tuple2<Object, Object> formattedSparkVersion, Option<String> scalaVersionFromSparkSubmit, LivyConf livyConf) {
        Option scalaVersionInLivyConf = Option$.MODULE$.apply((Object)livyConf.get(LivyConf$.MODULE$.LIVY_SPARK_SCALA_VERSION())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String scalaVersion) {
                return LivySparkUtils$.MODULE$.formatScalaVersion(scalaVersion);
            }
        });
        scalaVersionFromSparkSubmit.foreach((Function1)new Serializable(scalaVersionInLivyConf){
            public static final long serialVersionUID = 0L;
            private final Option scalaVersionInLivyConf$1;

            public final void apply(String vSparkSubmit) {
                this.scalaVersionInLivyConf$1.foreach((Function1)new Serializable(this, vSparkSubmit){
                    public static final long serialVersionUID = 0L;
                    public final String vSparkSubmit$1;

                    public final void apply(String vLivyConf) {
                        String string = this.vSparkSubmit$1;
                        String string2 = vLivyConf;
                        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0)new Serializable(this, vLivyConf){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$sparkScalaVersion$1$$anonfun$apply$1 $outer;
                            private final String vLivyConf$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scala version detected from spark-submit (", ") does not match "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.vSparkSubmit$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Scala version configured in livy.conf (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.vLivyConf$1}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.vLivyConf$1 = vLivyConf$1;
                            }
                        });
                    }
                    {
                        this.vSparkSubmit$1 = vSparkSubmit$1;
                    }
                });
            }
            {
                this.scalaVersionInLivyConf$1 = scalaVersionInLivyConf$1;
            }
        });
        return (String)scalaVersionInLivyConf.orElse((Function0)new Serializable(scalaVersionFromSparkSubmit){
            public static final long serialVersionUID = 0L;
            private final Option scalaVersionFromSparkSubmit$1;

            public final Option<String> apply() {
                return this.scalaVersionFromSparkSubmit$1;
            }
            {
                this.scalaVersionFromSparkSubmit$1 = scalaVersionFromSparkSubmit$1;
            }
        }).getOrElse((Function0)new Serializable(formattedSparkVersion){
            public static final long serialVersionUID = 0L;
            private final Tuple2 formattedSparkVersion$1;

            public final String apply() {
                return LivySparkUtils$.MODULE$.defaultSparkScalaVersion((Tuple2<Object, Object>)this.formattedSparkVersion$1);
            }
            {
                this.formattedSparkVersion$1 = formattedSparkVersion$1;
            }
        });
    }

    public Tuple2<Object, Object> formatSparkVersion(String version) {
        Regex versionPattern = new StringOps(Predef$.MODULE$.augmentString("^(\\d+)\\.(\\d+)(\\..*)?$")).r();
        Option option = versionPattern.findFirstMatchIn((CharSequence)version);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.x();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toInt(), new StringOps(Predef$.MODULE$.augmentString(m.group(2))).toInt());
            return sp2;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to parse Spark version from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{version})));
        }
        throw new MatchError((Object)option);
    }

    public String formatScalaVersion(String scalaVersion) {
        String string;
        Regex versionPattern = new StringOps(Predef$.MODULE$.augmentString("(\\d)+\\.(\\d+)+.*")).r();
        Option option = versionPattern.unapplySeq((CharSequence)(string = scalaVersion));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String major = (String)((LinearSeqOptimized)option.get()).apply(0);
            String minor = (String)((LinearSeqOptimized)option.get()).apply(1);
            String string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{major, minor}));
            return string2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unrecognized Scala version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scalaVersion})));
    }

    public String defaultSparkScalaVersion(Tuple2<Object, Object> sparkVersion) {
        return (String)this.org$apache$livy$utils$LivySparkUtils$$_defaultSparkScalaVersion().get(sparkVersion).orElse((Function0)new Serializable(sparkVersion){
            public static final long serialVersionUID = 0L;
            public final Tuple2 sparkVersion$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Option<String> apply() {
                None$ none$;
                if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)this.sparkVersion$1, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$less(((Tuple2)LivySparkUtils$.MODULE$.org$apache$livy$utils$LivySparkUtils$$_defaultSparkScalaVersion().head())._1())) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark version ", " is less than the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sparkVersion$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"minimum version ", " supported by Livy"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Tuple2)LivySparkUtils$.MODULE$.org$apache$livy$utils$LivySparkUtils$$_defaultSparkScalaVersion().head())._1()}))).toString());
                }
                if (Ordering.Implicits$.MODULE$.infixOrderingOps((Object)this.sparkVersion$1, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$greater(((Tuple2)LivySparkUtils$.MODULE$.org$apache$livy$utils$LivySparkUtils$$_defaultSparkScalaVersion().last())._1())) {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = (Tuple2)LivySparkUtils$.MODULE$.org$apache$livy$utils$LivySparkUtils$$_defaultSparkScalaVersion().last();
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    Tuple2 spark = (Tuple2)tuple22._1();
                    String scala = (String)tuple22._2();
                    Tuple2 tuple23 = tuple2 = new Tuple2((Object)spark, (Object)scala);
                    Tuple2 spark2 = (Tuple2)tuple23._1();
                    String scala2 = (String)tuple23._2();
                    LivySparkUtils$.MODULE$.warn((Function0<Object>)new Serializable(this, spark2, scala2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.defaultSparkScalaVersion.1 $outer;
                        private final Tuple2 spark$1;
                        private final String scala$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark version ", " is greater then the maximum version "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.sparkVersion$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " supported by Livy, will choose Scala version ", " instead, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.spark$1, this.scala$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"please specify manually if it is the expected Scala version you want"})).s((Seq)Nil$.MODULE$)).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.spark$1 = spark$1;
                            this.scala$1 = scala$1;
                        }
                    });
                    none$ = new Some((Object)scala2);
                    return none$;
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }
            {
                this.sparkVersion$1 = sparkVersion$1;
            }
        }).getOrElse((Function0)new Serializable(sparkVersion){
            public static final long serialVersionUID = 0L;
            private final Tuple2 sparkVersion$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Fail to get Scala version from Spark ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sparkVersion$1})));
            }
            {
                this.sparkVersion$1 = sparkVersion$1;
            }
        });
    }

    private LivySparkUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.org$apache$livy$utils$LivySparkUtils$$_defaultSparkScalaVersion = SortedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(3, 0)), (Object)"2.12"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(2, 4)), (Object)"2.11"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(2, 3)), (Object)"2.11"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(2, 2)), (Object)"2.11")}), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        this.MIN_VERSION = new Tuple2.mcII.sp(2, 2);
        this.MAX_VERSION = new Tuple2.mcII.sp(3, 1);
        this.sparkVersionRegex = new StringOps(Predef$.MODULE$.augmentString("version (.*)")).r().unanchored();
        this.scalaVersionRegex = new StringOps(Predef$.MODULE$.augmentString("Scala version (.*), Java")).r().unanchored();
    }
}

