/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.shaded.kryo.kryo.serializers;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.apache.livy.shaded.kryo.kryo.Kryo;
import org.apache.livy.shaded.kryo.kryo.KryoException;
import org.apache.livy.shaded.kryo.kryo.io.Input;
import org.apache.livy.shaded.kryo.kryo.io.Output;
import org.apache.livy.shaded.kryo.kryo.serializers.FieldSerializer;
import org.apache.livy.shaded.kryo.minlog.Log;

public class VersionFieldSerializer<T>
extends FieldSerializer<T> {
    private int typeVersion = 0;
    private int[] fieldVersion;
    private boolean compatible = true;

    public VersionFieldSerializer(Kryo kryo, Class type) {
        super(kryo, type);
        this.initializeCachedFields();
    }

    public VersionFieldSerializer(Kryo kryo, Class type, boolean compatible) {
        this(kryo, type);
        this.compatible = compatible;
    }

    @Override
    protected void initializeCachedFields() {
        FieldSerializer.CachedField[] fields = this.getFields();
        this.fieldVersion = new int[fields.length];
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            Field field = fields[i].getField();
            Since since = field.getAnnotation(Since.class);
            if (since != null) {
                this.fieldVersion[i] = since.value();
                this.typeVersion = Math.max(this.fieldVersion[i], this.typeVersion);
                continue;
            }
            this.fieldVersion[i] = 0;
        }
        this.removedFields.clear();
        if (Log.DEBUG) {
            Log.debug("Version for type " + this.getType().getName() + " is " + this.typeVersion);
        }
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
        this.initializeCachedFields();
    }

    @Override
    public void removeField(FieldSerializer.CachedField field) {
        super.removeField(field);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields = this.getFields();
        output.writeVarInt(this.typeVersion, true);
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            fields[i].write(output, object);
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type) {
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        int version = input.readVarInt(true);
        if (!this.compatible && version != this.typeVersion) {
            throw new KryoException("Version not compatible: " + version + " <-> " + this.typeVersion);
        }
        FieldSerializer.CachedField[] fields = this.getFields();
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            if (this.fieldVersion[i] > version) {
                if (!Log.DEBUG) continue;
                Log.debug("Skip field " + fields[i].getField().getName());
                continue;
            }
            fields[i].read(input, object);
        }
        return object;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Since {
        public int value() default 0;
    }
}

