/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric.overview;

import org.apache.iotdb.commons.pipe.resource.ref.PipePhantomReferenceManager;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class PipeResourceMetrics
implements IMetricSet {
    private static final String PIPE_USED_MEMORY = "PipeUsedMemory";
    private static final String PIPE_USED_FLOATING_MEMORY = "PipeUsedFloatingMemory";
    private static final String PIPE_TABLET_USED_MEMORY = "PipeTabletUsedMemory";
    private static final String PIPE_TS_FILE_USED_MEMORY = "PipeTsFileUsedMemory";
    private static final String PIPE_TOTAL_MEMORY = "PipeTotalMemory";
    private static final String PIPE_FLOATING_MEMORY = "PipeFloatingMemory";
    private Counter diskIOCounter = DoNothingMetricManager.DO_NOTHING_COUNTER;

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.PIPE_MEM.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeResourceManager.memory(), PipeMemoryManager::getUsedMemorySizeInBytes, new String[]{Tag.NAME.toString(), PIPE_USED_MEMORY});
        metricService.createAutoGauge(Metric.PIPE_MEM.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeResourceManager.memory(), PipeMemoryManager::getUsedMemorySizeInBytesOfTablets, new String[]{Tag.NAME.toString(), PIPE_TABLET_USED_MEMORY});
        metricService.createAutoGauge(Metric.PIPE_MEM.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeResourceManager.memory(), PipeMemoryManager::getUsedMemorySizeInBytesOfTsFiles, new String[]{Tag.NAME.toString(), PIPE_TS_FILE_USED_MEMORY});
        metricService.createAutoGauge(Metric.PIPE_MEM.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeResourceManager.memory(), o -> PipeMemoryManager.getTotalNonFloatingMemorySizeInBytes(), new String[]{Tag.NAME.toString(), PIPE_TOTAL_MEMORY});
        metricService.createAutoGauge(Metric.PIPE_MEM.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeResourceManager.memory(), o -> PipeMemoryManager.getTotalFloatingMemorySizeInBytes(), new String[]{Tag.NAME.toString(), PIPE_FLOATING_MEMORY});
        metricService.createAutoGauge(Metric.PIPE_MEM.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeResourceManager.memory(), o -> PipeDataNodeAgent.task().getAllFloatingMemoryUsageInByte(), new String[]{Tag.NAME.toString(), PIPE_USED_FLOATING_MEMORY});
        metricService.createAutoGauge(Metric.PIPE_PHANTOM_REFERENCE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)PipeDataNodeResourceManager.ref(), PipePhantomReferenceManager::getPhantomReferenceCount, new String[0]);
        this.diskIOCounter = metricService.getOrCreateCounter(Metric.PIPE_TSFILE_SEND_DISK_IO.toString(), MetricLevel.IMPORTANT, new String[0]);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_MEM.toString(), new String[]{Tag.NAME.toString(), PIPE_USED_MEMORY});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_MEM.toString(), new String[]{Tag.NAME.toString(), PIPE_TABLET_USED_MEMORY});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_MEM.toString(), new String[]{Tag.NAME.toString(), PIPE_TS_FILE_USED_MEMORY});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_MEM.toString(), new String[]{Tag.NAME.toString(), PIPE_TOTAL_MEMORY});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_MEM.toString(), new String[]{Tag.NAME.toString(), PIPE_FLOATING_MEMORY});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_MEM.toString(), new String[]{Tag.NAME.toString(), PIPE_USED_FLOATING_MEMORY});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_LINKED_TSFILE_COUNT.toString(), new String[0]);
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_LINKED_TSFILE_SIZE.toString(), new String[0]);
        metricService.remove(MetricType.AUTO_GAUGE, Metric.PIPE_PHANTOM_REFERENCE_COUNT.toString(), new String[0]);
        metricService.remove(MetricType.RATE, Metric.PIPE_TSFILE_SEND_DISK_IO.toString(), new String[0]);
    }

    public void recordDiskIO(long bytes) {
        this.diskIOCounter.inc(bytes);
    }

    public static PipeResourceMetrics getInstance() {
        return PipeResourceMetricsHolder.INSTANCE;
    }

    private PipeResourceMetrics() {
    }

    private static class PipeResourceMetricsHolder {
        private static final PipeResourceMetrics INSTANCE = new PipeResourceMetrics();

        private PipeResourceMetricsHolder() {
        }
    }
}

