/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.enumerated;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.jetbrains.annotations.Nullable;

public enum IdType implements UaEnumeration
{
    Numeric(0),
    String(1),
    Guid(2),
    Opaque(3);

    private final int value;

    private IdType(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static IdType from(int value) {
        switch (value) {
            case 0: {
                return Numeric;
            }
            case 1: {
                return String;
            }
            case 2: {
                return Guid;
            }
            case 3: {
                return Opaque;
            }
        }
        return null;
    }

    public static ExpandedNodeId getTypeId() {
        return ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=256");
    }

    public static class Codec
    extends GenericDataTypeCodec<IdType> {
        @Override
        public Class<IdType> getType() {
            return IdType.class;
        }

        @Override
        public IdType decode(SerializationContext context, UaDecoder decoder) {
            return decoder.readEnum(null, IdType.class);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, IdType value) {
            encoder.writeEnum(null, value);
        }
    }
}

