/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.schema;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;

public class ClusterSchemaQuotaStatistics {
    private long seriesThreshold;
    private long deviceThreshold;
    private final Map<Integer, Long> seriesCountMap = new ConcurrentHashMap<Integer, Long>();
    private final Map<Integer, Long> deviceCountMap = new ConcurrentHashMap<Integer, Long>();

    public ClusterSchemaQuotaStatistics(long seriesThreshold, long deviceThreshold) {
        this.seriesThreshold = seriesThreshold;
        this.deviceThreshold = deviceThreshold;
    }

    public void updateTimeSeriesUsage(@NotNull Map<Integer, Long> seriesUsage) {
        this.seriesCountMap.putAll(seriesUsage);
    }

    public void updateDeviceUsage(@NotNull Map<Integer, Long> deviceUsage) {
        this.deviceCountMap.putAll(deviceUsage);
    }

    public long getSeriesQuotaRemain(Set<Integer> consensusGroupIdSet) {
        long res = this.seriesThreshold - this.seriesCountMap.entrySet().stream().filter(i -> consensusGroupIdSet.contains(i.getKey())).mapToLong(Map.Entry::getValue).sum();
        return res > 0L ? res : 0L;
    }

    public long getDeviceQuotaRemain(Set<Integer> consensusGroupIdSet) {
        long res = this.deviceThreshold - this.deviceCountMap.entrySet().stream().filter(i -> consensusGroupIdSet.contains(i.getKey())).mapToLong(Map.Entry::getValue).sum();
        return res > 0L ? res : 0L;
    }

    public long getSeriesThreshold() {
        return this.seriesThreshold;
    }

    public void setSeriesThreshold(long seriesThreshold) {
        this.seriesThreshold = seriesThreshold;
    }

    public long getDeviceThreshold() {
        return this.deviceThreshold;
    }

    public void setDeviceThreshold(long deviceThreshold) {
        this.deviceThreshold = deviceThreshold;
    }

    public void clear() {
        this.seriesCountMap.clear();
        this.deviceCountMap.clear();
    }
}

