/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative;

import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.SymbolAllocator;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Lookup;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public interface Rule<T> {
    public Pattern<T> getPattern();

    default public boolean isEnabled(SessionInfo sessionInfo) {
        return true;
    }

    public Result apply(T var1, Captures var2, Context var3);

    public static final class Result {
        private static final Result EMPTY = new Result(Optional.empty());
        private final Optional<PlanNode> transformedPlan;

        public static Result empty() {
            return EMPTY;
        }

        public static Result ofPlanNode(PlanNode transformedPlan) {
            return new Result(Optional.of(transformedPlan));
        }

        private Result(Optional<PlanNode> transformedPlan) {
            this.transformedPlan = Objects.requireNonNull(transformedPlan, "transformedPlan is null");
        }

        public Optional<PlanNode> getTransformedPlan() {
            return this.transformedPlan;
        }

        public boolean isEmpty() {
            return !this.transformedPlan.isPresent();
        }
    }

    public static interface Context {
        public Lookup getLookup();

        public QueryId getIdAllocator();

        public SymbolAllocator getSymbolAllocator();

        public SessionInfo getSessionInfo();

        public void checkTimeoutNotExhausted();

        public WarningCollector getWarningCollector();
    }
}

