/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.recover.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertTabletNode;
import org.apache.iotdb.db.service.metrics.WritingMetrics;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.storageengine.dataregion.modification.TableDeletionEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.TreeDeletionEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.Pair;

public class TsFilePlanRedoer {
    private final TsFileResource tsFileResource;
    private IMemTable recoveryMemTable;

    public TsFilePlanRedoer(TsFileResource tsFileResource) {
        this.tsFileResource = tsFileResource;
        this.recoveryMemTable = new PrimitiveMemTable(tsFileResource.getDatabaseName(), tsFileResource.getDataRegionId());
        WritingMetrics.getInstance().recordActiveMemTableCount(tsFileResource.getDataRegionId(), 1);
    }

    void redoDelete(DeleteDataNode deleteDataNode) throws IOException {
        List<MeasurementPath> paths = deleteDataNode.getPathList();
        ArrayList<TreeDeletionEntry> deletionEntries = new ArrayList<TreeDeletionEntry>(paths.size());
        for (MeasurementPath path : paths) {
            TreeDeletionEntry deletionEntry = new TreeDeletionEntry(path, deleteDataNode.getDeleteStartTime(), deleteDataNode.getDeleteEndTime());
            this.recoveryMemTable.delete(deletionEntry);
            deletionEntries.add(deletionEntry);
        }
        this.tsFileResource.getModFileForWrite().write(deletionEntries);
    }

    void redoDelete(RelationalDeleteDataNode node) throws IOException {
        for (TableDeletionEntry modEntry : node.getModEntries()) {
            this.recoveryMemTable.delete(modEntry);
        }
        this.tsFileResource.getModFileForWrite().write(node.getModEntries());
    }

    void redoInsert(InsertNode node) throws WriteProcessException {
        int pointsInserted;
        boolean isSingleDevice;
        if (!node.hasValidMeasurements()) {
            return;
        }
        boolean bl = isSingleDevice = !(node instanceof RelationalInsertTabletNode);
        if (this.tsFileResource != null && isSingleDevice) {
            Optional<Long> lastEndTime = this.tsFileResource.getEndTime(node.getDeviceID());
            long minTimeInNode = node instanceof InsertRowNode ? ((InsertRowNode)node).getTime() : ((InsertTabletNode)node).getTimes()[0];
            if (lastEndTime.isPresent() && lastEndTime.get() >= minTimeInNode) {
                return;
            }
        }
        if (node instanceof InsertRowNode) {
            pointsInserted = node.isAligned() ? this.recoveryMemTable.insertAlignedRow((InsertRowNode)node) : this.recoveryMemTable.insert((InsertRowNode)node);
        } else if (node instanceof RelationalInsertTabletNode) {
            pointsInserted = 0;
            RelationalInsertTabletNode relationalInsertTabletNode = (RelationalInsertTabletNode)node;
            List<Pair<IDeviceID, Integer>> deviceIndexPairs = relationalInsertTabletNode.splitByDevice(0, relationalInsertTabletNode.getRowCount());
            int start = 0;
            for (Pair<IDeviceID, Integer> pair : deviceIndexPairs) {
                IDeviceID deviceID = (IDeviceID)pair.getLeft();
                Optional endTimeInResource = this.tsFileResource == null ? Optional.empty() : this.tsFileResource.getEndTime(deviceID);
                long minTimeOfDevice = relationalInsertTabletNode.getTimes()[start];
                if (endTimeInResource.isPresent() && (Long)endTimeInResource.get() >= minTimeOfDevice) {
                    start = (Integer)pair.getRight();
                    continue;
                }
                pointsInserted = this.recoveryMemTable.insertAlignedTablet(relationalInsertTabletNode, start, (Integer)pair.getRight(), null);
                start = (Integer)pair.getRight();
            }
        } else {
            pointsInserted = node.isAligned() ? this.recoveryMemTable.insertAlignedTablet((InsertTabletNode)node, 0, ((InsertTabletNode)node).getRowCount(), null) : this.recoveryMemTable.insertTablet((InsertTabletNode)node, 0, ((InsertTabletNode)node).getRowCount());
        }
        this.updatePointsInsertedMetric(node, pointsInserted);
    }

    void redoInsertRows(InsertRowsNode insertRowsNode) {
        int pointsInserted = 0;
        for (InsertRowNode node : insertRowsNode.getInsertRowNodeList()) {
            if (!node.hasValidMeasurements()) continue;
            if (this.tsFileResource != null) {
                Optional<Long> lastEndTime = this.tsFileResource.getEndTime(node.getDeviceID());
                long minTimeInNode = node.getTime();
                if (lastEndTime.isPresent() && lastEndTime.get() >= minTimeInNode) continue;
            }
            if (node.isAligned()) {
                pointsInserted += this.recoveryMemTable.insertAlignedRow(node);
                continue;
            }
            pointsInserted += this.recoveryMemTable.insert(node);
        }
        this.updatePointsInsertedMetric(insertRowsNode, pointsInserted);
    }

    private void updatePointsInsertedMetric(InsertNode insertNode, int pointsInserted) {
        MetricService.getInstance().count((long)pointsInserted, Metric.QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), Metric.POINTS_IN.toString(), Tag.DATABASE.toString(), this.tsFileResource.getDatabaseName(), Tag.REGION.toString(), this.tsFileResource.getDataRegionId(), Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
        if (!insertNode.isGeneratedByRemoteConsensusLeader()) {
            MetricService.getInstance().count((long)pointsInserted, Metric.LEADER_QUANTITY.toString(), MetricLevel.CORE, new String[]{Tag.NAME.toString(), Metric.POINTS_IN.toString(), Tag.DATABASE.toString(), this.tsFileResource.getDatabaseName(), Tag.REGION.toString(), this.tsFileResource.getDataRegionId(), Tag.TYPE.toString(), Metric.MEMTABLE_POINT_COUNT.toString()});
        }
    }

    void resetRecoveryMemTable(IMemTable memTable) {
        this.recoveryMemTable = memTable;
    }

    IMemTable getRecoveryMemTable() {
        return this.recoveryMemTable;
    }
}

