/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.entity.DatabasePrivilege;
import org.apache.iotdb.commons.auth.entity.ModelType;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeModelType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.TablePrivilege;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.SerializeUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.rpc.thrift.TDBPrivilege;
import org.apache.iotdb.confignode.rpc.thrift.TPathPrivilege;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.confignode.rpc.thrift.TTablePrivilege;

public class Role {
    protected String name;
    protected int maxSessionPerUser = -1;
    protected int minSessionPerUser = -1;
    protected List<PathPrivilege> pathPrivilegeList;
    protected Map<String, DatabasePrivilege> objectPrivilegeMap;
    protected Set<PrivilegeType> sysPrivilegeSet;
    protected Set<PrivilegeType> sysPriGrantOpt;
    protected Set<PrivilegeType> anyScopePrivilegeSet;
    protected Set<PrivilegeType> anyScopePrivilegeGrantOptSet;

    @TestOnly
    public Role() {
        this.pathPrivilegeList = new ArrayList<PathPrivilege>();
        this.sysPrivilegeSet = new HashSet<PrivilegeType>();
        this.sysPriGrantOpt = new HashSet<PrivilegeType>();
        this.objectPrivilegeMap = new HashMap<String, DatabasePrivilege>();
        this.anyScopePrivilegeGrantOptSet = new HashSet<PrivilegeType>();
        this.anyScopePrivilegeSet = new HashSet<PrivilegeType>();
    }

    public Role(String name) {
        this.name = name;
        this.pathPrivilegeList = new ArrayList<PathPrivilege>();
        this.sysPrivilegeSet = new HashSet<PrivilegeType>();
        this.sysPriGrantOpt = new HashSet<PrivilegeType>();
        this.objectPrivilegeMap = new HashMap<String, DatabasePrivilege>();
        this.anyScopePrivilegeGrantOptSet = new HashSet<PrivilegeType>();
        this.anyScopePrivilegeSet = new HashSet<PrivilegeType>();
    }

    public String getName() {
        return this.name;
    }

    public int getMaxSessionPerUser() {
        return this.maxSessionPerUser;
    }

    public int getMinSessionPerUser() {
        return this.minSessionPerUser;
    }

    public List<PathPrivilege> getPathPrivilegeList() {
        return this.pathPrivilegeList;
    }

    public Set<PrivilegeType> getSysPrivilege() {
        return this.sysPrivilegeSet;
    }

    private Set<Integer> getPrivilegeIntSet(Set<PrivilegeType> privs) {
        HashSet<Integer> res = new HashSet<Integer>();
        for (PrivilegeType priv : privs) {
            res.add(priv.ordinal());
        }
        return res;
    }

    public Set<PrivilegeType> getPathPrivileges(PartialPath path) {
        return AuthUtils.getPrivileges(path, this.pathPrivilegeList);
    }

    public Set<PrivilegeType> getSysPriGrantOpt() {
        return this.sysPriGrantOpt;
    }

    public Set<PrivilegeType> getAnyScopePrivilegeGrantOpt() {
        return this.anyScopePrivilegeGrantOptSet;
    }

    public Set<PrivilegeType> getAnyScopePrivilegeSet() {
        return this.anyScopePrivilegeSet;
    }

    public Map<String, DatabasePrivilege> getDBScopePrivilegeMap() {
        return this.objectPrivilegeMap;
    }

    private DatabasePrivilege getObjectPrivilege(String objectName) {
        return this.objectPrivilegeMap.computeIfAbsent(objectName, k -> new DatabasePrivilege(objectName));
    }

    public List<TPathPrivilege> getTreePrivilegeInfo() {
        ArrayList<TPathPrivilege> privilegeList = new ArrayList<TPathPrivilege>();
        for (PathPrivilege pathPrivilege : this.pathPrivilegeList) {
            TPathPrivilege pathPriv = new TPathPrivilege();
            pathPriv.setPath(pathPrivilege.getPath().getFullPath());
            pathPriv.setPriSet(pathPrivilege.getPrivilegeIntSet());
            pathPriv.setPriGrantOpt(pathPrivilege.getGrantOptIntSet());
            privilegeList.add(pathPriv);
        }
        return privilegeList;
    }

    public void loadTreePrivilegeInfo(List<TPathPrivilege> pathPrivilegeInfo) throws MetadataException {
        for (TPathPrivilege tPathPrivilege : pathPrivilegeInfo) {
            PathPrivilege pathPri = new PathPrivilege();
            pathPri.setPath(new PartialPath(tPathPrivilege.getPath()));
            pathPri.setPrivilegesInt(tPathPrivilege.getPriSet());
            pathPri.setGrantOptInt(tPathPrivilege.getPriGrantOpt());
            this.pathPrivilegeList.add(pathPri);
        }
    }

    public Set<TDBPrivilege> getDatabaseAndTablePrivilegeInfo() {
        HashSet<TDBPrivilege> privileges = new HashSet<TDBPrivilege>();
        for (DatabasePrivilege databasePrivilege : this.objectPrivilegeMap.values()) {
            TDBPrivilege tdbPrivilege = new TDBPrivilege();
            tdbPrivilege.setDatabaseName(databasePrivilege.getDatabaseName());
            tdbPrivilege.setPrivileges(databasePrivilege.getPrivilegeSet());
            tdbPrivilege.setGrantOpt(databasePrivilege.getPrivilegeGrantOptSet());
            if (!databasePrivilege.getTablePrivilegeMap().isEmpty()) {
                for (TablePrivilege tablePrivilege : databasePrivilege.getTablePrivilegeMap().values()) {
                    TTablePrivilege tTablePrivilege = new TTablePrivilege();
                    tTablePrivilege.setTableName(tablePrivilege.getTableName());
                    tTablePrivilege.setPrivileges(tablePrivilege.getPrivilegesIntSet());
                    tTablePrivilege.setGrantOption(tablePrivilege.getGrantOptionIntSet());
                    tdbPrivilege.putToTablePrivilegeMap(tablePrivilege.getTableName(), tTablePrivilege);
                }
            } else {
                tdbPrivilege.setTablePrivilegeMap(new HashMap());
            }
            privileges.add(tdbPrivilege);
        }
        return privileges;
    }

    public void loadDatabaseAndTablePrivilegeInfo(Map<String, TDBPrivilege> info) {
        for (TDBPrivilege tdbPrivilege : info.values()) {
            DatabasePrivilege databasePrivilege = new DatabasePrivilege(tdbPrivilege.getDatabaseName());
            for (Integer privId : tdbPrivilege.getPrivileges()) {
                databasePrivilege.grantDBPrivilege(PrivilegeType.values()[privId]);
            }
            for (Integer privId : tdbPrivilege.getGrantOpt()) {
                databasePrivilege.grantDBGrantOption(PrivilegeType.values()[privId]);
            }
            if (tdbPrivilege.getTablePrivilegeMapSize() != 0) {
                for (TTablePrivilege tablePrivilege : tdbPrivilege.getTablePrivilegeMap().values()) {
                    for (Integer privId : tablePrivilege.getPrivileges()) {
                        databasePrivilege.grantTablePrivilege(tablePrivilege.getTableName(), PrivilegeType.values()[privId]);
                    }
                    for (Integer privId : tablePrivilege.getGrantOption()) {
                        databasePrivilege.grantTableGrantOption(tablePrivilege.getTableName(), PrivilegeType.values()[privId]);
                    }
                }
            }
            this.objectPrivilegeMap.put(tdbPrivilege.getDatabaseName(), databasePrivilege);
        }
    }

    public TRoleResp getRoleInfo(ModelType modelType) {
        TRoleResp roleResp = new TRoleResp();
        roleResp.setName(this.name);
        switch (modelType) {
            case RELATIONAL: {
                HashSet<Integer> privs = new HashSet<Integer>();
                for (Object priv : this.sysPrivilegeSet) {
                    if (!priv.forRelationalSys()) continue;
                    privs.add(priv.ordinal());
                }
                roleResp.setSysPriSet(privs);
                HashSet<Integer> privGrantOpt = new HashSet<Integer>();
                for (Object priv : this.sysPriGrantOpt) {
                    if (!priv.forRelationalSys()) continue;
                    privGrantOpt.add(priv.ordinal());
                }
                roleResp.setSysPriSetGrantOpt(privGrantOpt);
                roleResp.setAnyScopeSet(this.getPrivilegeIntSet(this.anyScopePrivilegeSet));
                roleResp.setAnyScopeGrantSet(this.getPrivilegeIntSet(this.anyScopePrivilegeGrantOptSet));
                roleResp.setPrivilegeList(new ArrayList());
                Set<TDBPrivilege> tdbPrivileges = this.getDatabaseAndTablePrivilegeInfo();
                roleResp.setDbPrivilegeMap(new HashMap());
                for (TDBPrivilege tdbPrivilege : tdbPrivileges) {
                    roleResp.putToDbPrivilegeMap(tdbPrivilege.getDatabaseName(), tdbPrivilege);
                }
                break;
            }
            case TREE: {
                roleResp.setSysPriSet(this.getPrivilegeIntSet(this.sysPrivilegeSet));
                roleResp.setSysPriSetGrantOpt(this.getPrivilegeIntSet(this.sysPriGrantOpt));
                roleResp.setAnyScopeSet(new HashSet());
                roleResp.setAnyScopeGrantSet(new HashSet());
                roleResp.setPrivilegeList(this.getTreePrivilegeInfo());
                roleResp.setDbPrivilegeMap(new HashMap());
                break;
            }
            case ALL: {
                roleResp.setSysPriSet(this.getPrivilegeIntSet(this.sysPrivilegeSet));
                roleResp.setSysPriSetGrantOpt(this.getPrivilegeIntSet(this.sysPriGrantOpt));
                roleResp.setAnyScopeSet(this.getPrivilegeIntSet(this.anyScopePrivilegeSet));
                roleResp.setAnyScopeGrantSet(this.getPrivilegeIntSet(this.anyScopePrivilegeGrantOptSet));
                roleResp.setPrivilegeList(this.getTreePrivilegeInfo());
                Set<TDBPrivilege> tdbPrivileges1 = this.getDatabaseAndTablePrivilegeInfo();
                roleResp.setDbPrivilegeMap(new HashMap());
                for (TDBPrivilege tdbPrivilege : tdbPrivileges1) {
                    roleResp.putToDbPrivilegeMap(tdbPrivilege.getDatabaseName(), tdbPrivilege);
                }
                break;
            }
        }
        return roleResp;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMaxSessionPerUser(int maxSessionPerUser) {
        this.maxSessionPerUser = maxSessionPerUser;
    }

    public void setMinSessionPerUser(int minSessionPerUser) {
        this.minSessionPerUser = minSessionPerUser;
    }

    public void setPrivilegeList(List<PathPrivilege> privilegeList) {
        this.pathPrivilegeList = privilegeList;
    }

    public void setPathPrivileges(PartialPath path, Set<PrivilegeType> privileges) {
        for (PathPrivilege pathPrivilege : this.pathPrivilegeList) {
            if (!pathPrivilege.getPath().equals(path)) continue;
            pathPrivilege.setPrivileges(privileges);
        }
    }

    public void setObjectPrivilegeMap(Map<String, DatabasePrivilege> privilegeMap) {
        this.objectPrivilegeMap = privilegeMap;
    }

    public void grantPathPrivilege(PartialPath path, PrivilegeType priv, boolean grantOpt) {
        AuthUtils.addPrivilege(path, priv, this.pathPrivilegeList, grantOpt);
    }

    public void revokePathPrivilege(PartialPath path, PrivilegeType priv) {
        AuthUtils.removePrivilege(path, priv, this.pathPrivilegeList);
    }

    public void revokePathPrivilegeGrantOption(PartialPath path, PrivilegeType priv) {
        AuthUtils.removePrivilegeGrantOption(path, priv, this.pathPrivilegeList);
    }

    public void setSysPrivilegeSet(Set<PrivilegeType> privilegeSet) {
        this.sysPrivilegeSet = privilegeSet;
    }

    public void setSysPrivilegeSetInt(Set<Integer> privilegeSet) {
        for (Integer priv : privilegeSet) {
            this.sysPrivilegeSet.add(PrivilegeType.values()[priv]);
        }
    }

    public void setSysPrivilegesWithMask(int privMask) {
        int SYS_PRI_SIZE = PrivilegeType.getPrivilegeCount(PrivilegeModelType.SYSTEM);
        for (int i = 0; i < SYS_PRI_SIZE; ++i) {
            if ((privMask & 1 << i) == 0) continue;
            this.sysPrivilegeSet.add(AuthUtils.posToSysPri(i));
            if ((privMask & 1 << i + 16) == 0) continue;
            this.sysPriGrantOpt.add(AuthUtils.posToSysPri(i));
        }
    }

    public void setAnyScopePrivilegeSetWithMask(int privMask) {
        int PRI_COUNT = PrivilegeType.getPrivilegeCount(PrivilegeModelType.RELATIONAL);
        for (int i = 0; i < PRI_COUNT; ++i) {
            if ((privMask & 1 << i) == 0) continue;
            this.anyScopePrivilegeSet.add(AuthUtils.posToObjPri(i));
            if ((privMask & 1 << i + 16) == 0) continue;
            this.anyScopePrivilegeGrantOptSet.add(AuthUtils.posToObjPri(i));
        }
    }

    public void setAnyScopePrivilegeSet(Set<PrivilegeType> privilegeSet) {
        this.anyScopePrivilegeSet = privilegeSet;
    }

    public void setAnyScopePrivilegeSetInt(Set<Integer> privilegeSet) {
        for (Integer priv : privilegeSet) {
            this.anyScopePrivilegeSet.add(PrivilegeType.values()[priv]);
        }
    }

    public void setAnyScopePrivilegeGrantOptSet(Set<PrivilegeType> grantOpt) {
        this.anyScopePrivilegeGrantOptSet = grantOpt;
    }

    public void setAnyScopePrivilegeGrantOptSetInt(Set<Integer> privilegeSet) {
        for (Integer priv : privilegeSet) {
            this.anyScopePrivilegeGrantOptSet.add(PrivilegeType.values()[priv]);
        }
    }

    public void setSysPriGrantOpt(Set<PrivilegeType> grantOpt) {
        this.sysPriGrantOpt = grantOpt;
    }

    public void setSysPriGrantOptInt(Set<Integer> grantOptInt) {
        for (Integer priv : grantOptInt) {
            this.sysPriGrantOpt.add(PrivilegeType.values()[priv]);
        }
    }

    public void grantSysPrivilege(PrivilegeType priv, boolean grantOpt) {
        this.sysPrivilegeSet.add(priv);
        if (grantOpt) {
            this.sysPriGrantOpt.add(priv);
        }
    }

    public void grantAnyScopePrivilege(PrivilegeType priv, boolean grantOpt) {
        this.anyScopePrivilegeSet.add(priv);
        if (grantOpt) {
            this.anyScopePrivilegeGrantOptSet.add(priv);
        }
    }

    public void revokeAnyScopePrivilege(PrivilegeType priv) {
        this.anyScopePrivilegeSet.remove((Object)priv);
        this.anyScopePrivilegeGrantOptSet.remove((Object)priv);
    }

    public void revokeAnyScopePrivilegeGrantOption(PrivilegeType priv) {
        this.anyScopePrivilegeGrantOptSet.remove((Object)priv);
    }

    public void revokeAllRelationalPrivileges() {
        this.objectPrivilegeMap = new HashMap<String, DatabasePrivilege>();
        this.sysPrivilegeSet.removeIf(PrivilegeType::forRelationalSys);
        this.sysPriGrantOpt.removeIf(PrivilegeType::forRelationalSys);
        this.anyScopePrivilegeSet = new HashSet<PrivilegeType>();
        this.anyScopePrivilegeGrantOptSet = new HashSet<PrivilegeType>();
    }

    public void grantDBPrivilege(String dbName, PrivilegeType priv, boolean grantOption) {
        DatabasePrivilege databasePrivilege = this.getObjectPrivilege(dbName);
        databasePrivilege.grantDBPrivilege(priv);
        if (grantOption) {
            databasePrivilege.grantDBGrantOption(priv);
        }
    }

    public void grantTBPrivilege(String dbName, String tbName, PrivilegeType priv, boolean grantOption) {
        DatabasePrivilege databasePrivilege = this.getObjectPrivilege(dbName);
        databasePrivilege.grantTablePrivilege(tbName, priv);
        if (grantOption) {
            databasePrivilege.grantTableGrantOption(tbName, priv);
        }
    }

    public void revokeDBPrivilege(String dbName, PrivilegeType priv) {
        if (!this.objectPrivilegeMap.containsKey(dbName)) {
            return;
        }
        DatabasePrivilege databasePrivilege = this.objectPrivilegeMap.get(dbName);
        databasePrivilege.revokeDBPrivilege(priv);
        if (databasePrivilege.getTablePrivilegeMap().isEmpty() && databasePrivilege.getPrivilegeSet().isEmpty()) {
            this.objectPrivilegeMap.remove(dbName);
        }
    }

    public void revokeDBPrivilegeGrantOption(String dbName, PrivilegeType priv) {
        if (!this.objectPrivilegeMap.containsKey(dbName)) {
            return;
        }
        DatabasePrivilege databasePrivilege = this.objectPrivilegeMap.get(dbName);
        databasePrivilege.revokeDBGrantOption(priv);
    }

    public void revokeTBPrivilege(String dbName, String tbName, PrivilegeType priv) {
        if (!this.objectPrivilegeMap.containsKey(dbName)) {
            return;
        }
        DatabasePrivilege databasePrivilege = this.objectPrivilegeMap.get(dbName);
        databasePrivilege.revokeTablePrivilege(tbName, priv);
        if (databasePrivilege.getTablePrivilegeMap().isEmpty() && databasePrivilege.getPrivilegeSet().isEmpty()) {
            this.objectPrivilegeMap.remove(dbName);
        }
    }

    public void revokeTBPrivilegeGrantOption(String dbName, String tbName, PrivilegeType priv) {
        if (!this.objectPrivilegeMap.containsKey(dbName)) {
            return;
        }
        DatabasePrivilege databasePrivilege = this.objectPrivilegeMap.get(dbName);
        if (!databasePrivilege.getTablePrivilegeMap().containsKey(tbName)) {
            return;
        }
        TablePrivilege tablePrivilege = databasePrivilege.getTablePrivilegeMap().get(tbName);
        tablePrivilege.revokeGrantOption(priv);
    }

    public void grantSysPrivilegeGrantOption(PrivilegeType priv) {
        this.sysPriGrantOpt.add(priv);
    }

    public void revokeSysPrivilege(PrivilegeType priv) {
        this.sysPrivilegeSet.remove((Object)priv);
    }

    public void revokeSysPrivilegeGrantOption(PrivilegeType priv) {
        this.sysPriGrantOpt.remove((Object)priv);
    }

    public boolean hasPrivilegeToRevoke(PartialPath path, PrivilegeType priv) {
        return AuthUtils.hasPrivilegeToRevoke(path, priv, this.pathPrivilegeList);
    }

    public boolean hasPrivilegeToRevoke(PrivilegeType priv) {
        return this.sysPrivilegeSet.contains((Object)priv);
    }

    public boolean hasPrivilegeToRevoke(String dbname, PrivilegeType priv) {
        return this.objectPrivilegeMap.containsKey(dbname) && this.objectPrivilegeMap.get(dbname).checkDBPrivilege(priv);
    }

    public boolean hasPrivilegeToRevoke(String dbname, String tbName, PrivilegeType priv) {
        return this.objectPrivilegeMap.containsKey(dbname) && this.objectPrivilegeMap.get(dbname).checkTablePrivilege(tbName, priv);
    }

    public boolean checkAnyScopePrivilege(PrivilegeType priv) {
        return this.anyScopePrivilegeSet.contains((Object)priv);
    }

    public boolean checkDatabasePrivilege(String dbname, PrivilegeType priv) {
        return this.checkAnyScopePrivilege(priv) || this.objectPrivilegeMap.containsKey(dbname) && this.objectPrivilegeMap.get(dbname).checkDBPrivilege(priv);
    }

    public boolean checkTablePrivilege(String dbname, String table, PrivilegeType priv) {
        return this.checkAnyScopePrivilege(priv) || this.objectPrivilegeMap.containsKey(dbname) && (this.objectPrivilegeMap.get(dbname).checkDBPrivilege(priv) || this.objectPrivilegeMap.get(dbname).checkTablePrivilege(table, priv));
    }

    public boolean checkDatabasePrivilegeGrantOption(String dbname, PrivilegeType priv) {
        if (this.checkAnyScopePrivilegeGrantOption(priv)) {
            return true;
        }
        return this.objectPrivilegeMap.containsKey(dbname) && this.objectPrivilegeMap.get(dbname).checkDBGrantOption(priv);
    }

    public boolean checkTablePrivilegeGrantOption(String dbname, String table, PrivilegeType priv) {
        if (this.checkAnyScopePrivilegeGrantOption(priv)) {
            return true;
        }
        if (this.checkDatabasePrivilegeGrantOption(dbname, priv)) {
            return true;
        }
        return this.objectPrivilegeMap.containsKey(dbname) && this.objectPrivilegeMap.get(dbname).checkTableGrantOption(table, priv);
    }

    public boolean checkAnyScopePrivilegeGrantOption(PrivilegeType priv) {
        return this.anyScopePrivilegeGrantOptSet.contains((Object)priv) && this.anyScopePrivilegeSet.contains((Object)priv);
    }

    public boolean checkPathPrivilege(PartialPath path, PrivilegeType priv) {
        return AuthUtils.checkPathPrivilege(path, priv, this.pathPrivilegeList);
    }

    public boolean checkPathPrivilegeGrantOpt(PartialPath path, PrivilegeType priv) {
        return AuthUtils.checkPathPrivilegeGrantOpt(path, priv, this.pathPrivilegeList);
    }

    public boolean checkSysPrivilege(PrivilegeType priv) {
        return this.sysPrivilegeSet.contains((Object)priv);
    }

    public boolean checkSysPriGrantOpt(PrivilegeType priv) {
        return this.sysPrivilegeSet.contains((Object)priv) && this.sysPriGrantOpt.contains((Object)priv);
    }

    public boolean checkAnyVisible() {
        return !this.anyScopePrivilegeSet.isEmpty();
    }

    public boolean checkDBVisible(String database) {
        return !this.anyScopePrivilegeSet.isEmpty() || this.objectPrivilegeMap.containsKey(database);
    }

    public boolean checkTBVisible(String database, String tbName) {
        if (!this.anyScopePrivilegeSet.isEmpty()) {
            return true;
        }
        if (!this.objectPrivilegeMap.containsKey(database)) {
            return false;
        }
        if (!this.objectPrivilegeMap.get(database).getPrivilegeSet().isEmpty()) {
            return true;
        }
        return this.objectPrivilegeMap.get(database).getTablePrivilegeMap().containsKey(tbName);
    }

    public int getAllSysPrivileges() {
        int privs = 0;
        for (PrivilegeType sysPri : this.sysPrivilegeSet) {
            privs |= 1 << AuthUtils.sysPriToPos(sysPri);
        }
        for (PrivilegeType sysGrantOpt : this.sysPriGrantOpt) {
            privs |= 1 << AuthUtils.sysPriToPos(sysGrantOpt) + 16;
        }
        return privs;
    }

    public int getAnyScopePrivileges() {
        int privs = 0;
        for (PrivilegeType anyScope : this.anyScopePrivilegeSet) {
            privs |= 1 << AuthUtils.objPriToPos(anyScope);
        }
        for (PrivilegeType anyScopeGrantOpt : this.anyScopePrivilegeGrantOptSet) {
            privs |= 1 << AuthUtils.objPriToPos(anyScopeGrantOpt) + 16;
        }
        return privs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        return Objects.equals(this.name, role.name) && Objects.equals(this.pathPrivilegeList, role.pathPrivilegeList) && Objects.equals(this.sysPrivilegeSet, role.sysPrivilegeSet) && Objects.equals(this.sysPriGrantOpt, role.sysPriGrantOpt) && Objects.equals(this.objectPrivilegeMap, role.objectPrivilegeMap) && Objects.equals(this.anyScopePrivilegeSet, role.anyScopePrivilegeSet) && Objects.equals(this.anyScopePrivilegeGrantOptSet, role.anyScopePrivilegeGrantOptSet);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.pathPrivilegeList, this.sysPrivilegeSet, this.sysPriGrantOpt, this.anyScopePrivilegeSet, this.anyScopePrivilegeGrantOptSet, this.objectPrivilegeMap);
    }

    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        SerializeUtils.serialize(this.name, dataOutputStream);
        try {
            SerializeUtils.serializePrivilegeTypeSet(this.sysPrivilegeSet, dataOutputStream);
            SerializeUtils.serializePrivilegeTypeSet(this.sysPriGrantOpt, dataOutputStream);
            dataOutputStream.writeInt(this.pathPrivilegeList.size());
            for (PathPrivilege pathPrivilege : this.pathPrivilegeList) {
                dataOutputStream.write(pathPrivilege.serialize().array());
            }
            SerializeUtils.serializePrivilegeTypeSet(this.anyScopePrivilegeSet, dataOutputStream);
            SerializeUtils.serializePrivilegeTypeSet(this.anyScopePrivilegeGrantOptSet, dataOutputStream);
            dataOutputStream.writeInt(this.objectPrivilegeMap.size());
            for (Map.Entry entry : this.objectPrivilegeMap.entrySet()) {
                SerializeUtils.serialize((String)entry.getKey(), dataOutputStream);
                dataOutputStream.write(((DatabasePrivilege)entry.getValue()).serialize().array());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public void deserialize(ByteBuffer buffer) {
        this.name = SerializeUtils.deserializeString(buffer);
        int sysPrivilegeSize = buffer.getInt();
        this.sysPrivilegeSet = new HashSet<PrivilegeType>();
        for (int i = 0; i < sysPrivilegeSize; ++i) {
            this.sysPrivilegeSet.add(PrivilegeType.values()[buffer.getInt()]);
        }
        int sysPriGrantOptSize = buffer.getInt();
        this.sysPriGrantOpt = new HashSet<PrivilegeType>();
        for (int i = 0; i < sysPriGrantOptSize; ++i) {
            this.sysPriGrantOpt.add(PrivilegeType.values()[buffer.getInt()]);
        }
        int privilegeListSize = buffer.getInt();
        this.pathPrivilegeList = new ArrayList<PathPrivilege>(privilegeListSize);
        for (int i = 0; i < privilegeListSize; ++i) {
            PathPrivilege pathPrivilege = new PathPrivilege();
            pathPrivilege.deserialize(buffer);
            this.pathPrivilegeList.add(pathPrivilege);
        }
        SerializeUtils.deserializePrivilegeTypeSet(this.anyScopePrivilegeSet, buffer);
        SerializeUtils.deserializePrivilegeTypeSet(this.anyScopePrivilegeGrantOptSet, buffer);
        int objectPrivilegesSize = buffer.getInt();
        for (int i = 0; i < objectPrivilegesSize; ++i) {
            DatabasePrivilege databasePrivilege = new DatabasePrivilege();
            String objectName = SerializeUtils.deserializeString(buffer);
            databasePrivilege.deserialize(buffer);
            this.objectPrivilegeMap.put(objectName, databasePrivilege);
        }
    }

    public String toString() {
        return "Role{name='" + this.name + '\'' + ", pathPrivilegeList=" + this.pathPrivilegeList + ", systemPrivilegeSet=" + this.priSetToString(this.sysPrivilegeSet, this.sysPriGrantOpt) + ", AnyScopePrivilegeMap=" + this.priSetToString(this.anyScopePrivilegeSet, this.anyScopePrivilegeGrantOptSet) + ", objectPrivilegeSet=" + this.objectPrivilegeMap + '}';
    }

    public Set<String> priSetToString(Set<PrivilegeType> privs, Set<PrivilegeType> grantOpt) {
        HashSet<String> priSet = new HashSet<String>();
        ArrayList<PrivilegeType> privBak = new ArrayList<PrivilegeType>(privs);
        Collections.sort(privBak);
        for (PrivilegeType priv : privBak) {
            StringBuilder str = new StringBuilder(String.valueOf((Object)priv));
            if (grantOpt.contains((Object)priv)) {
                str.append("_with_grant_option");
            }
            priSet.add(str.toString());
        }
        return priSet;
    }
}

