/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.util.FunctionalUtils;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class SMTPIsAuthNetwork
extends GenericMatcher {
    private static final AttributeName SMTP_AUTH_NETWORK_NAME = AttributeName.of((String)"org.apache.james.SMTPIsAuthNetwork");

    public Collection<MailAddress> match(Mail mail) {
        return AttributeUtils.getValueAndCastFromMail((Mail)mail, (AttributeName)SMTP_AUTH_NETWORK_NAME, Boolean.class).filter(FunctionalUtils.identityPredicate()).map(any -> mail.getRecipients()).orElse((Collection)ImmutableList.of());
    }

    public static Attribute makeAttribute(Boolean value) {
        return new Attribute(SMTP_AUTH_NETWORK_NAME, AttributeValue.of((Boolean)value));
    }
}

