/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenizerBase;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class PatternTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant {
    private final String flags;
    private final int group;
    private final String pattern;
    public static final JsonpDeserializer<PatternTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PatternTokenizer::setupPatternTokenizerDeserializer);

    private PatternTokenizer(Builder builder) {
        super(builder);
        this.flags = ApiTypeHelper.requireNonNull(builder.flags, this, "flags");
        this.group = ApiTypeHelper.requireNonNull(builder.group, this, "group");
        this.pattern = ApiTypeHelper.requireNonNull(builder.pattern, this, "pattern");
    }

    public static PatternTokenizer of(Function<Builder, ObjectBuilder<PatternTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.Pattern;
    }

    public final String flags() {
        return this.flags;
    }

    public final int group() {
        return this.group;
    }

    public final String pattern() {
        return this.pattern;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "pattern");
        super.serializeInternal(generator, mapper);
        generator.writeKey("flags");
        generator.write(this.flags);
        generator.writeKey("group");
        generator.write(this.group);
        generator.writeKey("pattern");
        generator.write(this.pattern);
    }

    protected static void setupPatternTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        PatternTokenizer.setupTokenizerBaseDeserializer(op);
        op.add(Builder::flags, JsonpDeserializer.stringDeserializer(), "flags");
        op.add(Builder::group, JsonpDeserializer.integerDeserializer(), "group");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PatternTokenizer> {
        private String flags;
        private Integer group;
        private String pattern;

        public final Builder flags(String value) {
            this.flags = value;
            return this;
        }

        public final Builder group(int value) {
            this.group = value;
            return this;
        }

        public final Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PatternTokenizer build() {
            this._checkSingleUse();
            return new PatternTokenizer(this);
        }
    }
}

