/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.deserialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.jmap.draft.model.JmapRuleDTO;

public class JmapRuleDTODeserializer
extends JsonDeserializer<JmapRuleDTO> {
    public JmapRuleDTO deserialize(JsonParser jp, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jp.readValueAsTree();
        JsonNode idNode = node.get("id");
        Preconditions.checkArgument((!idNode.isNull() ? 1 : 0) != 0, (Object)"`id` is mandatory");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)idNode.asText()), (Object)"`id` is mandatory");
        JsonNode nameNode = node.get("name");
        Preconditions.checkArgument((!nameNode.isNull() ? 1 : 0) != 0, (Object)"`name` is mandatory");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)nameNode.asText()), (Object)"`name` is mandatory");
        JsonNode conditionNode = node.get("condition");
        Preconditions.checkArgument((!conditionNode.isNull() ? 1 : 0) != 0, (Object)"`condition` is mandatory");
        JmapRuleDTO.ConditionDTO conditionDTO = (JmapRuleDTO.ConditionDTO)jp.getCodec().treeToValue((TreeNode)conditionNode, JmapRuleDTO.ConditionDTO.class);
        JsonNode actionNode = node.get("action");
        Preconditions.checkArgument((!actionNode.isNull() ? 1 : 0) != 0, (Object)"`action` is mandatory");
        JmapRuleDTO.ActionDTO actionDTO = (JmapRuleDTO.ActionDTO)jp.getCodec().treeToValue((TreeNode)actionNode, JmapRuleDTO.ActionDTO.class);
        return new JmapRuleDTO(node.get("id").asText(), node.get("name").asText(), conditionDTO, actionDTO);
    }
}

