/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import org.apache.james.task.Task;
import org.apache.james.util.streams.Iterators;
import org.apache.james.util.streams.Limit;
import org.apache.james.util.streams.Offset;
import org.apache.james.webadmin.dto.InaccessibleFieldException;
import org.apache.james.webadmin.dto.MailDto;
import org.apache.james.webadmin.dto.MailKeyDTO;
import org.apache.james.webadmin.dto.SingleMailRepositoryResponse;
import org.apache.james.webadmin.service.ClearMailRepositoryTask;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.mailet.Mail;
import reactor.core.publisher.Flux;

public class MailRepositoryStoreService {
    private final MailRepositoryStore mailRepositoryStore;

    @Inject
    public MailRepositoryStoreService(MailRepositoryStore mailRepositoryStore) {
        this.mailRepositoryStore = mailRepositoryStore;
    }

    public Stream<SingleMailRepositoryResponse> listMailRepositories() {
        return this.mailRepositoryStore.getPaths().map(SingleMailRepositoryResponse::new);
    }

    public MailRepository createMailRepository(MailRepositoryPath repositoryPath, String protocol) throws MailRepositoryStore.MailRepositoryStoreException {
        return this.mailRepositoryStore.create(MailRepositoryUrl.fromPathAndProtocol((MailRepositoryPath)repositoryPath, (String)protocol));
    }

    public Optional<List<MailKeyDTO>> listMails(MailRepositoryPath path, Offset offset, Limit limit) throws MailRepositoryStore.MailRepositoryStoreException, MessagingException {
        Optional<Stream<MailKeyDTO>> maybeMails = Optional.of(this.getRepositories(path).flatMap(Throwing.function(repository -> Iterators.toStream((Iterator)repository.list())).sneakyThrow()).map(MailKeyDTO::new).skip(offset.getOffset()));
        return maybeMails.map(arg_0 -> ((Limit)limit).applyOnStream(arg_0)).map(stream -> (List)stream.collect(ImmutableList.toImmutableList()));
    }

    public Optional<Long> size(MailRepositoryPath path) throws MailRepositoryStore.MailRepositoryStoreException {
        return Flux.fromStream(this.getRepositories(path)).flatMap(MailRepository::sizeReactive, 16).reduce((Object)0L, Long::sum).blockOptional();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<MailDto> retrieveMail(MailRepositoryPath path, MailKey mailKey, Set<MailDto.AdditionalField> additionalAttributes) throws MailRepositoryStore.MailRepositoryStoreException, MessagingException, InaccessibleFieldException {
        Optional<Mail> mail = this.fetchMail(path, mailKey);
        try {
            Optional<MailDto> optional = mail.map(Throwing.function(aMail -> MailDto.fromMail(aMail, additionalAttributes)).sneakyThrow());
            return optional;
        }
        finally {
            LifecycleUtil.dispose(mail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<MimeMessage> retrieveMessage(MailRepositoryPath path, MailKey mailKey) throws MailRepositoryStore.MailRepositoryStoreException, MessagingException {
        Optional<Mail> mail = this.fetchMail(path, mailKey);
        try {
            Optional<MimeMessage> optional = mail.map(Throwing.function(Mail::getMessage).sneakyThrow());
            return optional;
        }
        finally {
            LifecycleUtil.dispose(mail);
        }
    }

    public void deleteMail(MailRepositoryPath path, MailKey mailKey) throws MailRepositoryStore.MailRepositoryStoreException, MessagingException {
        this.getRepositories(path).forEach(Throwing.consumer(repository -> repository.remove(mailKey)).sneakyThrow());
    }

    public Task createClearMailRepositoryTask(MailRepositoryPath path) throws MailRepositoryStore.MailRepositoryStoreException, MessagingException {
        this.getRepositories(path);
        return new ClearMailRepositoryTask(this.mailRepositoryStore, path);
    }

    public Stream<MailRepository> getRepositories(MailRepositoryPath path) throws MailRepositoryStore.MailRepositoryStoreException {
        Stream byPath = this.mailRepositoryStore.getByPath(path);
        List repositories = byPath.collect(Collectors.toList());
        if (repositories.isEmpty()) {
            ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).message("%s does not exist", new Object[]{path.asString()}).haltError();
        }
        return repositories.stream();
    }

    private Optional<Mail> fetchMail(MailRepositoryPath path, MailKey mailKey) throws MailRepositoryStore.MailRepositoryStoreException, MessagingException {
        return this.getRepositories(path).map(Throwing.function(repository -> Optional.ofNullable(repository.retrieve(mailKey))).sneakyThrow()).flatMap(Optional::stream).findFirst();
    }
}

