/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.utils;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import reactor.core.publisher.Mono;

public class CassandraHealthCheck
implements HealthCheck {
    private static final ComponentName COMPONENT_NAME = new ComponentName("Cassandra backend");
    private static final String SAMPLE_QUERY = "SELECT NOW() FROM system.local";
    private final CassandraAsyncExecutor queryExecutor;

    @Inject
    public CassandraHealthCheck(CqlSession session) {
        this.queryExecutor = new CassandraAsyncExecutor(session);
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return Mono.from(this.queryExecutor.executeSingleRow((Statement)SimpleStatement.newInstance((String)SAMPLE_QUERY))).map(row -> Result.healthy((ComponentName)COMPONENT_NAME)).onErrorResume(e -> Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Error checking Cassandra backend", (Throwable)e)));
    }
}

