/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.james.transport.mailets.ReplaceConfig;
import org.apache.james.transport.mailets.ReplacingPattern;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentReplacer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentReplacer.class);
    private final boolean debug;

    public ContentReplacer(boolean debug) {
        this.debug = debug;
    }

    public String applyPatterns(List<ReplacingPattern> patterns, String text) {
        String textCopy = new String(text);
        for (ReplacingPattern replacingPattern : patterns) {
            textCopy = this.applyPattern(replacingPattern, textCopy);
        }
        return textCopy;
    }

    private String applyPattern(ReplacingPattern replacingPattern, String text) {
        boolean changed;
        int index = 0;
        do {
            changed = false;
            Matcher matcher = replacingPattern.getMatcher().matcher(text);
            if (!matcher.find(index)) continue;
            text = this.replaceFirst(replacingPattern, matcher);
            changed = true;
            ++index;
        } while (this.shouldRepeat(replacingPattern, changed));
        return text;
    }

    private String replaceFirst(ReplacingPattern replacingPattern, Matcher matcher) {
        if (this.debug) {
            LOGGER.debug("Subject rule match: {}", (Object)replacingPattern.getMatcher());
        }
        return matcher.replaceFirst(replacingPattern.getSubstitution());
    }

    private boolean shouldRepeat(ReplacingPattern replacingPattern, boolean changed) {
        return replacingPattern.isRepeat() && changed;
    }

    public void replaceMailContentAndSubject(Mail mail, ReplaceConfig replaceConfig, Optional<Charset> charset) throws MailetException {
        try {
            boolean subjectChanged = this.applySubjectReplacingUnits(mail, replaceConfig, charset);
            boolean contentChanged = this.applyBodyReplacingUnits(mail, replaceConfig, charset);
            if (subjectChanged || contentChanged) {
                mail.getMessage().saveChanges();
            }
        }
        catch (IOException | MessagingException e) {
            throw new MailetException("Error in replace", (Exception)e);
        }
    }

    private boolean applySubjectReplacingUnits(Mail mail, ReplaceConfig replaceConfig, Optional<Charset> maybeCharset) throws MessagingException {
        if (!replaceConfig.getSubjectReplacingUnits().isEmpty()) {
            String subject = this.applyPatterns(replaceConfig.getSubjectReplacingUnits(), Strings.nullToEmpty((String)mail.getMessage().getSubject()));
            String charset = maybeCharset.map(Charset::name).orElseGet(Throwing.supplier(() -> this.previousCharset(mail)).sneakyThrow());
            mail.getMessage().setSubject(subject, charset);
            return true;
        }
        return false;
    }

    private String previousCharset(Mail mail) throws MessagingException {
        ContentType contentType = new ContentType(mail.getMessage().getContentType());
        return contentType.getParameter("Charset");
    }

    private boolean applyBodyReplacingUnits(Mail mail, ReplaceConfig replaceConfig, Optional<Charset> charset) throws IOException, MessagingException, ParseException {
        Object bodyObj;
        if (!replaceConfig.getBodyReplacingUnits().isEmpty() && (bodyObj = mail.getMessage().getContent()) instanceof String) {
            String body = this.applyPatterns(replaceConfig.getBodyReplacingUnits(), Strings.nullToEmpty((String)((String)bodyObj)));
            this.setContent(mail, body, charset);
            return true;
        }
        return false;
    }

    private void setContent(Mail mail, String body, Optional<Charset> charset) throws MessagingException, ParseException {
        mail.getMessage().setContent((Object)body, this.getContentType(mail, charset));
    }

    private String getContentType(Mail mail, Optional<Charset> charset) throws MessagingException, ParseException {
        String contentTypeAsString = mail.getMessage().getContentType();
        if (charset.isPresent()) {
            ContentType contentType = new ContentType(contentTypeAsString);
            contentType.setParameter("charset", charset.get().name());
            return contentType.toString();
        }
        return contentTypeAsString;
    }
}

