/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.InlineScript;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.core.ScriptsPainlessExecuteResponse;
import org.opensearch.client.opensearch.core.scripts_painless_execute.PainlessContextSetup;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ScriptsPainlessExecuteRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String context;
    @Nullable
    private final PainlessContextSetup contextSetup;
    @Nullable
    private final InlineScript script;
    public static final JsonpDeserializer<ScriptsPainlessExecuteRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptsPainlessExecuteRequest::setupScriptsPainlessExecuteRequestDeserializer);
    public static final SimpleEndpoint<ScriptsPainlessExecuteRequest, ?> _ENDPOINT = new SimpleEndpoint<ScriptsPainlessExecuteRequest, ScriptsPainlessExecuteResponse<Object>>(request -> "POST", request -> "/_scripts/painless/_execute", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ScriptsPainlessExecuteResponse._DESERIALIZER);

    private ScriptsPainlessExecuteRequest(Builder builder) {
        this.context = builder.context;
        this.contextSetup = builder.contextSetup;
        this.script = builder.script;
    }

    public static ScriptsPainlessExecuteRequest of(Function<Builder, ObjectBuilder<ScriptsPainlessExecuteRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String context() {
        return this.context;
    }

    @Nullable
    public final PainlessContextSetup contextSetup() {
        return this.contextSetup;
    }

    @Nullable
    public final InlineScript script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.context != null) {
            generator.writeKey("context");
            generator.write(this.context);
        }
        if (this.contextSetup != null) {
            generator.writeKey("context_setup");
            this.contextSetup.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    protected static void setupScriptsPainlessExecuteRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::context, JsonpDeserializer.stringDeserializer(), "context");
        op.add(Builder::contextSetup, PainlessContextSetup._DESERIALIZER, "context_setup");
        op.add(Builder::script, InlineScript._DESERIALIZER, "script");
    }

    public static <TResult> Endpoint<ScriptsPainlessExecuteRequest, ScriptsPainlessExecuteResponse<TResult>, ErrorResponse> createScriptsPainlessExecuteEndpoint(JsonpDeserializer<TResult> tResultDeserializer) {
        return _ENDPOINT.withResponseDeserializer(ScriptsPainlessExecuteResponse.createScriptsPainlessExecuteResponseDeserializer(tResultDeserializer));
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ScriptsPainlessExecuteRequest> {
        @Nullable
        private String context;
        @Nullable
        private PainlessContextSetup contextSetup;
        @Nullable
        private InlineScript script;

        public final Builder context(@Nullable String value) {
            this.context = value;
            return this;
        }

        public final Builder contextSetup(@Nullable PainlessContextSetup value) {
            this.contextSetup = value;
            return this;
        }

        public final Builder contextSetup(Function<PainlessContextSetup.Builder, ObjectBuilder<PainlessContextSetup>> fn) {
            return this.contextSetup(fn.apply(new PainlessContextSetup.Builder()).build());
        }

        public final Builder script(@Nullable InlineScript value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<InlineScript.Builder, ObjectBuilder<InlineScript>> fn) {
            return this.script(fn.apply(new InlineScript.Builder()).build());
        }

        @Override
        public ScriptsPainlessExecuteRequest build() {
            this._checkSingleUse();
            return new ScriptsPainlessExecuteRequest(this);
        }
    }
}

