/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum TelephoneNumberValidationPolicy {
    ALLOW_NON_EMPTY_PRINTABLE_STRING,
    ALLOW_NON_EMPTY_PRINTABLE_STRING_WITH_AT_LEAST_ONE_DIGIT,
    ENFORCE_STRICT_X520_COMPLIANCE;


    public void validateValue(@NotNull ASN1OctetString value, boolean isSubstring) throws LDAPException {
        switch (this) {
            case ALLOW_NON_EMPTY_PRINTABLE_STRING: {
                TelephoneNumberValidationPolicy.validateNonEmptyPrintableString(value, isSubstring, false);
                break;
            }
            case ALLOW_NON_EMPTY_PRINTABLE_STRING_WITH_AT_LEAST_ONE_DIGIT: {
                TelephoneNumberValidationPolicy.validateNonEmptyPrintableString(value, isSubstring, true);
                break;
            }
            default: {
                TelephoneNumberValidationPolicy.validateX520Compliant(value, isSubstring);
            }
        }
    }

    private static void validateNonEmptyPrintableString(@NotNull ASN1OctetString value, boolean isSubstring, boolean requireAtLeastOneDigit) throws LDAPException {
        byte[] valueBytes = value.getValue();
        if (valueBytes.length == 0) {
            if (isSubstring) {
                throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_EMPTY_SUBSTRING.get());
            }
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_EMPTY_VALUE.get());
        }
        boolean digitFound = false;
        block3: for (int i = 0; i < valueBytes.length; ++i) {
            byte b = valueBytes[i];
            if (b >= 48 && b <= 57) {
                digitFound = true;
                continue;
            }
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90) continue;
            switch (b) {
                case 32: 
                case 39: 
                case 40: 
                case 41: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 61: 
                case 63: {
                    continue block3;
                }
                default: {
                    if (isSubstring) {
                        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_NON_PRINTABLE_SUB_CHAR.get(value.stringValue(), i));
                    }
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_NON_PRINTABLE_CHAR.get(value.stringValue(), i));
                }
            }
        }
        if (requireAtLeastOneDigit && !isSubstring && !digitFound) {
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_NO_DIGITS.get(value.stringValue()));
        }
    }

    private static void validateX520Compliant(@NotNull ASN1OctetString value, boolean isSubstring) throws LDAPException {
        byte[] valueBytes = value.getValue();
        if (valueBytes.length == 0) {
            if (isSubstring) {
                throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_EMPTY_SUBSTRING.get());
            }
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_EMPTY_VALUE.get());
        }
        if (!isSubstring && valueBytes[0] != 43) {
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_MISSING_PLUS.get(value.stringValue()));
        }
        boolean digitFound = false;
        for (int i = 0; i < valueBytes.length; ++i) {
            byte b = valueBytes[i];
            if (b == 43) {
                if (i == 0) continue;
                if (isSubstring) {
                    throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_NON_FIRST_PLUS_SUB.get(value.stringValue(), i));
                }
                throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_NON_FIRST_PLUS.get(value.stringValue(), i));
            }
            if (b >= 48 && b <= 57) {
                digitFound = true;
                continue;
            }
            if (b == 32 || b == 45) continue;
            if (isSubstring) {
                throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_INVALID_CHAR_SUB.get(value.stringValue(), i));
            }
            throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_INVALID_CHAR.get(value.stringValue(), i));
        }
        if (!digitFound) {
            if (isSubstring) {
                throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_NO_DIGITS_SUB.get(value.stringValue()));
            }
            throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_TELEPHONE_NUMBER_VALIDATION_NO_DIGITS.get(value.stringValue()));
        }
    }
}

