/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPAttribute;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPAttributeSet;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public class LDAPEntry
implements Serializable {
    private static final long serialVersionUID = -6285850560316222689L;
    @NotNull
    private final String dn;
    @NotNull
    private final LDAPAttributeSet attributeSet;

    public LDAPEntry() {
        this("", new LDAPAttributeSet());
    }

    public LDAPEntry(@NotNull String distinguishedName) {
        this(distinguishedName, new LDAPAttributeSet());
    }

    public LDAPEntry(@NotNull String distinguishedName, @Nullable LDAPAttributeSet attrs) {
        this.dn = distinguishedName;
        this.attributeSet = attrs == null ? new LDAPAttributeSet() : attrs;
    }

    public LDAPEntry(@NotNull Entry entry) {
        this.dn = entry.getDN();
        this.attributeSet = new LDAPAttributeSet();
        for (Attribute a : entry.getAttributes()) {
            this.attributeSet.add(new LDAPAttribute(a));
        }
    }

    @NotNull
    public String getDN() {
        return this.dn;
    }

    @NotNull
    public LDAPAttributeSet getAttributeSet() {
        return this.attributeSet;
    }

    @NotNull
    public LDAPAttributeSet getAttributeSet(@NotNull String subtype) {
        return this.attributeSet.getSubset(subtype);
    }

    @Nullable
    public LDAPAttribute getAttribute(@NotNull String attrName) {
        return this.attributeSet.getAttribute(attrName);
    }

    @Nullable
    public LDAPAttribute getAttribute(@NotNull String attrName, @Nullable String lang) {
        return this.attributeSet.getAttribute(attrName, lang);
    }

    @NotNull
    public final Entry toEntry() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(this.attributeSet.size());
        Enumeration<LDAPAttribute> attrEnum = this.attributeSet.getAttributes();
        while (attrEnum.hasMoreElements()) {
            attrs.add(attrEnum.nextElement().toAttribute());
        }
        return new Entry(this.dn, attrs);
    }

    @NotNull
    public String toString() {
        return this.toEntry().toString();
    }
}

