/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mailet.filter;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.stream.Stream;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.mailet.filter.MailMatcher;
import org.apache.mailet.Mail;

class RuleMatcher {
    private final List<Rule> filteringRules;

    RuleMatcher(List<Rule> filteringRules) {
        Preconditions.checkNotNull(filteringRules);
        this.filteringRules = filteringRules;
    }

    Stream<Rule> findApplicableRules(Mail mail) {
        return this.filteringRules.stream().filter(rule -> MailMatcher.from(rule).match(mail));
    }
}

