/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.migrate.ldapjdk.IterableEnumeration;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPAttribute;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;

@NotExtensible
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public class LDAPAttributeSet
implements Serializable {
    private static final long serialVersionUID = -4872457565092606186L;
    @NotNull
    private final ArrayList<LDAPAttribute> attributes;

    public LDAPAttributeSet() {
        this.attributes = new ArrayList(20);
    }

    public LDAPAttributeSet(@NotNull LDAPAttribute[] attrs) {
        this.attributes = new ArrayList<LDAPAttribute>(Arrays.asList(attrs));
    }

    private LDAPAttributeSet(@NotNull ArrayList<LDAPAttribute> attrs) {
        this.attributes = new ArrayList<LDAPAttribute>(attrs);
    }

    @NotNull
    public Enumeration<LDAPAttribute> getAttributes() {
        return new IterableEnumeration<LDAPAttribute>(this.attributes);
    }

    @NotNull
    public LDAPAttributeSet getSubset(@NotNull String subtype) {
        ArrayList<LDAPAttribute> subset = new ArrayList<LDAPAttribute>(this.attributes.size());
        for (LDAPAttribute a : this.attributes) {
            if (!a.hasSubtype(subtype)) continue;
            subset.add(a);
        }
        return new LDAPAttributeSet(subset);
    }

    @Nullable
    public LDAPAttribute getAttribute(@NotNull String attrName) {
        for (LDAPAttribute a : this.attributes) {
            if (!a.getName().equalsIgnoreCase(attrName)) continue;
            return a;
        }
        return null;
    }

    @Nullable
    public LDAPAttribute getAttribute(@NotNull String attrName, @Nullable String lang) {
        if (lang == null) {
            return this.getAttribute(attrName);
        }
        String lowerLang = StaticUtils.toLowerCase(lang);
        for (LDAPAttribute a : this.attributes) {
            String[] subtypes;
            if (!a.getBaseName().equalsIgnoreCase(attrName) || (subtypes = a.getSubtypes()) == null) continue;
            for (String s : subtypes) {
                String lowerOption = StaticUtils.toLowerCase(s);
                if (!lowerOption.equals(lowerLang) && !lowerOption.startsWith(lang + '-')) continue;
                return a;
            }
        }
        return null;
    }

    @NotNull
    public LDAPAttribute elementAt(int index) throws IndexOutOfBoundsException {
        return this.attributes.get(index);
    }

    public void add(@NotNull LDAPAttribute attr) {
        for (LDAPAttribute a : this.attributes) {
            if (!attr.getName().equalsIgnoreCase(a.getName())) continue;
            for (byte[] value : attr.getByteValueArray()) {
                a.addValue(value);
            }
            return;
        }
        this.attributes.add(attr);
    }

    public void remove(@NotNull String name) {
        Iterator<LDAPAttribute> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            LDAPAttribute a = iterator.next();
            if (!name.equalsIgnoreCase(a.getName())) continue;
            iterator.remove();
            return;
        }
    }

    public void removeElementAt(int index) throws IndexOutOfBoundsException {
        this.attributes.remove(index);
    }

    public int size() {
        return this.attributes.size();
    }

    @NotNull
    public LDAPAttributeSet duplicate() {
        return new LDAPAttributeSet(this.attributes);
    }

    @NotNull
    public String toString() {
        return this.attributes.toString();
    }
}

