/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.text;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.ClientCertificateAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogFields;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedAccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.text.TextFormattedLogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TextFormattedClientCertificateAccessLogMessage
extends TextFormattedAccessLogMessage
implements ClientCertificateAccessLogMessage {
    private static final long serialVersionUID = 4303971125611290508L;
    @NotNull
    private final List<String> issuerSubjectDNs;
    @Nullable
    private final String autoAuthenticatedAsDN;
    @Nullable
    private final String peerSubjectDN = this.getString(TextFormattedAccessLogFields.PEER_CERTIFICATE_SUBJECT_DN);

    public TextFormattedClientCertificateAccessLogMessage(@NotNull String logMessageString) throws LogException {
        this(new TextFormattedLogMessage(logMessageString));
    }

    TextFormattedClientCertificateAccessLogMessage(@NotNull TextFormattedLogMessage logMessage) {
        super(logMessage);
        this.autoAuthenticatedAsDN = this.getString(TextFormattedAccessLogFields.AUTO_AUTHENTICATED_AS);
        List<String> issuerDNs = this.getFields().get(TextFormattedAccessLogFields.ISSUER_CERTIFICATE_SUBJECT_DN.getFieldName());
        this.issuerSubjectDNs = issuerDNs == null ? Collections.emptyList() : issuerDNs;
    }

    @Override
    @NotNull
    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.CLIENT_CERTIFICATE;
    }

    @Override
    @Nullable
    public String getPeerSubjectDN() {
        return this.peerSubjectDN;
    }

    @Override
    @NotNull
    public List<String> getIssuerSubjectDNs() {
        return this.issuerSubjectDNs;
    }

    @Override
    @Nullable
    public String getAutoAuthenticatedAsDN() {
        return this.autoAuthenticatedAsDN;
    }
}

