/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketAggregateBase;
import org.opensearch.client.util.ApiTypeHelper;

public abstract class TermsAggregateBase<TBucket>
extends MultiBucketAggregateBase<TBucket> {
    @Nullable
    private final Long docCountErrorUpperBound;
    private final long sumOtherDocCount;

    protected TermsAggregateBase(AbstractBuilder<TBucket, ?> builder) {
        super(builder);
        this.docCountErrorUpperBound = ((AbstractBuilder)builder).docCountErrorUpperBound;
        this.sumOtherDocCount = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).sumOtherDocCount, this, "sumOtherDocCount");
    }

    @Nullable
    public final Long docCountErrorUpperBound() {
        return this.docCountErrorUpperBound;
    }

    public final long sumOtherDocCount() {
        return this.sumOtherDocCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.docCountErrorUpperBound != null) {
            generator.writeKey("doc_count_error_upper_bound");
            generator.write(this.docCountErrorUpperBound.longValue());
        }
        generator.writeKey("sum_other_doc_count");
        generator.write(this.sumOtherDocCount);
    }

    protected static <TBucket, BuilderT extends AbstractBuilder<TBucket, BuilderT>> void setupTermsAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TBucket> tBucketDeserializer) {
        MultiBucketAggregateBase.setupMultiBucketAggregateBaseDeserializer(op, tBucketDeserializer);
        op.add(AbstractBuilder::docCountErrorUpperBound, JsonpDeserializer.longDeserializer(), "doc_count_error_upper_bound");
        op.add(AbstractBuilder::sumOtherDocCount, JsonpDeserializer.longDeserializer(), "sum_other_doc_count");
    }

    public static abstract class AbstractBuilder<TBucket, BuilderT extends AbstractBuilder<TBucket, BuilderT>>
    extends MultiBucketAggregateBase.AbstractBuilder<TBucket, BuilderT> {
        @Nullable
        private Long docCountErrorUpperBound;
        private Long sumOtherDocCount;

        public final BuilderT docCountErrorUpperBound(@Nullable Long value) {
            this.docCountErrorUpperBound = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT sumOtherDocCount(long value) {
            this.sumOtherDocCount = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

