/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class KuromojiReadingFormTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final boolean useRomaji;
    public static final JsonpDeserializer<KuromojiReadingFormTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KuromojiReadingFormTokenFilter::setupKuromojiReadingFormTokenFilterDeserializer);

    private KuromojiReadingFormTokenFilter(Builder builder) {
        super(builder);
        this.useRomaji = ApiTypeHelper.requireNonNull(builder.useRomaji, this, "useRomaji");
    }

    public static KuromojiReadingFormTokenFilter of(Function<Builder, ObjectBuilder<KuromojiReadingFormTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.KuromojiReadingform;
    }

    public final boolean useRomaji() {
        return this.useRomaji;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "kuromoji_readingform");
        super.serializeInternal(generator, mapper);
        generator.writeKey("use_romaji");
        generator.write(this.useRomaji);
    }

    protected static void setupKuromojiReadingFormTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        KuromojiReadingFormTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::useRomaji, JsonpDeserializer.booleanDeserializer(), "use_romaji");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KuromojiReadingFormTokenFilter> {
        private Boolean useRomaji;

        public final Builder useRomaji(boolean value) {
            this.useRomaji = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KuromojiReadingFormTokenFilter build() {
            this._checkSingleUse();
            return new KuromojiReadingFormTokenFilter(this);
        }
    }
}

