/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remote.delivery;

import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeloNameProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeloNameProvider.class);
    public static final String LOCALHOST = "localhost";
    private final String heloName;
    private final DomainList domainList;

    public HeloNameProvider(String heloName, DomainList domainList) {
        this.heloName = heloName;
        this.domainList = domainList;
    }

    public String getHeloName() {
        if (this.heloName == null) {
            try {
                return this.domainList.getDefaultDomain().name();
            }
            catch (DomainListException e) {
                LOGGER.warn("Unable to access DomainList", (Throwable)e);
                return LOCALHOST;
            }
        }
        return this.heloName;
    }
}

