/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.internal.DateUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.mock2.MockHttpResponse;
import org.apache.juneau.rest.util.FinishableServletOutputStream;

public class MockServletResponse
implements HttpServletResponse,
MockHttpResponse {
    private String characterEncoding = "UTF-8";
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private long contentLength = 0L;
    private int bufferSize = 0;
    private Locale locale;
    private int sc;
    private String msg;
    private Map<String, String[]> headerMap = new LinkedHashMap<String, String[]>();

    public static MockServletResponse create() {
        return new MockServletResponse();
    }

    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getMessage() {
        return this.msg;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new FinishableServletOutputStream(this.baos);
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)this.getOutputStream(), this.characterEncoding));
    }

    public void setCharacterEncoding(String charset) {
        this.characterEncoding = charset;
    }

    public MockServletResponse characterEncoding(String value) {
        this.setCharacterEncoding(value);
        return this;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public MockServletResponse contentLength(int value) {
        this.setContentLength(value);
        return this;
    }

    public void setContentLengthLong(long len) {
        this.contentLength = len;
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public MockServletResponse contentType(String value) {
        this.setContentType(value);
        return this;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public MockServletResponse bufferSize(int value) {
        this.setBufferSize(value);
        return this;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public MockServletResponse locale(Locale value) {
        this.setLocale(value);
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addCookie(Cookie cookie) {
    }

    public boolean containsHeader(String name) {
        return this.getHeader(name) != null;
    }

    public String encodeURL(String url) {
        return null;
    }

    public String encodeRedirectURL(String url) {
        return null;
    }

    public String encodeUrl(String url) {
        return null;
    }

    public String encodeRedirectUrl(String url) {
        return null;
    }

    public void sendError(int sc, String msg) throws IOException {
        this.sc = sc;
        this.msg = msg;
    }

    public void sendError(int sc) throws IOException {
        this.sc = sc;
    }

    public void sendRedirect(String location) throws IOException {
        this.sc = 302;
        this.headerMap.put("Location", new String[]{location});
    }

    public void setDateHeader(String name, long date) {
        this.headerMap.put(name, new String[]{DateUtils.formatDate(new Date(date), "EEE, dd MMM yyyy HH:mm:ss zzz")});
    }

    public void addDateHeader(String name, long date) {
        this.headerMap.put(name, new String[]{DateUtils.formatDate(new Date(date), "EEE, dd MMM yyyy HH:mm:ss zzz")});
    }

    public void setHeader(String name, String value) {
        this.headerMap.put(name, new String[]{value});
    }

    public void addHeader(String name, String value) {
        this.headerMap.put(name, new String[]{value});
    }

    public MockServletResponse header(String name, String value) {
        this.setHeader(name, value);
        return this;
    }

    public void setIntHeader(String name, int value) {
        this.headerMap.put(name, new String[]{String.valueOf(value)});
    }

    public void addIntHeader(String name, int value) {
        this.headerMap.put(name, new String[]{String.valueOf(value)});
    }

    public void setStatus(int sc) {
        this.sc = sc;
    }

    public MockServletResponse status(int value) {
        this.setStatus(value);
        return this;
    }

    public void setStatus(int sc, String sm) {
        this.sc = sc;
        this.msg = sm;
    }

    @Override
    public int getStatus() {
        return this.sc;
    }

    public String getHeader(String name) {
        String[] s = this.headerMap.get(name);
        return s == null || s.length == 0 ? null : s[0];
    }

    public Collection<String> getHeaders(String name) {
        String[] s = this.headerMap.get(name);
        return s == null ? Collections.emptyList() : Arrays.asList(s);
    }

    public Collection<String> getHeaderNames() {
        return this.headerMap.keySet();
    }

    public String getBodyAsString() {
        try {
            return this.baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public MockServletResponse assertStatus(int status) throws AssertionError {
        if (this.getStatus() != status) {
            throw new MockAssertionError("Response did not have the expected status.\n\tExpected=[{0}]\n\tActual=[{1}]", status, this.getStatus());
        }
        return this;
    }

    public MockServletResponse assertBody(String text) throws AssertionError {
        if (!StringUtils.isEquals(text, this.getBodyAsString())) {
            throw new MockAssertionError("Response did not have the expected text.\n\tExpected=[{0}]\n\tActual=[{1}]", text, this.getBodyAsString());
        }
        return this;
    }

    public MockServletResponse assertBodyContains(String ... substrings) throws AssertionError {
        String text = this.getBodyAsString();
        for (String substring : substrings) {
            if (StringUtils.contains(text, substring)) continue;
            throw new MockAssertionError("Response did not have the expected substring.\n\tExpected=[{0}]\n\tBody=[{1}]", substring, text);
        }
        return this;
    }

    public MockServletResponse assertBodyMatches(String pattern) throws AssertionError {
        String text = this.getBodyAsString();
        if (!StringUtils.getMatchPattern(pattern).matcher(text).matches()) {
            throw new MockAssertionError("Response did not match expected pattern.\n\tPattern=[{0}]\n\tBody=[{1}]", pattern, text);
        }
        return this;
    }

    public MockServletResponse assertBodyMatchesRE(String regExp) throws AssertionError {
        String text = this.getBodyAsString();
        if (!Pattern.compile(regExp).matcher(text).matches()) {
            throw new MockAssertionError("Response did not match expected regular expression.\n\tRegExp=[{0}]\n\tBody=[{1}]", regExp, text);
        }
        return this;
    }

    public MockServletResponse assertCharset(String value) {
        if (!StringUtils.isEquals(value, this.getCharacterEncoding())) {
            throw new MockAssertionError("Response did not have the expected character encoding.\n\tExpected=[{0}]\n\tActual=[{1}]", value, this.getBodyAsString());
        }
        return this;
    }

    public MockServletResponse assertHeader(String name, String value) {
        if (!StringUtils.isEquals(value, this.getHeader(name))) {
            throw new MockAssertionError("Response did not have the expected value for header {0}.\n\tExpected=[{1}]\n\tActual=[{2}]", name, value, this.getHeader(name));
        }
        return this;
    }

    public MockServletResponse assertHeaderContains(String name, String ... substrings) {
        String text = this.getHeader(name);
        for (String substring : substrings) {
            if (StringUtils.contains(text, substring)) continue;
            throw new MockAssertionError("Response did not have the expected substring in header {0}.\n\tExpected=[{1}]\n\tHeader=[{2}]", name, substring, text);
        }
        return this;
    }

    @Override
    public byte[] getBody() {
        return this.baos.toByteArray();
    }

    @Override
    public Map<String, String[]> getHeaders() {
        return this.headerMap;
    }

    private static class MockAssertionError
    extends AssertionError {
        private static final long serialVersionUID = 1L;

        MockAssertionError(String msg, Object ... args) {
            super((Object)MessageFormat.format(msg, args));
            System.err.println(this.getMessage());
        }
    }
}

