/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.swap.ObjectSwap;

public class SurrogateSwap<T, F>
extends ObjectSwap<T, F> {
    private Constructor<F> constructor;
    private Method unswapMethod;

    protected SurrogateSwap(Class<T> forClass, Constructor<F> constructor, Method unswapMethod) {
        super(forClass, constructor.getDeclaringClass());
        this.constructor = constructor;
        this.unswapMethod = unswapMethod;
    }

    public static List<SurrogateSwap<?, ?>> findObjectSwaps(Class<?> c, BeanContext bc) {
        LinkedList l = new LinkedList();
        ClassInfo ci = ClassInfo.of(c);
        ci.forEachPublicConstructor(x -> x.hasNoAnnotation(bc, BeanIgnore.class) && x.hasNumParams(1) && x.isPublic(), x -> {
            Class<?> pt = x.getRawParamType(0);
            if (!pt.equals(c.getDeclaringClass())) {
                MethodInfo mi = ci.getPublicMethod(y -> y.hasReturnType(pt));
                Method unswapMethod = mi != null ? mi.inner() : null;
                l.add(new SurrogateSwap(pt, x.inner(), unswapMethod));
            }
        });
        return l;
    }

    @Override
    public F swap(BeanSession session, T o) throws SerializeException {
        try {
            return this.constructor.newInstance(o);
        }
        catch (Exception e) {
            throw new SerializeException(e);
        }
    }

    @Override
    public T unswap(BeanSession session, F f, ClassMeta<?> hint) throws ParseException {
        if (this.unswapMethod == null) {
            throw new ParseException("unswap() method not implement on surrogate class ''{1}'': {0}", ClassUtils.className(f), this.getNormalClass().getFullName());
        }
        try {
            return (T)this.unswapMethod.invoke(f, new Object[0]);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }
}

