/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.Set;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;

public class BeanDiff {
    private JsonMap v1 = new JsonMap();
    private JsonMap v2 = new JsonMap();

    public static <T> Builder<T> create(T first, T second) {
        return new Builder<T>().first(first).second(second);
    }

    public <T> BeanDiff(BeanContext bc, T first, T second, Set<String> include, Set<String> exclude) {
        if (first == null && second == null) {
            return;
        }
        BeanMap bm1 = first == null ? null : bc.toBeanMap(first);
        BeanMap bm2 = second == null ? null : bc.toBeanMap(second);
        Set<String> keys = Utils.nn(bm1) ? bm1.keySet() : bm2.keySet();
        keys.forEach(k -> {
            if (!(include != null && !include.contains(k) || exclude != null && exclude.contains(k))) {
                Object o2;
                Object o1 = bm1 == null ? null : bm1.get(k);
                Object object = o2 = bm2 == null ? null : bm2.get(k);
                if (Utils.neq(o1, o2)) {
                    if (Utils.nn(o1)) {
                        this.v1.put((String)k, o1);
                    }
                    if (Utils.nn(o2)) {
                        this.v2.put((String)k, o2);
                    }
                }
            }
        });
    }

    public JsonMap getV1() {
        return this.v1;
    }

    public JsonMap getV2() {
        return this.v2;
    }

    public boolean hasDiffs() {
        return this.v1.size() > 0 || this.v2.size() > 0;
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.mapb_so().buildFluent().a("v1", this.v1).a("v2", this.v2);
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    public static class Builder<T> {
        T first;
        T second;
        BeanContext beanContext = BeanContext.DEFAULT;
        Set<String> include;
        Set<String> exclude;

        public Builder<T> beanContext(BeanContext value) {
            this.beanContext = value;
            return this;
        }

        public BeanDiff build() {
            return new BeanDiff(this.beanContext, this.first, this.second, this.include, this.exclude);
        }

        public Builder<T> exclude(Set<String> properties) {
            this.exclude = properties;
            return this;
        }

        public Builder<T> exclude(String ... properties) {
            this.exclude = CollectionUtils.set(properties);
            return this;
        }

        public Builder<T> first(T value) {
            this.first = value;
            return this;
        }

        public Builder<T> include(Set<String> properties) {
            this.include = properties;
            return this;
        }

        public Builder<T> include(String ... properties) {
            this.include = CollectionUtils.set(properties);
            return this;
        }

        public Builder<T> second(T value) {
            this.second = value;
            return this;
        }
    }
}

