/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.ldaptive.AbstractLdapBean;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchReference;
import org.ldaptive.SortBehavior;

public class SearchResult
extends AbstractLdapBean {
    private static final int HASH_CODE_SEED = 337;
    private static final long serialVersionUID = -4686725717997623766L;
    private final Map<String, LdapEntry> resultEntries;
    private final Collection<SearchReference> searchReferences;

    public SearchResult() {
        this(SortBehavior.getDefaultSortBehavior());
    }

    public SearchResult(SortBehavior sb) {
        super(sb);
        if (SortBehavior.UNORDERED == sb) {
            this.resultEntries = new HashMap<String, LdapEntry>();
            this.searchReferences = new HashSet<SearchReference>();
        } else if (SortBehavior.ORDERED == sb) {
            this.resultEntries = new LinkedHashMap<String, LdapEntry>();
            this.searchReferences = new LinkedHashSet<SearchReference>();
        } else if (SortBehavior.SORTED == sb) {
            this.resultEntries = new TreeMap<String, LdapEntry>(String.CASE_INSENSITIVE_ORDER);
            this.searchReferences = new TreeSet<SearchReference>(new Comparator<SearchReference>(){

                @Override
                public int compare(SearchReference ref1, SearchReference ref2) {
                    return Arrays.toString(ref1.getReferralUrls()).compareTo(Arrays.toString(ref2.getReferralUrls()));
                }
            });
        } else {
            throw new IllegalArgumentException("Unknown sort behavior: " + (Object)((Object)sb));
        }
    }

    public SearchResult(LdapEntry ... entry) {
        this();
        for (LdapEntry e : entry) {
            this.addEntry(e);
        }
    }

    public SearchResult(Collection<LdapEntry> entries) {
        this();
        this.addEntries(entries);
    }

    public Collection<LdapEntry> getEntries() {
        return this.resultEntries.values();
    }

    public LdapEntry getEntry() {
        if (this.resultEntries.isEmpty()) {
            return null;
        }
        return this.resultEntries.values().iterator().next();
    }

    public LdapEntry getEntry(String dn) {
        return this.resultEntries.get(dn.toLowerCase());
    }

    public String[] getEntryDns() {
        return this.resultEntries.keySet().toArray(new String[this.resultEntries.keySet().size()]);
    }

    public void addEntry(LdapEntry ... entry) {
        for (LdapEntry e : entry) {
            this.resultEntries.put(e.getDn().toLowerCase(), e);
        }
    }

    public void addEntries(Collection<LdapEntry> entries) {
        for (LdapEntry e : entries) {
            this.addEntry(e);
        }
    }

    public void removeEntry(LdapEntry ... entry) {
        for (LdapEntry e : entry) {
            this.resultEntries.remove(e.getDn().toLowerCase());
        }
    }

    public void removeEntry(String dn) {
        this.resultEntries.remove(dn.toLowerCase());
    }

    public void removeEntries(Collection<LdapEntry> entries) {
        for (LdapEntry le : entries) {
            this.removeEntry(le);
        }
    }

    public Collection<SearchReference> getReferences() {
        return this.searchReferences;
    }

    public SearchReference getReference() {
        if (this.searchReferences.isEmpty()) {
            return null;
        }
        return this.searchReferences.iterator().next();
    }

    public void addReference(SearchReference ... reference) {
        Collections.addAll(this.searchReferences, reference);
    }

    public void addReferences(Collection<SearchReference> references) {
        for (SearchReference r : references) {
            this.addReference(r);
        }
    }

    public void removeReference(SearchReference ... reference) {
        for (SearchReference r : reference) {
            this.searchReferences.remove(r);
        }
    }

    public void removeReferences(Collection<SearchReference> references) {
        for (SearchReference r : references) {
            this.removeReference(r);
        }
    }

    public SearchResult subResult(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.resultEntries.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("Illegal index value");
        }
        SearchResult result = new SearchResult(this.getSortBehavior());
        if (this.resultEntries.isEmpty() || fromIndex == toIndex) {
            return result;
        }
        int i = 0;
        for (Map.Entry<String, LdapEntry> e : this.resultEntries.entrySet()) {
            if (i >= fromIndex && i < toIndex) {
                result.addEntry(e.getValue());
            }
            ++i;
        }
        return result;
    }

    public int size() {
        return this.resultEntries.size();
    }

    public void clear() {
        this.resultEntries.clear();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SearchResult) {
            SearchResult v = (SearchResult)o;
            return LdapUtils.areEqual(this.resultEntries, v.resultEntries) && LdapUtils.areEqual(this.searchReferences, v.searchReferences);
        }
        return false;
    }

    public int hashCode() {
        return LdapUtils.computeHashCode(337, this.resultEntries.values(), this.searchReferences);
    }

    public String toString() {
        return String.format("[%s@%d::entries=%s, references=%s]", this.getClass().getName(), this.hashCode(), this.resultEntries.values(), this.searchReferences);
    }

    public static SearchResult mergeEntries(SearchResult result) {
        LdapEntry mergedEntry = null;
        if (result != null) {
            for (LdapEntry le : result.getEntries()) {
                if (mergedEntry == null) {
                    mergedEntry = le;
                    continue;
                }
                for (LdapAttribute la : le.getAttributes()) {
                    LdapAttribute oldAttr = mergedEntry.getAttribute(la.getName());
                    if (oldAttr == null) {
                        mergedEntry.addAttribute(la);
                        continue;
                    }
                    if (oldAttr.isBinary()) {
                        oldAttr.addBinaryValues(la.getBinaryValues());
                        continue;
                    }
                    oldAttr.addStringValues(la.getStringValues());
                }
            }
        }
        return mergedEntry != null ? new SearchResult(mergedEntry) : new SearchResult();
    }
}

