/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.async;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.ldaptive.Connection;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchReference;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.async.AbstractAsyncOperation;
import org.ldaptive.async.AsyncRequest;
import org.ldaptive.async.FutureResponse;
import org.ldaptive.async.handler.ExceptionHandler;
import org.ldaptive.handler.HandlerResult;
import org.ldaptive.intermediate.IntermediateResponse;
import org.ldaptive.provider.SearchItem;
import org.ldaptive.provider.SearchListener;

public class AsyncSearchOperation
extends AbstractAsyncOperation<SearchRequest, SearchResult> {
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private boolean useMultiThreadedListener;

    public AsyncSearchOperation(Connection conn) {
        super(conn);
    }

    public boolean getUseMultiThreadedListener() {
        return this.useMultiThreadedListener;
    }

    public void setUseMultiThreadedListener(boolean b) {
        this.useMultiThreadedListener = b;
    }

    @Override
    public FutureResponse<SearchResult> execute(final SearchRequest request) throws LdapException {
        Future future = this.executorService.submit(new Callable<Response<SearchResult>>(){

            @Override
            public Response<SearchResult> call() throws LdapException {
                ExceptionHandler handler = AsyncSearchOperation.this.getExceptionHandler();
                try {
                    return AsyncSearchOperation.super.execute(request);
                }
                catch (LdapException e) {
                    if (handler != null) {
                        handler.handle(AsyncSearchOperation.this.getConnection(), request, e);
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    if (handler != null) {
                        handler.handle(AsyncSearchOperation.this.getConnection(), request, e);
                    }
                    throw e;
                }
            }
        });
        return new FutureResponse<SearchResult>(future);
    }

    @Override
    protected Response<SearchResult> invoke(SearchRequest request) throws LdapException {
        AsyncSearchListener listener = new AsyncSearchListener(request);
        this.getConnection().getProviderConnection().searchAsync(request, listener);
        try {
            return listener.getResponse();
        }
        catch (InterruptedException e) {
            throw new LdapException("Asynchronous search interrupted", e);
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    protected class AsyncSearchListener
    implements SearchListener {
        private final SearchRequest searchRequest;
        private final SearchResult searchResult;
        private final Semaphore responseLock = new Semaphore(0);
        private Response<SearchResult> searchResponse;
        private LdapException searchException;

        public AsyncSearchListener(SearchRequest request) {
            this.searchRequest = request;
            this.searchResult = new SearchResult(this.searchRequest.getSortBehavior());
        }

        @Override
        public void asyncRequestReceived(final AsyncRequest request) {
            AsyncSearchOperation.this.logger.trace("received async request={}", (Object)request);
            if (AsyncSearchOperation.this.useMultiThreadedListener) {
                AsyncSearchOperation.this.executorService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws LdapException {
                        try {
                            AsyncSearchListener.this.processAsyncRequest(request);
                        }
                        catch (LdapException e) {
                            AsyncSearchOperation.this.logger.warn("Handler exception ignored", (Throwable)e);
                        }
                        return null;
                    }
                });
            } else {
                try {
                    this.processAsyncRequest(request);
                }
                catch (LdapException e) {
                    AsyncSearchOperation.this.logger.warn("Handler exception ignored", (Throwable)e);
                }
            }
        }

        @Override
        public void searchItemReceived(final SearchItem item) {
            AsyncSearchOperation.this.logger.trace("received search item={}", (Object)item);
            if (AsyncSearchOperation.this.useMultiThreadedListener) {
                AsyncSearchOperation.this.executorService.submit(new Callable<Void>(){

                    @Override
                    public Void call() throws LdapException {
                        try {
                            AsyncSearchListener.this.processSearchItem(item);
                        }
                        catch (LdapException e) {
                            AsyncSearchOperation.this.logger.warn("Handler exception ignored", (Throwable)e);
                        }
                        return null;
                    }
                });
            } else {
                try {
                    this.processSearchItem(item);
                }
                catch (LdapException e) {
                    AsyncSearchOperation.this.logger.warn("Handler exception ignored", (Throwable)e);
                }
            }
        }

        @Override
        public void responseReceived(Response<Void> response) {
            this.searchResponse = new Response<SearchResult>(this.searchResult, response.getResultCode(), response.getMessage(), response.getMatchedDn(), response.getControls(), response.getReferralURLs(), response.getMessageId());
            this.responseLock.release();
        }

        public Response<SearchResult> getResponse() throws InterruptedException, LdapException {
            this.responseLock.acquire();
            if (this.searchException != null) {
                throw this.searchException;
            }
            return this.searchResponse;
        }

        @Override
        public void exceptionReceived(Exception exception) {
            AsyncSearchOperation.this.logger.trace("received exception={}", (Throwable)exception);
            this.searchException = exception instanceof LdapException ? (LdapException)exception : new LdapException(exception);
            this.responseLock.release();
        }

        protected void processAsyncRequest(AsyncRequest request) throws LdapException {
            AsyncSearchOperation.this.logger.trace("processing async request={}", (Object)request);
            HandlerResult hr = AsyncSearchOperation.this.executeHandlers(AsyncSearchOperation.this.getAsyncRequestHandlers(), this.searchRequest, request);
            if (hr.getAbort()) {
                AsyncSearchOperation.this.logger.debug("Aborting search on async request=%s", (Object)request);
                this.responseReceived(new Response<Object>(null, null));
            }
        }

        protected void processSearchItem(SearchItem item) throws LdapException {
            HandlerResult hr;
            IntermediateResponse ir;
            AsyncSearchOperation.this.logger.trace("processing search item={}", (Object)item);
            if (item.isSearchEntry()) {
                SearchEntry se = item.getSearchEntry();
                if (se != null) {
                    HandlerResult hr2 = AsyncSearchOperation.this.executeHandlers(this.searchRequest.getSearchEntryHandlers(), this.searchRequest, se);
                    if (hr2.getResult() != null) {
                        this.searchResult.addEntry((LdapEntry)hr2.getResult());
                    }
                    if (hr2.getAbort()) {
                        AsyncSearchOperation.this.logger.debug("Aborting search on entry=%s", (Object)se);
                        this.responseReceived(new Response<Object>(null, null));
                    }
                }
            } else if (item.isSearchReference()) {
                SearchReference sr = item.getSearchReference();
                if (sr != null) {
                    HandlerResult hr3 = AsyncSearchOperation.this.executeHandlers(this.searchRequest.getSearchReferenceHandlers(), this.searchRequest, sr);
                    if (hr3.getResult() != null) {
                        this.searchResult.addReference((SearchReference)hr3.getResult());
                    }
                    if (hr3.getAbort()) {
                        AsyncSearchOperation.this.logger.debug("Aborting search on reference=%s", (Object)sr);
                        this.responseReceived(new Response<Object>(null, null));
                    }
                }
            } else if (item.isIntermediateResponse() && (ir = item.getIntermediateResponse()) != null && (hr = AsyncSearchOperation.this.executeHandlers(this.searchRequest.getIntermediateResponseHandlers(), this.searchRequest, ir)).getAbort()) {
                AsyncSearchOperation.this.logger.debug("Aborting search on intermediate response=%s", (Object)ir);
                this.responseReceived(new Response<Object>(null, null));
            }
        }
    }
}

