/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import javax.naming.directory.SearchControls;
import org.apache.directory.api.ldap.aci.ACITuple;
import org.apache.directory.api.ldap.aci.ProtectedItem;
import org.apache.directory.api.ldap.aci.protectedItem.MaxImmSubItem;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.authz.support.OperationScope;

public class MaxImmSubFilter
implements ACITupleFilter {
    private final ExprNode childrenFilter;
    private final SearchControls childrenSearchControls;

    public MaxImmSubFilter(SchemaManager schemaManager) {
        AttributeType objectClassAt = null;
        try {
            objectClassAt = schemaManager.lookupAttributeTypeRegistry("objectClass");
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        this.childrenFilter = new PresenceNode(objectClassAt);
        this.childrenSearchControls = new SearchControls();
        this.childrenSearchControls.setSearchScope(1);
    }

    @Override
    public Collection<ACITuple> filter(AciContext aciContext, OperationScope scope, Entry userEntry) throws LdapException {
        ACI_LOG.debug("Filtering MaxImmSub...");
        if (aciContext.getEntryDn().isRootDse()) {
            return aciContext.getAciTuples();
        }
        if (aciContext.getAciTuples().isEmpty()) {
            return aciContext.getAciTuples();
        }
        if (scope != OperationScope.ENTRY) {
            return aciContext.getAciTuples();
        }
        int immSubCount = -1;
        Iterator<ACITuple> i = aciContext.getAciTuples().iterator();
        block0: while (i.hasNext()) {
            ACITuple tuple = i.next();
            if (!tuple.isGrant()) continue;
            for (ProtectedItem item : tuple.getProtectedItems()) {
                MaxImmSubItem mis;
                if (!(item instanceof MaxImmSubItem)) continue;
                if (immSubCount < 0) {
                    immSubCount = this.getImmSubCount(aciContext.getOperationContext(), aciContext.getEntryDn());
                }
                if (immSubCount < (mis = (MaxImmSubItem)item).getValue()) continue;
                i.remove();
                continue block0;
            }
        }
        return aciContext.getAciTuples();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getImmSubCount(OperationContext opContext, Dn entryName) throws LdapException {
        int cnt = 0;
        EntryFilteringCursor results = null;
        try {
            Dn baseDn = new Dn(opContext.getSession().getDirectoryService().getSchemaManager(), new Rdn[]{entryName.getRdn(entryName.size() - 1)});
            SearchOperationContext searchContext = new SearchOperationContext(opContext.getSession(), baseDn, this.childrenFilter, this.childrenSearchControls);
            searchContext.setAliasDerefMode(AliasDerefMode.DEREF_ALWAYS);
            searchContext.setPartition(opContext.getPartition());
            searchContext.setTransaction(opContext.getTransaction());
            results = opContext.getSession().getDirectoryService().getPartitionNexus().search(searchContext);
            try {
                while (results.next()) {
                    results.get();
                    ++cnt;
                }
            }
            catch (Exception e) {
                throw new LdapOtherException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception e) {
                    throw new LdapOperationException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return cnt;
    }
}

