/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.hadoop.xml;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.hadoop.xml.HadoopXmlResourceMessages;
import org.apache.knox.gateway.topology.simple.ProviderConfiguration;
import org.apache.knox.gateway.topology.simple.SimpleDescriptor;

class HadoopXmlResourceParserResult {
    private static final HadoopXmlResourceMessages LOG = (HadoopXmlResourceMessages)MessagesFactory.get(HadoopXmlResourceMessages.class);
    final Map<String, ProviderConfiguration> providers;
    final Set<SimpleDescriptor> descriptors;
    private final Set<String> deletedDescriptors;
    private final Set<String> deletedProviders;

    HadoopXmlResourceParserResult() {
        this(Collections.emptyMap(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    HadoopXmlResourceParserResult(Map<String, ProviderConfiguration> providers, Set<SimpleDescriptor> descriptors, Set<String> deletedDescriptors, Set<String> deletedProviders) {
        this.providers = providers;
        this.descriptors = descriptors;
        this.deletedDescriptors = deletedDescriptors;
        this.deletedProviders = this.nonReferencedProviders(deletedProviders, descriptors);
    }

    private Set<String> nonReferencedProviders(Set<String> deletedProviders, Set<SimpleDescriptor> descriptors) {
        Set referencedProviders = descriptors.stream().map(SimpleDescriptor::getProviderConfig).collect(Collectors.toSet());
        HashSet<String> result = new HashSet<String>();
        for (String provider : deletedProviders) {
            if (referencedProviders.contains(provider)) {
                LOG.notDeletingReferenceProvider(provider);
                continue;
            }
            result.add(provider);
        }
        return result;
    }

    public Map<String, ProviderConfiguration> getProviders() {
        return Collections.unmodifiableMap(this.providers);
    }

    public Set<SimpleDescriptor> getDescriptors() {
        return Collections.unmodifiableSet(this.descriptors);
    }

    public Set<String> getDeletedDescriptors() {
        return this.deletedDescriptors;
    }

    public Set<String> getDeletedProviders() {
        return this.deletedProviders;
    }
}

