/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.exception.http;

import java.util.Map;
import org.pac4j.core.context.ContextHelper;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.FoundAction;
import org.pac4j.core.exception.http.OkAction;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.SeeOtherAction;

public final class RedirectionActionHelper {
    private static boolean useModernHttpCodes = true;

    public static RedirectionAction buildRedirectUrlAction(WebContext context, String location) {
        if (ContextHelper.isPost(context) && useModernHttpCodes) {
            return new SeeOtherAction(location);
        }
        return new FoundAction(location);
    }

    public static RedirectionAction buildFormPostContentAction(WebContext context, String content) {
        return new OkAction(content);
    }

    public static String buildFormPostContent(WebContext context) {
        String requestedUrl = context.getFullRequestURL();
        Map<String, String[]> parameters = context.getRequestParameters();
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html>\n");
        buffer.append("<body>\n");
        buffer.append("<form action=\"" + RedirectionActionHelper.escapeHtml(requestedUrl) + "\" name=\"f\" method=\"post\">\n");
        if (parameters != null) {
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                String[] values = entry.getValue();
                if (values == null || values.length <= 0) continue;
                buffer.append("<input type='hidden' name=\"" + RedirectionActionHelper.escapeHtml(entry.getKey()) + "\" value=\"" + values[0] + "\" />\n");
            }
        }
        buffer.append("<input value='POST' type='submit' />\n");
        buffer.append("</form>\n");
        buffer.append("<script type='text/javascript'>document.forms['f'].submit();</script>\n");
        buffer.append("</body>\n");
        buffer.append("</html>\n");
        return buffer.toString();
    }

    protected static String escapeHtml(String s) {
        return s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll("\"", "&quot;");
    }

    public static boolean isUseModernHttpCodes() {
        return useModernHttpCodes;
    }

    public static void setUseModernHttpCodes(boolean useModernHttpCodes) {
        RedirectionActionHelper.useModernHttpCodes = useModernHttpCodes;
    }
}

