/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.knox.gateway.config.Configure;
import org.apache.knox.gateway.config.Default;
import org.apache.knox.gateway.dispatch.DefaultDispatch;
import org.apache.knox.gateway.dispatch.SyncDispatch;
import org.apache.knox.gateway.security.SubjectUtils;
import org.apache.knox.gateway.util.StringUtils;

public class ConfigurableDispatch
extends DefaultDispatch
implements SyncDispatch {
    private Set<String> requestExcludeHeaders = super.getOutboundRequestExcludeHeaders();
    private Set<String> responseExcludeHeaders = super.getOutboundResponseExcludeHeaders();
    private Map<String, String> requestAppendHeaders = Collections.emptyMap();
    private Set<String> responseExcludeSetCookieHeaderDirectives = super.getOutboundResponseExcludedSetCookieHeaderDirectives();
    private Boolean removeUrlEncoding = false;
    private boolean shouldIncludePrincipalAndGroups;
    private String actorIdHeaderName = "X-Knox-Actor-ID";
    private String actorGroupsHeaderPrefix = "X-Knox-Actor-Groups";
    private String groupFilterPattern = ".*";
    static final String DEFAULT_AUTH_ACTOR_ID_HEADER_NAME = "X-Knox-Actor-ID";
    static final String DEFAULT_AUTH_ACTOR_GROUPS_HEADER_PREFIX = "X-Knox-Actor-Groups";
    static final String DEFAULT_GROUP_FILTER_PATTERN = ".*";
    static final String DEFAULT_ARE_USERS_GROUPS_HEADER_INCLUDED = "false";
    protected static final int MAX_HEADER_LENGTH = 1000;
    protected static final String ACTOR_GROUPS_HEADER_FORMAT = "%s-%d";
    protected Pattern groupPattern = Pattern.compile(".*");

    private Set<String> convertCommaDelimitedHeadersToSet(String headers) {
        return headers == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(headers.split("\\s*,\\s*")));
    }

    private Map<String, String> convertCommaDelimitedHeadersToMap(String headers) {
        if (null == headers) {
            return Collections.emptyMap();
        }
        try {
            HashMap<String, String> extraHeaders = new HashMap<String, String>();
            Arrays.stream(headers.split("\\s*;\\s*")).forEach(keyValuePair -> extraHeaders.putIfAbsent(keyValuePair.split("\\s*:\\s*")[0], keyValuePair.split("\\s*:\\s*")[1]));
            return extraHeaders;
        }
        catch (Exception e) {
            auditor.audit("deserialize headers", headers, "header", "warning", "Extra Headers are skipped because of " + e.getMessage());
            return Collections.emptyMap();
        }
    }

    @Configure
    protected void setRequestExcludeHeaders(@Default(value=" ") String headers) {
        if (!" ".equals(headers)) {
            this.requestExcludeHeaders = this.convertCommaDelimitedHeadersToSet(headers);
        }
    }

    @Configure
    protected void setResponseExcludeHeaders(@Default(value=" ") String headers) {
        if (!" ".equals(headers)) {
            Set<String> headerSet = this.convertCommaDelimitedHeadersToSet(headers);
            this.populateSetCookieHeaderDirectiveExlusions(headerSet);
            this.populateHttpHeaderExlusionsOtherThanSetCookie(headerSet);
        }
    }

    @Configure
    protected void setRequestAppendHeaders(@Default(value=" ") String extraHeaders) {
        if (!" ".equals(extraHeaders)) {
            this.requestAppendHeaders = this.convertCommaDelimitedHeadersToMap(extraHeaders);
        }
    }

    private void populateSetCookieHeaderDirectiveExlusions(Set<String> headerSet) {
        String[] setCookieHeaderParts;
        Optional<String> setCookieHeader = headerSet.stream().filter(s -> StringUtils.startsWithIgnoreCase((String)s, (String)"SET-COOKIE")).findFirst();
        this.responseExcludeSetCookieHeaderDirectives = setCookieHeader.isPresent() ? ((setCookieHeaderParts = setCookieHeader.get().split(":")).length > 1 ? new HashSet<String>(Arrays.asList(setCookieHeaderParts[1].split(";"))).stream().map(e -> e.trim()).collect(Collectors.toSet()) : EXCLUDE_SET_COOKIES_DEFAULT) : EXCLUDE_SET_COOKIES_DEFAULT;
    }

    private void populateHttpHeaderExlusionsOtherThanSetCookie(Set<String> headerSet) {
        Set excludedHeadersOthenThanSetCookie = headerSet.stream().filter(s -> !StringUtils.startsWithIgnoreCase((String)s, (String)"SET-COOKIE")).collect(Collectors.toSet());
        if (!excludedHeadersOthenThanSetCookie.isEmpty()) {
            this.responseExcludeHeaders = excludedHeadersOthenThanSetCookie;
        }
    }

    @Configure
    protected void setRemoveUrlEncoding(@Default(value="false") String removeUrlEncoding) {
        this.removeUrlEncoding = Boolean.parseBoolean(removeUrlEncoding);
    }

    @Configure
    public void setShouldIncludePrincipalAndGroups(@Default(value="false") boolean shouldIncludePrincipalAndGroups) {
        this.shouldIncludePrincipalAndGroups = shouldIncludePrincipalAndGroups;
    }

    @Configure
    public void setActorIdHeaderName(@Default(value="X-Knox-Actor-ID") String actorIdHeaderName) {
        this.actorIdHeaderName = actorIdHeaderName;
    }

    @Configure
    public void setActorGroupsHeaderPrefix(@Default(value="X-Knox-Actor-Groups") String actorGroupsHeaderPrefix) {
        this.actorGroupsHeaderPrefix = actorGroupsHeaderPrefix;
    }

    @Configure
    public void setGroupFilterPattern(@Default(value=".*") String groupFilterPattern) {
        this.groupFilterPattern = groupFilterPattern;
        this.groupPattern = Pattern.compile(this.groupFilterPattern);
    }

    @Override
    public void copyRequestHeaderFields(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest) {
        Map<String, String> groups;
        super.copyRequestHeaderFields(outboundRequest, inboundRequest);
        Map<String, String> extraHeaders = this.getOutboundRequestAppendHeaders();
        if (MapUtils.isNotEmpty(extraHeaders)) {
            extraHeaders.forEach((arg_0, arg_1) -> ((HttpUriRequest)outboundRequest).addHeader(arg_0, arg_1));
        }
        if (this.shouldIncludePrincipalAndGroups && MapUtils.isNotEmpty(groups = this.addPrincipalAndGroups())) {
            groups.forEach((arg_0, arg_1) -> ((HttpUriRequest)outboundRequest).addHeader(arg_0, arg_1));
        }
    }

    private Map<String, String> addPrincipalAndGroups() {
        Set<String> matchingGroupNames;
        String primaryPrincipalName;
        ConcurrentHashMap<String, String> headers = new ConcurrentHashMap<String, String>();
        Subject subject = SubjectUtils.getCurrentSubject();
        String string = primaryPrincipalName = subject == null ? null : SubjectUtils.getPrimaryPrincipalName(subject);
        if (primaryPrincipalName == null) {
            LOG.noPrincipalFound();
            headers.put(this.actorIdHeaderName, "");
        } else {
            headers.put(this.actorIdHeaderName, primaryPrincipalName);
        }
        Set<String> set = matchingGroupNames = subject == null ? Collections.emptySet() : SubjectUtils.getGroupPrincipals(subject).stream().filter(group -> this.groupPattern.matcher(group.getName()).matches()).map(group -> group.getName()).collect(Collectors.toSet());
        if (!matchingGroupNames.isEmpty()) {
            List<String> groupStrings = this.getGroupStrings(matchingGroupNames);
            for (int i = 0; i < groupStrings.size(); ++i) {
                headers.put(String.format(Locale.ROOT, ACTOR_GROUPS_HEADER_FORMAT, this.actorGroupsHeaderPrefix, i + 1), groupStrings.get(i));
            }
        }
        return headers;
    }

    private List<String> getGroupStrings(Collection<String> groupNames) {
        if (groupNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> groupStrings = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String groupName : groupNames) {
            if (sb.length() + groupName.length() > 1000) {
                groupStrings.add(sb.toString());
                sb = new StringBuilder();
            }
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(groupName);
        }
        if (sb.length() > 0) {
            groupStrings.add(sb.toString());
        }
        return groupStrings;
    }

    @Override
    public Set<String> getOutboundResponseExcludeHeaders() {
        return this.responseExcludeHeaders == null ? Collections.emptySet() : this.responseExcludeHeaders;
    }

    @Override
    public Set<String> getOutboundResponseExcludedSetCookieHeaderDirectives() {
        return this.responseExcludeSetCookieHeaderDirectives == null ? Collections.emptySet() : this.responseExcludeSetCookieHeaderDirectives;
    }

    @Override
    public Set<String> getOutboundRequestExcludeHeaders() {
        return this.requestExcludeHeaders == null ? Collections.emptySet() : this.requestExcludeHeaders;
    }

    public Map<String, String> getOutboundRequestAppendHeaders() {
        return this.requestAppendHeaders == null ? Collections.emptyMap() : this.requestAppendHeaders;
    }

    public boolean getRemoveUrlEncoding() {
        return this.removeUrlEncoding;
    }

    @Override
    public URI getDispatchUrl(HttpServletRequest request) {
        if (this.getRemoveUrlEncoding()) {
            String base = request.getRequestURI();
            StringBuffer str = new StringBuffer();
            str.append(base);
            String query = request.getQueryString();
            if (query != null) {
                try {
                    query = URLDecoder.decode(query, StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                str.append('?');
                str.append(query);
            }
            this.encodeUnwiseCharacters(str);
            return URI.create(str.toString());
        }
        return super.getDispatchUrl(request);
    }
}

