/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.token;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class JWTokenAttributes {
    public static final String DEFAULT_ISSUER = "KNOXSSO";
    private final String userName;
    private final List<String> audiences;
    private final String algorithm;
    private final long expires;
    private final String signingKeystoreName;
    private final String signingKeystoreAlias;
    private final char[] signingKeystorePassphrase;
    private final boolean managed;
    private String jku;
    private final String type;
    private final Set<String> groups;
    private final String issuer;
    private String kid;

    JWTokenAttributes(String userName, List<String> audiences, String algorithm, long expires, String signingKeystoreName, String signingKeystoreAlias, char[] signingKeystorePassphrase, boolean managed, String jku, String type, Set<String> groups, String kid, String issuer) {
        this.userName = userName;
        this.audiences = audiences;
        this.algorithm = algorithm;
        this.expires = expires;
        this.signingKeystoreName = signingKeystoreName;
        this.signingKeystoreAlias = signingKeystoreAlias;
        this.signingKeystorePassphrase = signingKeystorePassphrase;
        this.managed = managed;
        this.jku = jku;
        this.type = type;
        this.groups = groups;
        this.kid = kid;
        this.issuer = issuer;
    }

    public String getUserName() {
        return this.userName;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public long getExpires() {
        return this.expires;
    }

    public Date getExpiresDate() {
        return this.expires == -1L ? null : new Date(this.expires);
    }

    public String getSigningKeystoreName() {
        return this.signingKeystoreName;
    }

    public String getSigningKeystoreAlias() {
        return this.signingKeystoreAlias;
    }

    public char[] getSigningKeystorePassphrase() {
        return this.signingKeystorePassphrase;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public URI getJkuUri() throws URISyntaxException {
        return this.jku != null ? new URI(this.jku) : null;
    }

    public String getJku() {
        return this.jku;
    }

    public void setJku(String jku) {
        this.jku = jku;
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public String getKid() {
        return this.kid;
    }

    public String getIssuer() {
        return this.issuer;
    }
}

