/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import java.util.NoSuchElementException;

public class IntRBTArray {
    public static final int TERMINAL = 0;
    public static final int LEFTDTR = 1;
    public static final int RIGHTDTR = 2;
    public static final int TWODTRS = 3;
    private int[] array;
    private int offset;

    public IntRBTArray(int[] array, int start) {
        this.offset = start;
        this.array = array;
    }

    public IntRBTArray(int[] array) {
        this(array, 0);
    }

    public int[] toArray() {
        return this.array;
    }

    public void setRootAddress(int start) {
        this.offset = start;
    }

    public int get(int i) throws NoSuchElementException {
        int pos = this.getPosition(i);
        if (pos >= 0) {
            return this.array[pos];
        }
        throw new NoSuchElementException();
    }

    public int getPosition(int i) throws NoSuchElementException {
        int current = this.offset;
        if (this.array == null || this.array.length < current + 3) {
            return -1;
        }
        while (current >= 0 && this.array.length >= current + 3) {
            int key = this.array[current];
            int dtrCode = this.array[current + 2];
            if (key > i) {
                switch (dtrCode) {
                    case 0: {
                        return -1;
                    }
                    case 1: {
                        current += 3;
                        break;
                    }
                    case 2: {
                        return -1;
                    }
                    case 3: {
                        current += 4;
                    }
                }
                continue;
            }
            if (key < i) {
                switch (dtrCode) {
                    case 0: {
                        return -1;
                    }
                    case 1: {
                        return -1;
                    }
                    case 2: {
                        current += 3;
                        break;
                    }
                    case 3: {
                        if (current + 3 > this.array.length) {
                            return -1;
                        }
                        current = this.array[current + 3];
                    }
                }
                continue;
            }
            return current + 1;
        }
        return -1;
    }
}

