/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongConsumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.compression.CompressionInformation;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.future.DefaultKeyExchangeFuture;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.future.GlobalRequestFuture;
import org.apache.sshd.common.future.KeyExchangeFuture;
import org.apache.sshd.common.global.GlobalRequestException;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.kex.extension.KexExtensions;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.mac.MacInformation;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import org.apache.sshd.common.session.SessionDisconnectHandler;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.session.SessionWorkBuffer;
import org.apache.sshd.common.session.helpers.CurrentService;
import org.apache.sshd.common.session.helpers.KeyExchangeMessageHandler;
import org.apache.sshd.common.session.helpers.MissingAttachedSessionException;
import org.apache.sshd.common.session.helpers.MultipleAttachedSessionException;
import org.apache.sshd.common.session.helpers.PendingWriteFuture;
import org.apache.sshd.common.session.helpers.SessionHelper;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.core.CoreModuleProperties;

public abstract class AbstractSession
extends SessionHelper {
    public static final String SESSION = "org.apache.sshd.session";
    protected final Random random;
    protected final Collection<SessionListener> sessionListeners = new CopyOnWriteArraySet<SessionListener>();
    protected final SessionListener sessionListenerProxy;
    protected final Collection<ChannelListener> channelListeners = new CopyOnWriteArraySet<ChannelListener>();
    protected final ChannelListener channelListenerProxy;
    protected final Collection<PortForwardingEventListener> tunnelListeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    protected final PortForwardingEventListener tunnelListenerProxy;
    protected byte[] sessionId;
    protected String serverVersion;
    protected String clientVersion;
    protected final Map<KexProposalOption, String> serverProposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
    protected final Map<KexProposalOption, String> unmodServerProposal = Collections.unmodifiableMap(this.serverProposal);
    protected final Map<KexProposalOption, String> clientProposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
    protected final Map<KexProposalOption, String> unmodClientProposal = Collections.unmodifiableMap(this.clientProposal);
    protected final Map<KexProposalOption, String> negotiationResult = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
    protected final Map<KexProposalOption, String> unmodNegotiationResult = Collections.unmodifiableMap(this.negotiationResult);
    protected KeyExchange kex;
    protected Boolean firstKexPacketFollows;
    protected boolean initialKexDone;
    protected final AtomicReference<KexState> kexState = new AtomicReference<KexState>(KexState.UNKNOWN);
    protected final AtomicReference<DefaultKeyExchangeFuture> kexFutureHolder = new AtomicReference<Object>(null);
    protected DefaultKeyExchangeFuture kexInitializedFuture;
    protected Cipher outCipher;
    protected Cipher inCipher;
    protected int outCipherSize = 8;
    protected int inCipherSize = 8;
    protected Mac outMac;
    protected Mac inMac;
    protected int outMacSize;
    protected int inMacSize;
    protected byte[] inMacResult;
    protected Compression outCompression;
    protected Compression inCompression;
    protected long seqi;
    protected long seqo;
    protected SessionWorkBuffer uncompressBuffer;
    protected final SessionWorkBuffer decoderBuffer;
    protected int decoderState;
    protected int decoderLength;
    protected SshException discarding;
    protected final Object encodeLock = new Object();
    protected final Object decodeLock = new Object();
    protected final Object requestLock = new Object();
    protected boolean strictKex;
    protected long initialKexInitSequenceNumber = -1L;
    protected final KeyExchangeMessageHandler kexHandler;
    protected final AtomicLong inPacketsCount = new AtomicLong(0L);
    protected final AtomicLong outPacketsCount = new AtomicLong(0L);
    protected final AtomicLong inBytesCount = new AtomicLong(0L);
    protected final AtomicLong outBytesCount = new AtomicLong(0L);
    protected final AtomicLong inBlocksCount = new AtomicLong(0L);
    protected final AtomicLong outBlocksCount = new AtomicLong(0L);
    protected final AtomicReference<Instant> lastKeyTimeValue = new AtomicReference<Instant>(Instant.now());
    protected long maxRekyPackets;
    protected long maxRekeyBytes;
    protected Duration maxRekeyInterval;
    protected MessageCodingSettings inSettings;
    protected MessageCodingSettings outSettings;
    protected final CurrentService currentService;
    protected int ignorePacketDataLength;
    protected long ignorePacketsFrequency;
    protected int ignorePacketsVariance;
    protected final AtomicLong maxRekeyBlocks = new AtomicLong(CoreModuleProperties.REKEY_BYTES_LIMIT.getRequiredDefault() / 16L);
    protected final AtomicLong ignorePacketsCount = new AtomicLong(CoreModuleProperties.IGNORE_MESSAGE_FREQUENCY.getRequiredDefault());
    private final Deque<GlobalRequestFuture> pendingGlobalRequests = new ConcurrentLinkedDeque<GlobalRequestFuture>();
    private final Map<Buffer, LongConsumer> globalSequenceNumbers = new ConcurrentHashMap<Buffer, LongConsumer>();
    private byte[] clientKexData;
    private byte[] serverKexData;

    protected AbstractSession(boolean serverSession, FactoryManager factoryManager, IoSession ioSession) {
        super(serverSession, factoryManager, ioSession);
        this.decoderBuffer = new SessionWorkBuffer(this);
        this.kexHandler = Objects.requireNonNull(this.initializeKeyExchangeMessageHandler(), "No KeyExchangeMessageHandler set on the session");
        this.currentService = Objects.requireNonNull(this.initializeCurrentService(), "No CurrentService set on the session");
        AbstractSession.attachSession(ioSession, this);
        Factory<? extends Random> factory = ValidateUtils.checkNotNull(factoryManager.getRandomFactory(), "No random factory for %s", (Object)ioSession);
        this.random = ValidateUtils.checkNotNull(factory.create(), "No randomizer instance for %s", (Object)ioSession);
        this.refreshConfiguration();
        this.sessionListenerProxy = EventListenerUtils.proxyWrapper(SessionListener.class, this.sessionListeners);
        this.channelListenerProxy = EventListenerUtils.proxyWrapper(ChannelListener.class, this.channelListeners);
        this.tunnelListenerProxy = EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, this.tunnelListeners);
        try {
            this.signalSessionEstablished(ioSession);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeSshException(e);
        }
    }

    protected KeyExchangeMessageHandler initializeKeyExchangeMessageHandler() {
        return new KeyExchangeMessageHandler(this, this.log);
    }

    protected CurrentService initializeCurrentService() {
        return new CurrentService(this);
    }

    public static int calculatePadLength(int len, int blockSize, boolean etmMode) {
        int pad;
        ++len;
        if (!etmMode) {
            len += 4;
        }
        if ((pad = -len & blockSize - 1) < blockSize) {
            pad += blockSize;
        }
        return pad;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public Map<KexProposalOption, String> getServerKexProposals() {
        return this.unmodServerProposal;
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public Map<KexProposalOption, String> getClientKexProposals() {
        return this.unmodClientProposal;
    }

    @Override
    public KeyExchange getKex() {
        return this.kex;
    }

    @Override
    public KexState getKexState() {
        return this.kexState.get();
    }

    @Override
    public byte[] getSessionId() {
        return NumberUtils.isEmpty(this.sessionId) ? this.sessionId : (byte[])this.sessionId.clone();
    }

    @Override
    public Map<KexProposalOption, String> getKexNegotiationResult() {
        return this.unmodNegotiationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNegotiatedKexParameter(KexProposalOption paramType) {
        if (paramType == null) {
            return null;
        }
        Map<KexProposalOption, String> map = this.negotiationResult;
        synchronized (map) {
            return this.negotiationResult.get((Object)paramType);
        }
    }

    @Override
    public CipherInformation getCipherInformation(boolean incoming) {
        return incoming ? this.inCipher : this.outCipher;
    }

    @Override
    public CompressionInformation getCompressionInformation(boolean incoming) {
        return incoming ? this.inCompression : this.outCompression;
    }

    @Override
    public MacInformation getMacInformation(boolean incoming) {
        return incoming ? this.inMac : this.outMac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(Readable buffer) throws Exception {
        Object object = this.decodeLock;
        synchronized (object) {
            this.decoderBuffer.putBuffer(buffer);
            if (this.clientVersion == null || this.serverVersion == null) {
                if (this.readIdentification(this.decoderBuffer)) {
                    this.decoderBuffer.compact();
                } else {
                    return;
                }
            }
            this.decode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshConfiguration() {
        Random random = this.random;
        synchronized (random) {
            this.maxRekeyBytes = CoreModuleProperties.REKEY_BYTES_LIMIT.getRequired(this);
            this.maxRekeyInterval = CoreModuleProperties.REKEY_TIME_LIMIT.getRequired(this);
            this.maxRekyPackets = CoreModuleProperties.REKEY_PACKETS_LIMIT.getRequired(this);
            this.ignorePacketDataLength = CoreModuleProperties.IGNORE_MESSAGE_SIZE.getRequired(this);
            this.ignorePacketsFrequency = CoreModuleProperties.IGNORE_MESSAGE_FREQUENCY.getRequired(this);
            this.ignorePacketsVariance = CoreModuleProperties.IGNORE_MESSAGE_VARIANCE.getRequired(this);
            if ((long)this.ignorePacketsVariance >= this.ignorePacketsFrequency) {
                this.ignorePacketsVariance = 0;
            }
            long countValue = this.calculateNextIgnorePacketCount(this.random, this.ignorePacketsFrequency, this.ignorePacketsVariance);
            this.ignorePacketsCount.set(countValue);
        }
    }

    protected void handleMessage(Buffer buffer) throws Exception {
        try {
            ThreadUtils.runAsInternal(() -> {
                this.doHandleMessage(buffer);
                return null;
            });
        }
        catch (Throwable e) {
            DefaultKeyExchangeFuture kexFuture = this.kexFutureHolder.get();
            if (kexFuture != null) {
                kexFuture.setValue(e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeSshException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void doHandleMessage(Buffer buffer) throws Exception {
        cmd = buffer.getUByte();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doHandleMessage({}) process #{} {}", new Object[]{this, this.seqi - 1L, SshConstants.getCommandMessageName(cmd)});
        }
        switch (cmd) {
            case 1: {
                this.handleDisconnect(buffer);
                break;
            }
            case 2: {
                this.failStrictKex(cmd);
                this.handleIgnore(buffer);
                break;
            }
            case 3: {
                this.failStrictKex(cmd);
                this.handleUnimplemented(buffer);
                break;
            }
            case 4: {
                this.handleDebug(buffer);
                this.failStrictKex(cmd);
                break;
            }
            case 5: {
                this.failStrictKex(cmd);
                this.handleServiceRequest(buffer);
                break;
            }
            case 6: {
                this.failStrictKex(cmd);
                this.handleServiceAccept(buffer);
                break;
            }
            case 20: {
                this.handleKexInit(buffer);
                break;
            }
            case 21: {
                this.handleNewKeys(cmd, buffer);
                break;
            }
            case 7: {
                this.failStrictKex(cmd);
                this.handleKexExtension(cmd, buffer);
                break;
            }
            case 8: {
                this.failStrictKex(cmd);
                this.handleNewCompression(cmd, buffer);
                break;
            }
            default: {
                if (cmd < 30 || cmd > 49) ** GOTO lbl54
                if (this.firstKexPacketFollows != null) {
                    try {
                        if (!this.handleFirstKexPacketFollows(cmd, buffer, this.firstKexPacketFollows)) {
                            break;
                        }
                    }
                    finally {
                        this.firstKexPacketFollows = null;
                    }
                }
                this.handleKexMessage(cmd, buffer);
                break;
lbl54:
                // 1 sources

                this.failStrictKex(cmd);
                if (this.currentService.process(cmd, buffer)) {
                    this.resetIdleTimeout();
                    break;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("process({}) Unsupported command: {}", (Object)this, (Object)SshConstants.getCommandMessageName(cmd));
                }
                this.notImplemented(cmd, buffer);
            }
        }
        this.checkRekey();
    }

    protected void failStrictKex(int cmd) throws SshException {
        if (!this.initialKexDone && this.strictKex) {
            throw new SshException(3, SshConstants.getCommandMessageName(cmd) + " not allowed during initial key exchange in strict KEX");
        }
    }

    protected boolean handleFirstKexPacketFollows(int cmd, Buffer buffer, boolean followFlag) {
        if (!followFlag) {
            return true;
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        for (KexProposalOption option : KexProposalOption.FIRST_KEX_PACKET_GUESS_MATCHES) {
            Map.Entry<String, String> result = this.comparePreferredKexProposalOption(option);
            if (result == null) continue;
            if (debugEnabled) {
                this.log.debug("handleFirstKexPacketFollows({})[{}] 1st follow KEX packet {} option mismatch: client={}, server={}", new Object[]{this, SshConstants.getCommandMessageName(cmd), option, result.getKey(), result.getValue()});
            }
            return false;
        }
        return true;
    }

    protected Map.Entry<String, String> comparePreferredKexProposalOption(KexProposalOption option) {
        String serverValue;
        String[] clientPreferences = GenericUtils.split(this.clientProposal.get((Object)option), ',');
        String clientValue = GenericUtils.isEmpty(clientPreferences) ? null : clientPreferences[0];
        String[] serverPreferences = GenericUtils.split(this.serverProposal.get((Object)option), ',');
        String string = serverValue = GenericUtils.isEmpty(serverPreferences) ? null : serverPreferences[0];
        if (GenericUtils.isEmpty(clientValue) || GenericUtils.isEmpty(serverValue) || !Objects.equals(clientValue, serverValue)) {
            return new AbstractMap.SimpleImmutableEntry<String, String>(clientValue, serverValue);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IoWriteFuture sendNewKeys() throws Exception {
        AbstractMap.SimpleImmutableEntry<Integer, DefaultKeyExchangeFuture> flushDone;
        int numPending;
        IoWriteFuture future;
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendNewKeys({}) Send SSH_MSG_NEWKEYS", (Object)this);
        }
        this.prepareNewKeys();
        Buffer buffer = this.createBuffer((byte)21, 8);
        Object object = this.encodeLock;
        synchronized (object) {
            future = this.doWritePacket(buffer);
            this.setOutputEncoding();
        }
        this.kexHandler.updateState(() -> this.kexState.set(KexState.KEYS));
        this.resetIdleTimeout();
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        if (extHandler != null && extHandler.isKexExtensionsAvailable(this, KexExtensionHandler.AvailabilityPhase.NEWKEYS)) {
            extHandler.sendKexExtensions(this, KexExtensionHandler.KexPhase.NEWKEYS);
        }
        if ((numPending = (flushDone = this.kexHandler.terminateKeyExchange()).getKey().intValue()) == 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleNewKeys({}) No pending packets to flush at end of KEX", (Object)this);
            }
            flushDone.getValue().setValue(Boolean.TRUE);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleNewKeys({}) {} pending packets to flush at end of KEX", (Object)this, (Object)numPending);
            }
            this.kexHandler.flushQueue(flushDone.getValue());
        }
        return future;
    }

    protected void handleKexMessage(int cmd, Buffer buffer) throws Exception {
        this.validateKexState(cmd, KexState.RUN);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.kex.next(cmd, buffer)) {
            if (debugEnabled) {
                this.log.debug("handleKexMessage({})[{}] KEX processing complete after cmd={}", new Object[]{this, this.kex.getName(), cmd});
            }
            this.checkKeys();
            this.sendNewKeys();
        } else if (debugEnabled) {
            this.log.debug("handleKexMessage({})[{}] more KEX packets expected after cmd={}", new Object[]{this, this.kex.getName(), cmd});
        }
    }

    protected void handleKexExtension(int cmd, Buffer buffer) throws Exception {
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        int startPos = buffer.rpos();
        if (extHandler != null && extHandler.handleKexExtensionsMessage(this, buffer)) {
            return;
        }
        buffer.rpos(startPos);
        this.notImplemented(cmd, buffer);
    }

    protected void handleNewCompression(int cmd, Buffer buffer) throws Exception {
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        int startPos = buffer.rpos();
        if (extHandler != null && extHandler.handleKexCompressionMessage(this, buffer)) {
            return;
        }
        buffer.rpos(startPos);
        this.notImplemented(cmd, buffer);
    }

    protected void handleServiceRequest(Buffer buffer) throws Exception {
        String serviceName = buffer.getString();
        this.handleServiceRequest(serviceName, buffer);
    }

    protected boolean handleServiceRequest(String serviceName, Buffer buffer) throws Exception {
        KexState state;
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("handleServiceRequest({}) SSH_MSG_SERVICE_REQUEST '{}'", (Object)this, (Object)serviceName);
        }
        if (!this.validateServiceKexState(state = this.kexState.get())) {
            throw new IllegalStateException("Received " + SshConstants.getCommandMessageName(5) + " while in KEX state=" + (Object)((Object)state));
        }
        try {
            this.startService(serviceName, buffer);
        }
        catch (Throwable e) {
            this.debug("handleServiceRequest({}) Service {} rejected: {} = {}", this, serviceName, e.getClass().getSimpleName(), e.getMessage(), e);
            this.disconnect(7, "Bad service request: " + serviceName);
            return false;
        }
        if (debugEnabled) {
            this.log.debug("handleServiceRequest({}) Accepted service {}", (Object)this, (Object)serviceName);
        }
        Buffer response = this.createBuffer((byte)6, 8 + GenericUtils.length(serviceName));
        response.putString(serviceName);
        this.writePacket(response);
        return true;
    }

    protected boolean validateServiceKexState(KexState state) {
        if (KexState.DONE.equals((Object)state)) {
            return true;
        }
        if (KexState.INIT.equals((Object)state)) {
            return this.initialKexDone;
        }
        return false;
    }

    protected void handleServiceAccept(Buffer buffer) throws Exception {
        this.handleServiceAccept(buffer.getString(), buffer);
    }

    protected void handleServiceAccept(String serviceName, Buffer buffer) throws Exception {
        KexState state;
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleServiceAccept({}) SSH_MSG_SERVICE_ACCEPT service={}", (Object)this, (Object)serviceName);
        }
        if (!this.validateServiceKexState(state = this.kexState.get())) {
            throw new IllegalStateException("Received " + SshConstants.getCommandMessageName(5) + " while in KEX state=" + (Object)((Object)state));
        }
    }

    protected void handleKexInit(Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleKexInit({}) SSH_MSG_KEXINIT", (Object)this);
        }
        this.receiveKexInit(buffer);
        this.doKexNegotiation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doKexNegotiation() throws Exception {
        byte[] i_c;
        byte[] i_s;
        KexStart starting = this.kexHandler.updateState(() -> {
            if (this.kexState.compareAndSet(KexState.DONE, KexState.RUN)) {
                this.kexHandler.initNewKeyExchange();
                return KexStart.PEER;
            }
            if (this.kexState.compareAndSet(KexState.INIT, KexState.RUN)) {
                return KexStart.BOTH;
            }
            return KexStart.ONGOING;
        });
        switch (starting) {
            case PEER: {
                this.sendKexInit();
                break;
            }
            case BOTH: {
                DefaultKeyExchangeFuture initFuture;
                AtomicReference<KexState> atomicReference = this.kexState;
                synchronized (atomicReference) {
                    initFuture = this.kexInitializedFuture;
                    if (initFuture == null) {
                        this.kexInitializedFuture = initFuture = new DefaultKeyExchangeFuture(this.toString(), null);
                    }
                }
                initFuture.await(CoreModuleProperties.KEX_PROPOSAL_SETUP_TIMEOUT.getRequired(this));
                break;
            }
            default: {
                throw new IllegalStateException("Received SSH_MSG_KEXINIT while key exchange is running");
            }
        }
        Map<KexProposalOption, String> result = this.negotiate();
        String kexAlgorithm = result.get((Object)KexProposalOption.ALGORITHMS);
        List<KeyExchangeFactory> kexFactories = this.getKeyExchangeFactories();
        KeyExchangeFactory kexFactory = NamedResource.findByName(kexAlgorithm, String.CASE_INSENSITIVE_ORDER, kexFactories);
        ValidateUtils.checkNotNull(kexFactory, "Unknown negotiated KEX algorithm: %s", (Object)kexAlgorithm);
        byte[] v_s = this.serverVersion.getBytes(StandardCharsets.UTF_8);
        byte[] v_c = this.clientVersion.getBytes(StandardCharsets.UTF_8);
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            i_s = this.getServerKexData();
            i_c = this.getClientKexData();
        }
        this.kex = kexFactory.createKeyExchange(this);
        this.kex.init(v_s, v_c, i_s, i_c);
        atomicReference = this.kexState;
        synchronized (atomicReference) {
            this.kexInitializedFuture = null;
        }
        this.signalSessionEvent(SessionListener.Event.KexCompleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewKeys(int cmd, Buffer buffer) throws Exception {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("handleNewKeys({}) SSH_MSG_NEWKEYS command={}", (Object)this, (Object)SshConstants.getCommandMessageName(cmd));
        }
        this.validateKexState(cmd, KexState.KEYS);
        this.setInputEncoding();
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            this.kexInitializedFuture = null;
        }
        this.initialKexDone = true;
        DefaultKeyExchangeFuture kexFuture = this.kexFutureHolder.get();
        if (kexFuture != null) {
            kexFuture.setValue(Boolean.TRUE);
        }
        this.signalSessionEvent(SessionListener.Event.KeyEstablished);
        this.kexHandler.updateState(() -> {
            this.kex = null;
            this.kexState.set(KexState.DONE);
        });
        Object object = this.futureLock;
        synchronized (object) {
            this.futureLock.notifyAll();
        }
    }

    protected void validateKexState(int cmd, KexState expected) {
        KexState actual = this.kexState.get();
        if (!expected.equals((Object)actual)) {
            throw new IllegalStateException("Received KEX command=" + SshConstants.getCommandMessageName(cmd) + " while in state=" + (Object)((Object)actual) + " instead of " + (Object)((Object)expected));
        }
    }

    @Override
    protected Closeable getInnerCloseable() {
        Closeable closer = this.builder().parallel(this.toString(), this.getServices()).close(this.getIoSession()).build();
        closer.addCloseFutureListener(future -> this.clearAttributes());
        return closer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preClose() {
        GlobalRequestFuture future;
        DefaultKeyExchangeFuture kexFuture;
        DefaultKeyExchangeFuture initFuture;
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            initFuture = this.kexInitializedFuture;
        }
        if (initFuture != null) {
            initFuture.setValue(new SshException("Session closing while KEX in progress"));
        }
        if ((kexFuture = this.kexFutureHolder.get()) != null) {
            kexFuture.setValue(new SshException("Session closing while KEX in progress"));
        }
        this.kexHandler.shutdown();
        boolean debugEnabled = this.log.isDebugEnabled();
        while ((future = this.pendingGlobalRequests.pollLast()) != null) {
            if (debugEnabled) {
                this.log.debug("preClose({}): Session closing; failing still pending global request {}", (Object)this, (Object)future.getId());
            }
            future.setValue(new SshException("Session is closing"));
        }
        try {
            this.signalSessionClosed();
        }
        finally {
            this.sessionListeners.clear();
            this.channelListeners.clear();
            this.tunnelListeners.clear();
        }
        super.preClose();
    }

    protected List<Service> getServices() {
        Service service = this.currentService.getService();
        return service != null ? Collections.singletonList(service) : Collections.emptyList();
    }

    @Override
    public <T extends Service> T getService(Class<T> clazz) {
        List<Service> registeredServices = this.getServices();
        ValidateUtils.checkState(GenericUtils.isNotEmpty(registeredServices), "No registered services to look for %s", (Object)clazz.getSimpleName());
        for (Service s : registeredServices) {
            if (!clazz.isInstance(s)) continue;
            return (T)((Service)clazz.cast(s));
        }
        throw new IllegalStateException("Attempted to access unknown service " + clazz.getSimpleName());
    }

    @Override
    protected Buffer preProcessEncodeBuffer(int cmd, Buffer buffer) throws IOException {
        LongConsumer setter = this.globalSequenceNumbers.remove(buffer = super.preProcessEncodeBuffer(cmd, buffer));
        if (setter != null) {
            setter.accept(this.seqo);
        }
        return buffer;
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer) throws IOException {
        return this.kexHandler.writePacket(buffer, 0L, null);
    }

    @Override
    public IoWriteFuture writePacket(Buffer buffer, long timeout, TimeUnit unit) throws IOException {
        IoWriteFuture writeFuture;
        long timeoutMillis = unit.toMillis(timeout);
        try {
            long start = System.currentTimeMillis();
            writeFuture = this.kexHandler.writePacket(buffer, timeout, unit);
            long elapsed = System.currentTimeMillis() - start;
            timeoutMillis = elapsed >= timeoutMillis ? 1L : (timeoutMillis -= elapsed);
        }
        catch (InterruptedIOException e) {
            PendingWriteFuture timedOut = new PendingWriteFuture((Object)this, buffer);
            TimeoutException t = new TimeoutException("Timeout writing packet: " + timeout + " " + (Object)((Object)unit));
            t.initCause(e);
            if (this.log.isDebugEnabled()) {
                this.log.debug("writePacket({}): {}", (Object)this, (Object)t.getMessage());
            }
            timedOut.setValue(t);
            return timedOut;
        }
        if (writeFuture.isDone()) {
            return writeFuture;
        }
        DefaultSshFuture future = (DefaultSshFuture)((Object)writeFuture);
        FactoryManager factoryManager = this.getFactoryManager();
        ScheduledExecutorService executor = factoryManager.getScheduledExecutorService();
        ScheduledFuture<?> sched = executor.schedule(() -> {
            TimeoutException t = new TimeoutException("Timeout writing packet: " + timeout + " " + (Object)((Object)unit));
            if (this.log.isDebugEnabled()) {
                this.log.debug("writePacket({}): {}", (Object)this, (Object)t.getMessage());
            }
            future.setValue(t);
        }, timeoutMillis, TimeUnit.MILLISECONDS);
        future.addListener(f -> sched.cancel(false));
        return writeFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer resolveOutputPacket(Buffer buffer) throws IOException {
        Buffer ignoreBuf = null;
        int ignoreDataLen = this.resolveIgnoreBufferDataLength();
        if (ignoreDataLen > 0) {
            ignoreBuf = this.createBuffer((byte)2, ignoreDataLen + 8);
            ignoreBuf.putUInt(ignoreDataLen);
            int wpos = ignoreBuf.wpos();
            Random random = this.random;
            synchronized (random) {
                this.random.fill(ignoreBuf.array(), wpos, ignoreDataLen);
            }
            ignoreBuf.wpos(wpos + ignoreDataLen);
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveOutputPacket({}) append SSH_MSG_IGNORE message", (Object)this);
            }
        }
        int curPos = buffer.rpos();
        byte[] data = buffer.array();
        int cmd = data[curPos] & 0xFF;
        buffer = this.validateTargetBuffer(cmd, buffer);
        if (ignoreBuf != null) {
            ignoreBuf = this.encode(ignoreBuf);
            IoSession networkSession = this.getIoSession();
            networkSession.writeBuffer(ignoreBuf);
        }
        return this.encode(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IoWriteFuture doWritePacket(Buffer buffer) throws IOException {
        Object object = this.encodeLock;
        synchronized (object) {
            Buffer packet = this.resolveOutputPacket(buffer);
            IoSession networkSession = this.getIoSession();
            IoWriteFuture future = networkSession.writeBuffer(packet);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int resolveIgnoreBufferDataLength() {
        if (!this.initialKexDone || this.ignorePacketDataLength <= 0 || this.ignorePacketsFrequency <= 0L || this.ignorePacketsVariance < 0) {
            return 0;
        }
        long count = this.ignorePacketsCount.decrementAndGet();
        if (count > 0L) {
            return 0;
        }
        Random random = this.random;
        synchronized (random) {
            count = this.calculateNextIgnorePacketCount(this.random, this.ignorePacketsFrequency, this.ignorePacketsVariance);
            this.ignorePacketsCount.set(count);
            return this.ignorePacketDataLength + this.random.random(this.ignorePacketDataLength);
        }
    }

    private boolean wantReply(Buffer buffer) {
        int rpos = buffer.rpos();
        buffer.getByte();
        buffer.getString();
        boolean replyFlag = buffer.getBoolean();
        buffer.rpos(rpos);
        return replyFlag;
    }

    @Override
    public Buffer request(String request, Buffer buffer, long maxWaitMillis) throws IOException {
        Object result;
        ValidateUtils.checkTrue(maxWaitMillis > 0L, "Requested timeout for " + request + " is not strictly greater than zero: " + maxWaitMillis);
        boolean debugEnabled = this.log.isDebugEnabled();
        boolean withReply = this.wantReply(buffer);
        GlobalRequestFuture future = this.request(buffer, request, null);
        boolean done = false;
        try {
            if (debugEnabled) {
                this.log.debug("request({}) request={}, timeout={}ms", new Object[]{this, request, maxWaitMillis});
            }
            done = future.await(maxWaitMillis);
            result = future.getValue();
        }
        catch (InterruptedIOException e) {
            throw (InterruptedIOException)new InterruptedIOException("Interrupted while waiting for request=" + request + " result").initCause(e);
        }
        if (!this.isOpen()) {
            throw new IOException("Session was closed or closing while awaiting reply for request=" + request);
        }
        if (withReply) {
            if (debugEnabled) {
                this.log.debug("request({}) request={}, timeout={}ms, requestSeqNo={}, done {}, result received={}", new Object[]{this, request, maxWaitMillis, future.getSequenceNumber(), done, result instanceof Buffer});
            }
            if (!done || result == null) {
                throw new SocketTimeoutException("No response received after " + maxWaitMillis + "ms for request=" + request);
            }
            if (result instanceof GlobalRequestException) {
                if (debugEnabled) {
                    this.log.debug("request({}) request={}, requestSeqNo={}: received={}", new Object[]{this, request, future.getSequenceNumber(), SshConstants.getCommandMessageName(((GlobalRequestException)result).getCode())});
                }
                return null;
            }
        }
        if (result instanceof Throwable) {
            throw new IOException("Exception on request " + request, (Throwable)result);
        }
        if (result instanceof Buffer) {
            return (Buffer)result;
        }
        return null;
    }

    @Override
    public GlobalRequestFuture request(Buffer buffer, String request, GlobalRequestFuture.ReplyHandler replyHandler) throws IOException {
        if (!this.wantReply(buffer)) {
            if (!this.isOpen()) {
                throw new IOException("Global request " + request + ": session is closing or closed.");
            }
            GlobalRequestFuture globalRequest = new GlobalRequestFuture(request, replyHandler){

                @Override
                public void operationComplete(IoWriteFuture future) {
                    if (future.isWritten()) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("makeGlobalRequest({})[{}] want-reply=false sent", (Object)this, (Object)this.getId());
                        }
                        this.setValue(new ByteArrayBuffer(new byte[0]));
                        GlobalRequestFuture.ReplyHandler handler = this.getHandler();
                        if (handler != null) {
                            handler.accept(81, this.getBuffer());
                        }
                    }
                    super.operationComplete(future);
                }
            };
            this.writePacket(buffer).addListener(globalRequest);
            return globalRequest;
        }
        GlobalRequestFuture globalRequest = new GlobalRequestFuture(request, replyHandler){

            @Override
            public void operationComplete(IoWriteFuture future) {
                if (!future.isWritten()) {
                    AbstractSession.this.pendingGlobalRequests.removeFirstOccurrence(this);
                }
                super.operationComplete(future);
                if (future.isWritten() && this.getHandler() != null) {
                    this.setValue(null);
                }
            }
        };
        if (!this.isOpen()) {
            throw new IOException("Global request " + request + ": session is closing or closed.");
        }
        this.globalSequenceNumbers.put(buffer, seqNo -> {
            globalRequest.setSequenceNumber(seqNo);
            if (this.log.isDebugEnabled()) {
                this.log.debug("makeGlobalRequest({})[{}] want-reply=true with seqNo={}", new Object[]{this, globalRequest.getId(), seqNo});
            }
            this.pendingGlobalRequests.push(globalRequest);
        });
        this.writePacket(buffer).addListener(f -> {
            Throwable t = f.getException();
            if (t != null) {
                this.globalSequenceNumbers.remove(buffer);
            }
        }).addListener(globalRequest);
        return globalRequest;
    }

    @Override
    protected boolean doInvokeUnimplementedMessageHandler(int cmd, Buffer buffer) throws Exception {
        if (!this.pendingGlobalRequests.isEmpty() && cmd == 3) {
            long msgSeqNo = buffer.rawUInt(buffer.rpos());
            GlobalRequestFuture future = this.pendingGlobalRequests.stream().filter(f -> f.getSequenceNumber() == msgSeqNo).findAny().orElse(null);
            if (future != null && this.pendingGlobalRequests.removeFirstOccurrence(future)) {
                GlobalRequestFuture.ReplyHandler handler;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("doInvokeUnimplementedMessageHandler({}) report global request={} failure for seqNo={}", new Object[]{this, future.getId(), msgSeqNo});
                }
                if ((handler = future.getHandler()) != null) {
                    ByteArrayBuffer resultBuf = ByteArrayBuffer.getCompactClone(buffer.array(), buffer.rpos(), buffer.available());
                    handler.accept(cmd, resultBuf);
                } else {
                    future.setValue(new GlobalRequestException(cmd));
                }
                return true;
            }
            if (future != null) {
                return true;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("doInvokeUnimplementedMessageHandler({}) SSH_MSG_UNIMPLEMENTED with message seqNo={} not for a global request", (Object)this, (Object)msgSeqNo);
            }
        }
        return super.doInvokeUnimplementedMessageHandler(cmd, buffer);
    }

    @Override
    public Buffer createBuffer(byte cmd, int len) {
        if (len <= 0) {
            return this.prepareBuffer(cmd, new ByteArrayBuffer());
        }
        boolean etmMode = this.outMac != null && this.outMac.isEncryptThenMac();
        int authLen = this.outCipher != null ? this.outCipher.getAuthenticationTagSize() : 0;
        boolean authMode = authLen > 0;
        int pad = AbstractSession.calculatePadLength(len, this.outCipherSize, etmMode || authMode);
        len += 5 + pad + authLen;
        if (this.outMac != null) {
            len += this.outMacSize;
        }
        return this.prepareBuffer(cmd, new ByteArrayBuffer(new byte[len + 8], false));
    }

    @Override
    public Buffer prepareBuffer(byte cmd, Buffer buffer) {
        buffer = this.validateTargetBuffer(cmd & 0xFF, buffer);
        buffer.rpos(5);
        buffer.wpos(5);
        buffer.putByte(cmd);
        return buffer;
    }

    protected <B extends Buffer> B validateTargetBuffer(int cmd, B buffer) {
        ValidateUtils.checkNotNull(buffer, "No target buffer to examine for command=%d", cmd);
        ValidateUtils.checkTrue(buffer != this.decoderBuffer, "Not allowed to use the internal decoder buffer for command=%d", cmd);
        ValidateUtils.checkTrue(buffer != this.uncompressBuffer, "Not allowed to use the internal uncompress buffer for command=%d", cmd);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Buffer encode(Buffer buffer) throws IOException {
        try {
            int newCmd;
            int curPos = buffer.rpos();
            int cmd = buffer.rawByte(curPos) & 0xFF;
            Buffer nb = this.preProcessEncodeBuffer(cmd, buffer);
            if (nb != buffer && cmd != (newCmd = (buffer = nb).rawByte(curPos = buffer.rpos()) & 0xFF)) {
                this.log.warn("encode({}) - command changed from {}[{}] to {}[{}] by pre-processor", new Object[]{this, cmd, SshConstants.getCommandMessageName(cmd), newCmd, SshConstants.getCommandMessageName(newCmd)});
                cmd = newCmd;
            }
            int len = buffer.available();
            if (this.log.isDebugEnabled()) {
                this.log.debug("encode({}) packet #{} sending command={}[{}] len={}", new Object[]{this, this.seqo, cmd, SshConstants.getCommandMessageName(cmd), len});
            }
            int off = curPos - 5;
            boolean traceEnabled = this.log.isTraceEnabled();
            if (traceEnabled) {
                buffer.dumpHex(this.getSimplifiedLogger(), Level.FINEST, "encode(" + this + ") packet #" + this.seqo, this);
            }
            if (this.outCompression != null && this.outCompression.isCompressionExecuted() && (this.isAuthenticated() || !this.outCompression.isDelayed())) {
                int oldLen = len;
                this.outCompression.compress(buffer);
                len = buffer.available();
                if (traceEnabled) {
                    this.log.trace("encode({}) packet #{} command={}[{}] compressed {} -> {}", new Object[]{this, this.seqo, cmd, SshConstants.getCommandMessageName(cmd), oldLen, len});
                }
            }
            boolean etmMode = this.outMac != null && this.outMac.isEncryptThenMac();
            int authSize = this.outCipher != null ? this.outCipher.getAuthenticationTagSize() : 0;
            boolean authMode = authSize > 0;
            int oldLen = len;
            int pad = AbstractSession.calculatePadLength(len, this.outCipherSize, etmMode || authMode);
            len += 1 + pad;
            if (traceEnabled) {
                this.log.trace("encode({}) packet #{} command={}[{}] len={}, pad={}, mac={}", new Object[]{this, this.seqo, cmd, SshConstants.getCommandMessageName(cmd), len, pad, this.outMac});
            }
            buffer.wpos(off);
            buffer.putUInt(len);
            buffer.putByte((byte)pad);
            buffer.wpos(off + oldLen + 5 + pad);
            Random random = this.random;
            synchronized (random) {
                this.random.fill(buffer.array(), buffer.wpos() - pad, pad);
            }
            if (authMode) {
                int wpos = buffer.wpos();
                buffer.wpos(wpos + authSize);
                this.aeadOutgoingBuffer(buffer, off, len);
            } else if (etmMode) {
                this.encryptOutgoingBuffer(buffer, off + 4, len);
                this.appendOutgoingMac(buffer, off, len);
            } else {
                this.appendOutgoingMac(buffer, off, len);
                this.encryptOutgoingBuffer(buffer, off, len + 4);
            }
            this.seqo = this.seqo + 1L & 0xFFFFFFFFL;
            this.outPacketsCount.incrementAndGet();
            this.outBytesCount.addAndGet(len);
            buffer.rpos(off);
            return buffer;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    protected void aeadOutgoingBuffer(Buffer buf, int offset, int len) throws Exception {
        if (this.outCipher == null || this.outCipher.getAuthenticationTagSize() == 0) {
            throw new IllegalArgumentException("AEAD mode requires an AEAD cipher");
        }
        byte[] data = buf.array();
        this.outCipher.updateWithAAD(data, offset, 4, len);
        int blocksCount = len / this.outCipherSize;
        this.outBlocksCount.addAndGet(Math.max(1, blocksCount));
    }

    protected void appendOutgoingMac(Buffer buf, int offset, int len) throws Exception {
        if (this.outMac == null) {
            return;
        }
        int l = buf.wpos();
        buf.wpos(l + this.outMacSize);
        this.outMac.updateUInt(this.seqo);
        this.outMac.update(buf.array(), offset, len + 4);
        this.outMac.doFinal(buf.array(), l);
    }

    protected void encryptOutgoingBuffer(Buffer buf, int offset, int len) throws Exception {
        if (this.outCipher == null) {
            return;
        }
        this.outCipher.update(buf.array(), offset, len);
        int blocksCount = len / this.outCipherSize;
        this.outBlocksCount.addAndGet(Math.max(1, blocksCount));
    }

    protected void decode() throws Exception {
        while (true) {
            SessionWorkBuffer packet;
            int blocksCount;
            boolean etmMode;
            int authSize = this.inCipher != null ? this.inCipher.getAuthenticationTagSize() : 0;
            boolean authMode = authSize > 0;
            int macSize = this.inMac != null ? this.inMacSize : 0;
            boolean bl = etmMode = this.inMac != null && this.inMac.isEncryptThenMac();
            if (this.decoderState == 0) {
                int minBufLen;
                assert (this.decoderBuffer.rpos() == 0);
                int n = minBufLen = etmMode || authMode ? 4 : this.inCipherSize;
                if (this.decoderBuffer.available() <= minBufLen) break;
                if (authMode) {
                    this.inCipher.updateAAD(this.decoderBuffer.array(), 0, 4);
                } else if (this.inCipher != null && !etmMode) {
                    this.inCipher.update(this.decoderBuffer.array(), 0, this.inCipherSize);
                    this.inBlocksCount.incrementAndGet();
                }
                this.decoderLength = this.decoderBuffer.getInt();
                boolean lengthOK = true;
                if (this.decoderLength < 5 || this.decoderLength > 262144) {
                    this.log.warn("decode({}) Error decoding packet(invalid length): {}", (Object)this, (Object)this.decoderLength);
                    lengthOK = false;
                } else if (this.inCipher != null && (this.decoderLength + (authMode || etmMode ? 0 : 4)) % this.inCipherSize != 0) {
                    this.log.warn("decode({}) Error decoding packet(padding; not multiple of {}): {}", new Object[]{this, this.inCipherSize, this.decoderLength});
                    lengthOK = false;
                }
                if (!lengthOK) {
                    this.decoderBuffer.dumpHex(this.getSimplifiedLogger(), Level.FINEST, "decode(" + this + ") invalid length packet", this);
                    this.discarding = new SshException(2, "Invalid packet length: " + this.decoderLength);
                    this.decoderLength = this.decoderBuffer.available() + (2 + this.random.random(20)) * this.inCipherSize;
                    this.decoderLength = (this.decoderLength + (this.inCipherSize - 1)) / this.inCipherSize * this.inCipherSize;
                    if (!authMode && !etmMode) {
                        this.decoderLength -= 4;
                    }
                    this.log.warn("decode({}) Invalid packet length; requesting {} bytes before disconnecting", (Object)this, (Object)(this.decoderLength - this.decoderBuffer.available()));
                }
                this.decoderState = 1;
                continue;
            }
            if (this.decoderState != 1) continue;
            assert (this.decoderBuffer.rpos() == 4);
            if (this.decoderBuffer.available() < this.decoderLength + macSize + authSize) break;
            byte[] data = this.decoderBuffer.array();
            if (authMode) {
                this.inCipher.update(data, 4, this.decoderLength);
                blocksCount = this.decoderLength / this.inCipherSize;
                this.inBlocksCount.addAndGet(Math.max(1, blocksCount));
            } else if (etmMode) {
                this.validateIncomingMac(data, 0, this.decoderLength + 4);
                if (this.inCipher != null) {
                    this.inCipher.update(data, 4, this.decoderLength);
                    blocksCount = this.decoderLength / this.inCipherSize;
                    this.inBlocksCount.addAndGet(Math.max(1, blocksCount));
                }
            } else {
                if (this.inCipher != null) {
                    int updateLen = this.decoderLength + 4 - this.inCipherSize;
                    this.inCipher.update(data, this.inCipherSize, updateLen);
                    int blocksCount2 = updateLen / this.inCipherSize;
                    this.inBlocksCount.addAndGet(Math.max(1, blocksCount2));
                }
                this.validateIncomingMac(data, 0, this.decoderLength + 4);
            }
            if (this.discarding != null) {
                throw new SshException(2, (Throwable)this.discarding);
            }
            this.seqi = this.seqi + 1L & 0xFFFFFFFFL;
            int pad = this.decoderBuffer.getUByte();
            int wpos = this.decoderBuffer.wpos();
            if (this.inCompression != null && this.inCompression.isCompressionExecuted() && (this.isAuthenticated() || !this.inCompression.isDelayed())) {
                if (this.uncompressBuffer == null) {
                    this.uncompressBuffer = new SessionWorkBuffer(this);
                } else {
                    this.uncompressBuffer.forceClear(true);
                }
                this.decoderBuffer.wpos(this.decoderBuffer.rpos() + this.decoderLength - 1 - pad);
                this.inCompression.uncompress(this.decoderBuffer, this.uncompressBuffer);
                packet = this.uncompressBuffer;
            } else {
                this.decoderBuffer.wpos(this.decoderLength + 4 - pad);
                packet = this.decoderBuffer;
            }
            if (this.log.isTraceEnabled()) {
                packet.dumpHex(this.getSimplifiedLogger(), Level.FINEST, "decode(" + this + ") packet #" + this.seqi, this);
            }
            this.inPacketsCount.incrementAndGet();
            this.inBytesCount.addAndGet(packet.available());
            this.handleMessage(packet);
            this.decoderBuffer.rpos(this.decoderLength + 4 + macSize + authSize);
            this.decoderBuffer.wpos(wpos);
            this.decoderBuffer.compact();
            this.decoderState = 0;
        }
    }

    protected void validateIncomingMac(byte[] data, int offset, int len) throws Exception {
        if (this.inMac == null) {
            return;
        }
        this.inMac.updateUInt(this.seqi);
        this.inMac.update(data, offset, len);
        this.inMac.doFinal(this.inMacResult, 0);
        if (!Mac.equals(this.inMacResult, 0, data, offset + len, this.inMacSize)) {
            throw new SshException(5, "MAC Error");
        }
    }

    protected abstract boolean readIdentification(Buffer var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendKexInit(Map<KexProposalOption, String> proposal) throws Exception {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("sendKexInit({}) Send SSH_MSG_KEXINIT", (Object)this);
        }
        Buffer buffer = this.createBuffer((byte)20);
        int p = buffer.wpos();
        buffer.wpos(p + 16);
        Random random = this.random;
        synchronized (random) {
            this.random.fill(buffer.array(), p, 16);
        }
        boolean traceEnabled = this.log.isTraceEnabled();
        if (traceEnabled) {
            this.log.trace("sendKexInit({}) cookie={}", (Object)this, (Object)BufferUtils.toHex(buffer.array(), p, 16, ':'));
        }
        for (KexProposalOption paramType : KexProposalOption.VALUES) {
            String s = proposal.get((Object)paramType);
            if (traceEnabled) {
                this.log.trace("sendKexInit({})[{}] {}", new Object[]{this, paramType.getDescription(), s});
            }
            buffer.putString(GenericUtils.trimToEmpty(s));
        }
        buffer.putBoolean(false);
        buffer.putUInt(0L);
        ReservedSessionMessagesHandler handler = this.getReservedSessionMessagesHandler();
        IoWriteFuture future = handler == null ? null : handler.sendKexInitRequest(this, proposal, buffer);
        byte[] data = buffer.getCompactData();
        if (future == null) {
            this.writePacket(buffer);
        } else if (debugEnabled) {
            this.log.debug("sendKexInit({}) KEX handled by reserved messages handler", (Object)this);
        }
        return data;
    }

    protected byte[] receiveKexInit(Buffer buffer, Map<KexProposalOption, String> proposal) throws Exception {
        long reserved;
        byte[] d = buffer.array();
        byte[] data = new byte[buffer.available() + 1];
        data[0] = 20;
        int size = 6;
        int cookieStartPos = buffer.rpos();
        System.arraycopy(d, cookieStartPos, data, 1, data.length - 1);
        buffer.rpos(cookieStartPos + 16);
        size += 16;
        boolean traceEnabled = this.log.isTraceEnabled();
        if (traceEnabled) {
            this.log.trace("receiveKexInit({}) cookie={}", (Object)this, (Object)BufferUtils.toHex(d, cookieStartPos, 16, ':'));
        }
        for (KexProposalOption paramType : KexProposalOption.VALUES) {
            int lastPos = buffer.rpos();
            String value = buffer.getString();
            if (traceEnabled) {
                this.log.trace("receiveKexInit({})[{}] {}", new Object[]{this, paramType.getDescription(), value});
            }
            int curPos = buffer.rpos();
            int readLen = curPos - lastPos;
            proposal.put(paramType, value);
            size += readLen;
        }
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        if (extHandler != null) {
            if (traceEnabled) {
                this.log.trace("receiveKexInit({}) options before handler: {}", (Object)this, proposal);
            }
            extHandler.handleKexInitProposal(this, false, proposal);
            if (traceEnabled) {
                this.log.trace("receiveKexInit({}) options after handler: {}", (Object)this, proposal);
            }
        }
        this.firstKexPacketFollows = buffer.getBoolean();
        if (traceEnabled) {
            this.log.trace("receiveKexInit({}) first kex packet follows: {}", (Object)this, (Object)this.firstKexPacketFollows);
        }
        if ((reserved = buffer.getUInt()) != 0L && traceEnabled) {
            this.log.trace("receiveKexInit({}) non-zero reserved value: {}", (Object)this, (Object)reserved);
        }
        byte[] dataShrinked = new byte[size];
        System.arraycopy(data, 0, dataShrinked, 0, size);
        return dataShrinked;
    }

    protected void prepareNewKeys() throws Exception {
        Mac c2smac;
        Mac s2cmac;
        int j;
        byte[] k = this.kex.getK();
        byte[] h = this.kex.getH();
        Digest hash = this.kex.getHash();
        boolean debugEnabled = this.log.isDebugEnabled();
        if (this.sessionId == null) {
            this.sessionId = (byte[])h.clone();
            if (debugEnabled) {
                this.log.debug("prepareNewKeys({}) session ID={}", (Object)this, (Object)BufferUtils.toHex(':', this.sessionId));
            }
        }
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        buffer.putBytes(k);
        buffer.putRawBytes(h);
        ((Buffer)buffer).putByte((byte)65);
        buffer.putRawBytes(this.sessionId);
        int pos = buffer.available();
        byte[] buf = ((Buffer)buffer).array();
        hash.update(buf, 0, pos);
        byte[] iv_c2s = hash.digest();
        int n = j = pos - this.sessionId.length - 1;
        buf[n] = (byte)(buf[n] + 1);
        hash.update(buf, 0, pos);
        byte[] iv_s2c = hash.digest();
        int n2 = j;
        buf[n2] = (byte)(buf[n2] + 1);
        hash.update(buf, 0, pos);
        byte[] e_c2s = hash.digest();
        int n3 = j;
        buf[n3] = (byte)(buf[n3] + 1);
        hash.update(buf, 0, pos);
        byte[] e_s2c = hash.digest();
        int n4 = j;
        buf[n4] = (byte)(buf[n4] + 1);
        hash.update(buf, 0, pos);
        byte[] mac_c2s = hash.digest();
        int n5 = j;
        buf[n5] = (byte)(buf[n5] + 1);
        hash.update(buf, 0, pos);
        byte[] mac_s2c = hash.digest();
        boolean serverSession = this.isServerSession();
        String value = this.getNegotiatedKexParameter(KexProposalOption.S2CENC);
        Cipher s2ccipher = ValidateUtils.checkNotNull(NamedFactory.create(this.getCipherFactories(), value), "Unknown s2c cipher: %s", (Object)value);
        e_s2c = this.resizeKey(e_s2c, s2ccipher.getKdfSize(), hash, k, h);
        if (s2ccipher.getAuthenticationTagSize() == 0) {
            value = this.getNegotiatedKexParameter(KexProposalOption.S2CMAC);
            s2cmac = NamedFactory.create(this.getMacFactories(), value);
            if (s2cmac == null) {
                throw new SshException(5, "Unknown s2c MAC: " + value);
            }
            mac_s2c = this.resizeKey(mac_s2c, s2cmac.getBlockSize(), hash, k, h);
            s2cmac.init(mac_s2c);
        } else {
            s2cmac = null;
        }
        value = this.getNegotiatedKexParameter(KexProposalOption.S2CCOMP);
        Compression s2ccomp = NamedFactory.create(this.getCompressionFactories(), value);
        if (s2ccomp == null) {
            throw new SshException(6, "Unknown s2c compression: " + value);
        }
        value = this.getNegotiatedKexParameter(KexProposalOption.C2SENC);
        Cipher c2scipher = ValidateUtils.checkNotNull(NamedFactory.create(this.getCipherFactories(), value), "Unknown c2s cipher: %s", (Object)value);
        e_c2s = this.resizeKey(e_c2s, c2scipher.getKdfSize(), hash, k, h);
        if (c2scipher.getAuthenticationTagSize() == 0) {
            value = this.getNegotiatedKexParameter(KexProposalOption.C2SMAC);
            c2smac = NamedFactory.create(this.getMacFactories(), value);
            if (c2smac == null) {
                throw new SshException(5, "Unknown c2s MAC: " + value);
            }
            mac_c2s = this.resizeKey(mac_c2s, c2smac.getBlockSize(), hash, k, h);
            c2smac.init(mac_c2s);
        } else {
            c2smac = null;
        }
        value = this.getNegotiatedKexParameter(KexProposalOption.C2SCOMP);
        Compression c2scomp = NamedFactory.create(this.getCompressionFactories(), value);
        if (c2scomp == null) {
            throw new SshException(6, "Unknown c2s compression: " + value);
        }
        if (serverSession) {
            this.outSettings = new MessageCodingSettings(s2ccipher, s2cmac, s2ccomp, Cipher.Mode.Encrypt, e_s2c, iv_s2c);
            this.inSettings = new MessageCodingSettings(c2scipher, c2smac, c2scomp, Cipher.Mode.Decrypt, e_c2s, iv_c2s);
        } else {
            this.outSettings = new MessageCodingSettings(c2scipher, c2smac, c2scomp, Cipher.Mode.Encrypt, e_c2s, iv_c2s);
            this.inSettings = new MessageCodingSettings(s2ccipher, s2cmac, s2ccomp, Cipher.Mode.Decrypt, e_s2c, iv_s2c);
        }
    }

    protected void setOutputEncoding() throws Exception {
        if (this.strictKex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("setOutputEncoding({}): strict KEX resets output message sequence number from {} to 0", (Object)this, (Object)this.seqo);
            }
            this.seqo = 0L;
        }
        this.outCipher = this.outSettings.getCipher(this.seqo);
        this.outMac = this.outSettings.getMac();
        this.outCompression = this.outSettings.getCompression();
        this.outSettings = null;
        this.outCipherSize = this.outCipher.getCipherBlockSize();
        this.outMacSize = this.outMac != null ? this.outMac.getBlockSize() : 0;
        this.outCompression.init(Compression.Type.Deflater, -1);
        this.maxRekeyBlocks.set(this.determineRekeyBlockLimit(this.inCipherSize, this.outCipherSize));
        this.outBytesCount.set(0L);
        this.outPacketsCount.set(0L);
        this.outBlocksCount.set(0L);
        this.lastKeyTimeValue.set(Instant.now());
        this.firstKexPacketFollows = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("setOutputEncoding({}): cipher {}; mac {}; compression {}; blocks limit {}", new Object[]{this, this.outCipher, this.outMac, this.outCompression, this.maxRekeyBlocks});
        }
    }

    protected void setInputEncoding() throws Exception {
        if (this.strictKex) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("setInputEncoding({}): strict KEX resets input message sequence number from {} to 0", (Object)this, (Object)this.seqi);
            }
            this.seqi = 0L;
        }
        this.inCipher = this.inSettings.getCipher(this.seqi);
        this.inMac = this.inSettings.getMac();
        this.inCompression = this.inSettings.getCompression();
        this.inSettings = null;
        this.inCipherSize = this.inCipher.getCipherBlockSize();
        this.inMacSize = this.inMac != null ? this.inMac.getBlockSize() : 0;
        this.inMacResult = new byte[this.inMacSize];
        this.inCompression.init(Compression.Type.Inflater, -1);
        this.maxRekeyBlocks.set(this.determineRekeyBlockLimit(this.inCipherSize, this.outCipherSize));
        this.inBytesCount.set(0L);
        this.inPacketsCount.set(0L);
        this.inBlocksCount.set(0L);
        this.lastKeyTimeValue.set(Instant.now());
        this.firstKexPacketFollows = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("setInputEncoding({}): cipher {}; mac {}; compression {}; blocks limit {}", new Object[]{this, this.inCipher, this.inMac, this.inCompression, this.maxRekeyBlocks});
        }
    }

    protected long determineRekeyBlockLimit(int inCipherBlockSize, int outCipherBlockSize) {
        long rekeyBlocksLimit = CoreModuleProperties.REKEY_BLOCKS_LIMIT.getRequired(this);
        if (rekeyBlocksLimit <= 0L) {
            int minCipherBlockBytes = Math.min(this.inCipherSize, this.outCipherSize);
            rekeyBlocksLimit = minCipherBlockBytes >= 16 ? 1L << Math.min(minCipherBlockBytes * 2, 63) : 0x40000000L / (long)minCipherBlockBytes;
        }
        return rekeyBlocksLimit;
    }

    protected IoWriteFuture notImplemented(int cmd, Buffer buffer) throws Exception {
        if (this.doInvokeUnimplementedMessageHandler(cmd, buffer)) {
            return null;
        }
        return this.sendNotImplemented(this.seqi - 1L);
    }

    protected boolean removeValue(Map<KexProposalOption, String> options, KexProposalOption option, String toRemove) {
        String val = options.get((Object)option);
        LinkedHashSet<String> algorithms = new LinkedHashSet<String>(Arrays.asList(val.split(",")));
        boolean result = algorithms.remove(toRemove);
        if (result) {
            options.put(option, algorithms.stream().collect(Collectors.joining(",")));
        }
        return result;
    }

    protected Map<KexProposalOption, String> negotiate() throws Exception {
        Map<KexProposalOption, String> negotiatedGuess;
        EnumMap<KexProposalOption, String> guess;
        Map<KexProposalOption, String> s2cOptions;
        Map<KexProposalOption, String> c2sOptions;
        block18: {
            c2sOptions = this.getClientKexProposals();
            s2cOptions = this.getServerKexProposals();
            this.signalNegotiationStart(c2sOptions, s2cOptions);
            c2sOptions = new EnumMap<KexProposalOption, String>(c2sOptions);
            s2cOptions = new EnumMap<KexProposalOption, String>(s2cOptions);
            boolean strictKexClient = this.removeValue(c2sOptions, KexProposalOption.ALGORITHMS, "kex-strict-c-v00@openssh.com");
            boolean strictKexServer = this.removeValue(s2cOptions, KexProposalOption.ALGORITHMS, "kex-strict-s-v00@openssh.com");
            if (this.removeValue(c2sOptions, KexProposalOption.ALGORITHMS, "kex-strict-s-v00@openssh.com") && !this.initialKexDone) {
                this.log.warn("negotiate({}) client proposal contains server flag {}; will be ignored", (Object)this, (Object)"kex-strict-s-v00@openssh.com");
            }
            if (this.removeValue(s2cOptions, KexProposalOption.ALGORITHMS, "kex-strict-c-v00@openssh.com") && !this.initialKexDone) {
                this.log.warn("negotiate({}) server proposal contains client flag {}; will be ignored", (Object)this, (Object)"kex-strict-c-v00@openssh.com");
            }
            c2sOptions = Collections.unmodifiableMap(c2sOptions);
            s2cOptions = Collections.unmodifiableMap(s2cOptions);
            guess = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
            negotiatedGuess = Collections.unmodifiableMap(guess);
            try {
                boolean debugEnabled = this.log.isDebugEnabled();
                boolean traceEnabled = this.log.isTraceEnabled();
                if (!this.initialKexDone) {
                    boolean bl = this.strictKex = strictKexClient && strictKexServer;
                    if (debugEnabled) {
                        this.log.debug("negotiate({}) strict KEX={} client={} server={}", new Object[]{this, this.strictKex, strictKexClient, strictKexServer});
                    }
                    if (this.strictKex && this.initialKexInitSequenceNumber != 1L) {
                        throw new SshException(3, "Strict KEX negotiated but sequence number of first KEX_INIT received is not 1: " + this.initialKexInitSequenceNumber);
                    }
                }
                SessionDisconnectHandler discHandler = this.getSessionDisconnectHandler();
                KexExtensionHandler extHandler = this.getKexExtensionHandler();
                for (KexProposalOption paramType : KexProposalOption.VALUES) {
                    String clientParamValue = c2sOptions.get((Object)paramType);
                    String serverParamValue = s2cOptions.get((Object)paramType);
                    String[] c = GenericUtils.split(clientParamValue, ',');
                    String[] s = GenericUtils.split(serverParamValue, ',');
                    for (String ci : c) {
                        String value;
                        for (String si : s) {
                            if (!ci.equals(si)) continue;
                            guess.put(paramType, ci);
                            break;
                        }
                        if ((value = (String)guess.get((Object)paramType)) != null) break;
                    }
                    String value = (String)guess.get((Object)paramType);
                    if (extHandler != null) {
                        extHandler.handleKexExtensionNegotiation(this, paramType, value, c2sOptions, clientParamValue, s2cOptions, serverParamValue);
                    }
                    if (value != null) {
                        if (!traceEnabled) continue;
                        this.log.trace("negotiate({})[{}] guess={} (client={} / server={})", new Object[]{this, paramType.getDescription(), value, clientParamValue, serverParamValue});
                        continue;
                    }
                    try {
                        if (discHandler != null && discHandler.handleKexDisconnectReason(this, c2sOptions, s2cOptions, negotiatedGuess, paramType)) {
                            if (!debugEnabled) continue;
                            this.log.debug("negotiate({}) ignore missing value for KEX option={}", (Object)this, (Object)paramType);
                            continue;
                        }
                    }
                    catch (IOException | RuntimeException e) {
                        this.debug("negotiate({}) failed ({}) to invoke disconnect handler due to mismatched KEX option={}: {}", this, e.getClass().getSimpleName(), (Object)paramType, e.getMessage(), e);
                    }
                    String message = "Unable to negotiate key exchange for " + paramType.getDescription() + " (client: " + clientParamValue + " / server: " + serverParamValue + ")";
                    if (KexProposalOption.S2CLANG.equals((Object)paramType) || KexProposalOption.C2SLANG.equals((Object)paramType)) {
                        if (!traceEnabled) continue;
                        this.log.trace("negotiate({}) {}", (Object)this, (Object)message);
                        continue;
                    }
                    throw new SshException(3, message);
                }
                String kexOption = (String)guess.get((Object)KexProposalOption.ALGORITHMS);
                if (!KexExtensions.IS_KEX_EXTENSION_SIGNAL.test(kexOption)) break block18;
                if (discHandler != null && discHandler.handleKexDisconnectReason(this, c2sOptions, s2cOptions, negotiatedGuess, KexProposalOption.ALGORITHMS)) {
                    if (debugEnabled) {
                        this.log.debug("negotiate({}) ignore violating {} KEX option={}", new Object[]{this, KexProposalOption.ALGORITHMS, kexOption});
                    }
                    break block18;
                }
                throw new SshException(3, "Illegal KEX option negotiated: " + kexOption);
            }
            catch (IOException | Error | RuntimeException e) {
                this.signalNegotiationEnd(c2sOptions, s2cOptions, negotiatedGuess, e);
                throw e;
            }
        }
        this.signalNegotiationEnd(c2sOptions, s2cOptions, negotiatedGuess, null);
        return this.setNegotiationResult(guess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<KexProposalOption, String> setNegotiationResult(Map<KexProposalOption, String> guess) {
        Map<KexProposalOption, String> map = this.negotiationResult;
        synchronized (map) {
            if (!this.negotiationResult.isEmpty()) {
                this.negotiationResult.clear();
            }
            this.negotiationResult.putAll(guess);
        }
        if (this.log.isDebugEnabled()) {
            guess.forEach((option, value) -> this.log.debug("setNegotiationResult({}) Kex: {} = {}", new Object[]{this, option.getDescription(), value}));
        }
        return guess;
    }

    protected void requestSuccess(Buffer buffer) throws Exception {
        this.resetIdleTimeout();
        GlobalRequestFuture request = this.pendingGlobalRequests.pollLast();
        if (request != null) {
            ByteArrayBuffer resultBuf = ByteArrayBuffer.getCompactClone(buffer.array(), buffer.rpos(), buffer.available());
            GlobalRequestFuture.ReplyHandler handler = request.getHandler();
            if (handler != null) {
                handler.accept(81, resultBuf);
            } else {
                request.setValue(resultBuf);
            }
        }
    }

    protected void requestFailure(Buffer buffer) throws Exception {
        this.resetIdleTimeout();
        GlobalRequestFuture request = this.pendingGlobalRequests.pollLast();
        if (request != null) {
            GlobalRequestFuture.ReplyHandler handler = request.getHandler();
            if (handler != null) {
                ByteArrayBuffer resultBuf = ByteArrayBuffer.getCompactClone(buffer.array(), buffer.rpos(), buffer.available());
                handler.accept(82, resultBuf);
            } else {
                request.setValue(new GlobalRequestException(82));
            }
        }
    }

    @Override
    public void addSessionListener(SessionListener listener) {
        SessionListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addSessionListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.sessionListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addSessionListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addSessionListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removeSessionListener(SessionListener listener) {
        if (listener == null) {
            return;
        }
        SessionListener.validateListener(listener);
        if (this.sessionListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeSessionListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeSessionListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public SessionListener getSessionListenerProxy() {
        return this.sessionListenerProxy;
    }

    @Override
    public void addChannelListener(ChannelListener listener) {
        ChannelListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addChannelListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.channelListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addChannelListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addChannelListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removeChannelListener(ChannelListener listener) {
        if (listener == null) {
            return;
        }
        ChannelListener.validateListener(listener);
        if (this.channelListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removeChannelListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removeChannelListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public ChannelListener getChannelListenerProxy() {
        return this.channelListenerProxy;
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.tunnelListenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        PortForwardingEventListener.validateListener(listener);
        if (!this.isOpen()) {
            this.log.warn("addPortForwardingEventListener({})[{}] ignore registration while session is closing", (Object)this, (Object)listener);
            return;
        }
        if (this.tunnelListeners.add(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("addPortForwardingEventListener({})[{}] registered", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("addPortForwardingEventListener({})[{}] ignored duplicate", (Object)this, (Object)listener);
        }
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        PortForwardingEventListener.validateListener(listener);
        if (this.tunnelListeners.remove(listener)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("removePortForwardingEventListener({})[{}] removed", (Object)this, (Object)listener);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("removePortForwardingEventListener({})[{}] not registered", (Object)this, (Object)listener);
        }
    }

    @Override
    public KeyExchangeFuture reExchangeKeys() throws IOException {
        try {
            this.requestNewKeysExchange();
        }
        catch (GeneralSecurityException e) {
            this.debug("reExchangeKeys({}) failed ({}) to request new keys: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
            throw ValidateUtils.initializeExceptionCause(new ProtocolException("Failed (" + e.getClass().getSimpleName() + ") to generate keys for exchange: " + e.getMessage()), e);
        }
        catch (Exception e) {
            ExceptionUtils.rethrowAsIoException(e);
            return null;
        }
        return ValidateUtils.checkNotNull(this.kexFutureHolder.get(), "No current KEX future on state=%s", this.kexState);
    }

    protected KeyExchangeFuture checkRekey() throws Exception {
        return this.isRekeyRequired() ? this.requestNewKeysExchange() : null;
    }

    protected KeyExchangeFuture requestNewKeysExchange() throws Exception {
        boolean kexRunning = this.kexHandler.updateState(() -> {
            boolean isRunning;
            boolean bl = isRunning = !this.kexState.compareAndSet(KexState.DONE, KexState.INIT);
            if (!isRunning) {
                this.kexHandler.initNewKeyExchange();
            }
            return isRunning;
        });
        if (kexRunning) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("requestNewKeysExchange({}) KEX state not DONE: {}", (Object)this, this.kexState);
            }
            return null;
        }
        this.log.info("requestNewKeysExchange({}) Initiating key re-exchange", (Object)this);
        DefaultKeyExchangeFuture newFuture = new DefaultKeyExchangeFuture(this.toString(), null);
        DefaultKeyExchangeFuture kexFuture = this.kexFutureHolder.getAndSet(newFuture);
        if (kexFuture != null) {
            kexFuture.setValue(new SshException("New KEX started while previous one still ongoing"));
        }
        this.sendKexInit();
        return newFuture;
    }

    protected boolean isRekeyRequired() {
        if (!this.isOpen() || this.isClosing() || this.isClosed()) {
            return false;
        }
        KexState curState = this.kexState.get();
        if (!KexState.DONE.equals((Object)curState)) {
            return false;
        }
        return this.isRekeyTimeIntervalExceeded() || this.isRekeyPacketCountsExceeded() || this.isRekeyBlocksCountExceeded() || this.isRekeyDataSizeExceeded();
    }

    protected boolean isRekeyTimeIntervalExceeded() {
        boolean rekey;
        if (GenericUtils.isNegativeOrNull(this.maxRekeyInterval)) {
            return false;
        }
        Instant now = Instant.now();
        Duration rekeyDiff = Duration.between(this.lastKeyTimeValue.get(), now);
        boolean bl = rekey = rekeyDiff.compareTo(this.maxRekeyInterval) > 0;
        if (rekey && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyTimeIntervalExceeded({}) re-keying: last={}, now={}, diff={}, max={}", new Object[]{this, this.lastKeyTimeValue.get(), now, rekeyDiff, this.maxRekeyInterval});
        }
        return rekey;
    }

    protected boolean isRekeyPacketCountsExceeded() {
        boolean rekey;
        if (this.maxRekyPackets <= 0L) {
            return false;
        }
        boolean bl = rekey = this.inPacketsCount.get() > this.maxRekyPackets || this.outPacketsCount.get() > this.maxRekyPackets;
        if (rekey && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyPacketCountsExceeded({}) re-keying: in={}, out={}, max={}", new Object[]{this, this.inPacketsCount, this.outPacketsCount, this.maxRekyPackets});
        }
        return rekey;
    }

    protected boolean isRekeyDataSizeExceeded() {
        boolean rekey;
        if (this.maxRekeyBytes <= 0L) {
            return false;
        }
        boolean bl = rekey = this.inBytesCount.get() > this.maxRekeyBytes || this.outBytesCount.get() > this.maxRekeyBytes;
        if (rekey && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyDataSizeExceeded({}) re-keying: in={}, out={}, max={}", new Object[]{this, this.inBytesCount, this.outBytesCount, this.maxRekeyBytes});
        }
        return rekey;
    }

    protected boolean isRekeyBlocksCountExceeded() {
        boolean rekey;
        long maxBlocks = this.maxRekeyBlocks.get();
        if (maxBlocks <= 0L) {
            return false;
        }
        boolean bl = rekey = this.inBlocksCount.get() > maxBlocks || this.outBlocksCount.get() > maxBlocks;
        if (rekey && this.log.isDebugEnabled()) {
            this.log.debug("isRekeyBlocksCountExceeded({}) re-keying: in={}, out={}, max={}", new Object[]{this, this.inBlocksCount, this.outBlocksCount, maxBlocks});
        }
        return rekey;
    }

    @Override
    protected String resolveSessionKexProposal(String hostKeyTypes) throws IOException {
        String extType;
        String proposal = super.resolveSessionKexProposal(hostKeyTypes);
        KexExtensionHandler extHandler = this.getKexExtensionHandler();
        if (extHandler == null || !extHandler.isKexExtensionsAvailable(this, KexExtensionHandler.AvailabilityPhase.PROPOSAL)) {
            return proposal;
        }
        String string = extType = this.isServerSession() ? "ext-info-s" : "ext-info-c";
        if (GenericUtils.isEmpty(proposal)) {
            return extType;
        }
        return proposal + "," + extType;
    }

    protected Map<KexProposalOption, String> doStrictKexProposal(Map<KexProposalOption, String> proposal) {
        String askForStrictKex;
        String value = proposal.get((Object)KexProposalOption.ALGORITHMS);
        String string = askForStrictKex = this.isServerSession() ? "kex-strict-s-v00@openssh.com" : "kex-strict-c-v00@openssh.com";
        if (!this.initialKexDone) {
            value = GenericUtils.isEmpty(value) ? askForStrictKex : value + "," + askForStrictKex;
        } else if (!GenericUtils.isEmpty(value)) {
            ArrayList<String> algorithms = new ArrayList<String>(Arrays.asList(value.split(",")));
            String extType = this.isServerSession() ? "ext-info-s" : "ext-info-c";
            boolean changed = algorithms.remove(extType);
            if (changed |= algorithms.remove(askForStrictKex)) {
                value = algorithms.stream().collect(Collectors.joining(","));
            }
        }
        proposal.put(KexProposalOption.ALGORITHMS, value);
        return proposal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] sendKexInit() throws Exception {
        byte[] seed;
        Map<KexProposalOption, String> proposal = this.doStrictKexProposal(this.getKexProposal());
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            DefaultKeyExchangeFuture initFuture = this.kexInitializedFuture;
            if (initFuture == null) {
                this.kexInitializedFuture = initFuture = new DefaultKeyExchangeFuture(this.toString(), null);
            }
            try {
                seed = this.sendKexInit(proposal);
                this.setKexSeed(seed);
                initFuture.setValue(Boolean.TRUE);
            }
            catch (Exception e) {
                initFuture.setValue(e);
                throw e;
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("sendKexInit({}) proposal={} seed: {}", new Object[]{this, proposal, BufferUtils.toHex(':', seed)});
        }
        return seed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getClientKexData() {
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            return this.clientKexData == null ? null : (byte[])this.clientKexData.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClientKexData(byte[] data) {
        ValidateUtils.checkNotNullAndNotEmpty(data, "No client KEX seed");
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            this.clientKexData = (byte[])data.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getServerKexData() {
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            return this.serverKexData == null ? null : (byte[])this.serverKexData.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setServerKexData(byte[] data) {
        ValidateUtils.checkNotNullAndNotEmpty(data, "No server KEX seed");
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            this.serverKexData = (byte[])data.clone();
        }
    }

    protected abstract void setKexSeed(byte ... var1);

    protected abstract void checkKeys() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] receiveKexInit(Buffer buffer) throws Exception {
        byte[] seed;
        EnumMap<KexProposalOption, String> proposal = new EnumMap<KexProposalOption, String>(KexProposalOption.class);
        if (!this.initialKexDone) {
            this.initialKexInitSequenceNumber = this.seqi;
        }
        AtomicReference<KexState> atomicReference = this.kexState;
        synchronized (atomicReference) {
            seed = this.receiveKexInit(buffer, proposal);
            this.receiveKexInit(proposal, seed);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("receiveKexInit({}) proposal={} seed: {}", new Object[]{this, proposal, BufferUtils.toHex(':', seed)});
        }
        return seed;
    }

    protected abstract void receiveKexInit(Map<KexProposalOption, String> var1, byte[] var2) throws IOException;

    public static AbstractSession getSession(IoSession ioSession) throws MissingAttachedSessionException {
        return AbstractSession.getSession(ioSession, false);
    }

    public static void attachSession(IoSession ioSession, AbstractSession session) throws MultipleAttachedSessionException {
        Objects.requireNonNull(ioSession, "No I/O session");
        Objects.requireNonNull(session, "No SSH session");
        Object prev = ioSession.setAttributeIfAbsent(SESSION, session);
        if (prev != null) {
            throw new MultipleAttachedSessionException("Multiple attached session to " + ioSession + ": " + prev + " and " + session);
        }
    }

    public static AbstractSession getSession(IoSession ioSession, boolean allowNull) throws MissingAttachedSessionException {
        AbstractSession session = (AbstractSession)ioSession.getAttribute(SESSION);
        if (session == null && !allowNull) {
            throw new MissingAttachedSessionException("No session attached to " + ioSession);
        }
        return session;
    }

    protected static class MessageCodingSettings {
        private final Cipher cipher;
        private final Mac mac;
        private final Compression compression;
        private final Cipher.Mode mode;
        private byte[] key;
        private byte[] iv;

        public MessageCodingSettings(Cipher cipher, Mac mac, Compression compression, Cipher.Mode mode, byte[] key, byte[] iv) {
            this.cipher = cipher;
            this.mac = mac;
            this.compression = compression;
            this.mode = mode;
            this.key = (byte[])key.clone();
            this.iv = (byte[])iv.clone();
        }

        private void initCipher(long packetSequenceNumber) throws Exception {
            if (this.key != null) {
                if (this.cipher.getAlgorithm().startsWith("ChaCha")) {
                    BufferUtils.putLong(packetSequenceNumber, this.iv, 0, this.iv.length);
                }
                this.cipher.init(this.mode, this.key, this.iv);
                this.key = null;
            }
        }

        public Cipher getCipher(long packetSequenceNumber) throws Exception {
            this.initCipher(packetSequenceNumber);
            return this.cipher;
        }

        public Mac getMac() {
            return this.mac;
        }

        public Compression getCompression() {
            return this.compression;
        }
    }

    private static enum KexStart {
        PEER,
        BOTH,
        ONGOING;

    }
}

