/*
 * Decompiled with CFR 0.152.
 */
package org.fontbox.ttf;

import java.io.IOException;
import org.fontbox.ttf.TTFDataStream;
import org.fontbox.ttf.TrueTypeFont;

public class CMAPEncodingEntry {
    private int platformId;
    private int platformEncodingId;
    private long subTableOffset;
    private int[] glyphIdToCharacterCode;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        this.platformId = data.readUnsignedShort();
        this.platformEncodingId = data.readUnsignedShort();
        this.subTableOffset = data.readUnsignedInt();
    }

    public void initSubtable(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        data.seek(ttf.getCMAP().getOffset() + this.subTableOffset);
        int subtableFormat = data.readUnsignedShort();
        int length = data.readUnsignedShort();
        int version = data.readUnsignedShort();
        int numGlyphs = ttf.getMaximumProfile().getNumGlyphs();
        if (subtableFormat == 0) {
            byte[] glyphMapping = data.read(256);
            this.glyphIdToCharacterCode = new int[256];
            for (int i = 0; i < glyphMapping.length; ++i) {
                this.glyphIdToCharacterCode[i] = (glyphMapping[i] + 256) % 256;
            }
        } else {
            if (subtableFormat == 2) {
                int[] subHeaderKeys = new int[256];
                for (int i = 0; i < 256; ++i) {
                    subHeaderKeys[i] = data.readUnsignedShort();
                }
                int firstCode = data.readUnsignedShort();
                int entryCount = data.readUnsignedShort();
                short idDelta = data.readSignedShort();
                int idRangeOffset = data.readUnsignedShort();
                throw new IOException("Not yet implemented:" + subtableFormat);
            }
            if (subtableFormat == 4) {
                int segCountX2 = data.readUnsignedShort();
                int segCount = segCountX2 / 2;
                int searchRange = data.readUnsignedShort();
                int entrySelector = data.readUnsignedShort();
                int rangeShift = data.readUnsignedShort();
                int[] endCount = data.readUnsignedShortArray(segCount);
                int reservedPad = data.readUnsignedShort();
                int[] startCount = data.readUnsignedShortArray(segCount);
                int[] idDelta = data.readUnsignedShortArray(segCount);
                int[] idRangeOffset = data.readUnsignedShortArray(segCount);
                this.glyphIdToCharacterCode = new int[numGlyphs];
                long currentPosition = data.getCurrentPosition();
                for (int i = 0; i < segCount; ++i) {
                    int start = startCount[i];
                    int end = endCount[i];
                    int delta = idDelta[i];
                    int rangeOffset = idRangeOffset[i];
                    if (start == 65535 || end == 65535) continue;
                    for (int j = start; j <= end; ++j) {
                        if (rangeOffset == 0) {
                            this.glyphIdToCharacterCode[(j + delta) % 65536] = j;
                            continue;
                        }
                        long glyphOffset = currentPosition + (long)((rangeOffset / 2 + (j - start) + (i - segCount)) * 2);
                        data.seek(glyphOffset);
                        int glyphIndex = data.readUnsignedShort();
                        if (glyphIndex == 0) continue;
                        glyphIndex += delta;
                        if (this.glyphIdToCharacterCode[glyphIndex %= 65536] != 0) continue;
                        this.glyphIdToCharacterCode[glyphIndex] = j;
                    }
                }
            } else if (subtableFormat == 6) {
                int firstCode = data.readUnsignedShort();
                int entryCount = data.readUnsignedShort();
                this.glyphIdToCharacterCode = new int[numGlyphs];
                int[] glyphIdArray = data.readUnsignedShortArray(entryCount);
                for (int i = 0; i < entryCount; ++i) {
                    this.glyphIdToCharacterCode[glyphIdArray[i]] = firstCode + i;
                }
            } else {
                throw new IOException("Unknown cmap format:" + subtableFormat);
            }
        }
    }

    public int[] getGlyphIdToCharacterCode() {
        return this.glyphIdToCharacterCode;
    }

    public void setGlyphIdToCharacterCode(int[] glyphIdToCharacterCodeValue) {
        this.glyphIdToCharacterCode = glyphIdToCharacterCodeValue;
    }

    public int getPlatformEncodingId() {
        return this.platformEncodingId;
    }

    public void setPlatformEncodingId(int platformEncodingIdValue) {
        this.platformEncodingId = platformEncodingIdValue;
    }

    public int getPlatformId() {
        return this.platformId;
    }

    public void setPlatformId(int platformIdValue) {
        this.platformId = platformIdValue;
    }
}

