/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryHits;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Hits;

public class LuceneQueryHits
extends AbstractQueryHits {
    private final Hits hits;
    private final IndexReader reader;
    private int hitIndex = -1;

    public LuceneQueryHits(Hits hits, IndexReader reader) {
        this.hits = hits;
        this.reader = reader;
    }

    public final int getSize() {
        return this.hits.length();
    }

    public final ScoreNode nextScoreNode() throws IOException {
        if (++this.hitIndex >= this.hits.length()) {
            return null;
        }
        String uuid = this.reader.document(this.id(this.hitIndex), FieldSelectors.UUID).get(FieldNames.UUID);
        return new ScoreNode(NodeId.valueOf(uuid), this.hits.score(this.hitIndex));
    }

    public void skip(int n) throws IOException {
        this.hitIndex += n;
    }

    private final int id(int n) throws IOException {
        return this.hits.id(n);
    }
}

