/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.vysper.storage.OpenStorageProviderRegistry;
import org.apache.vysper.storage.StorageProvider;
import org.apache.vysper.storage.StorageProviderRegistry;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityUtils;
import org.apache.vysper.xmpp.authorization.UserAuthorization;
import org.apache.vysper.xmpp.cryptography.TLSContextFactory;
import org.apache.vysper.xmpp.delivery.StanzaRelay;
import org.apache.vysper.xmpp.modules.Module;
import org.apache.vysper.xmpp.modules.ModuleRegistry;
import org.apache.vysper.xmpp.modules.ServerRuntimeContextService;
import org.apache.vysper.xmpp.protocol.HandlerDictionary;
import org.apache.vysper.xmpp.protocol.ProtocolWorker;
import org.apache.vysper.xmpp.protocol.QueuedStanzaProcessor;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.protocol.StanzaHandlerLookup;
import org.apache.vysper.xmpp.protocol.StanzaProcessor;
import org.apache.vysper.xmpp.server.ServerFeatures;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.components.Component;
import org.apache.vysper.xmpp.server.s2s.DefaultXMPPServerConnectorRegistry;
import org.apache.vysper.xmpp.server.s2s.XMPPServerConnectorRegistry;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.state.presence.LatestPresenceCache;
import org.apache.vysper.xmpp.state.presence.SimplePresenceCache;
import org.apache.vysper.xmpp.state.resourcebinding.ResourceRegistry;
import org.apache.vysper.xmpp.uuid.JVMBuiltinUUIDGenerator;
import org.apache.vysper.xmpp.uuid.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServerRuntimeContext
implements ServerRuntimeContext,
ModuleRegistry {
    final Logger logger = LoggerFactory.getLogger(DefaultServerRuntimeContext.class);
    private StanzaHandlerLookup stanzaHandlerLookup;
    private Entity serverEntity;
    private ServerFeatures serverFeatures = new ServerFeatures();
    private SSLContext sslContext = null;
    private UUIDGenerator sessionIdGenerator = new JVMBuiltinUUIDGenerator();
    private StanzaProcessor stanzaProcessor = new QueuedStanzaProcessor(new ProtocolWorker());
    private StanzaRelay stanzaRelay;
    private ResourceRegistry resourceRegistry;
    private LatestPresenceCache presenceCache = new SimplePresenceCache();
    private XMPPServerConnectorRegistry serverConnectorRegistry = new DefaultXMPPServerConnectorRegistry(this);
    private StorageProviderRegistry storageProviderRegistry = new OpenStorageProviderRegistry();
    private final Map<String, ServerRuntimeContextService> serverRuntimeContextServiceMap = new HashMap<String, ServerRuntimeContextService>();
    private List<Module> modules = new ArrayList<Module>();
    protected final Map<String, Component> componentMap = new HashMap<String, Component>();

    public DefaultServerRuntimeContext(Entity serverEntity, StanzaRelay stanzaRelay) {
        this.serverEntity = serverEntity;
        this.stanzaRelay = stanzaRelay;
        this.resourceRegistry = new ResourceRegistry();
        this.stanzaHandlerLookup = new StanzaHandlerLookup(this);
    }

    public DefaultServerRuntimeContext(Entity serverEntity, StanzaRelay stanzaRelay, StorageProviderRegistry storageProviderRegistry) {
        this(serverEntity, stanzaRelay);
        this.storageProviderRegistry = storageProviderRegistry;
    }

    public DefaultServerRuntimeContext(Entity serverEntity, StanzaRelay stanzaRelay, ServerFeatures serverFeatures, List<HandlerDictionary> dictionaries, ResourceRegistry resourceRegistry) {
        this(serverEntity, stanzaRelay);
        this.serverFeatures = serverFeatures;
        this.resourceRegistry = resourceRegistry;
        this.addDictionaries(dictionaries);
    }

    public void setPresenceCache(LatestPresenceCache presenceCache) {
        this.presenceCache = presenceCache;
    }

    @Override
    public StanzaHandler getHandler(Stanza stanza) {
        return this.stanzaHandlerLookup.getHandler(stanza);
    }

    @Override
    public String getNextSessionId() {
        return this.sessionIdGenerator.create();
    }

    @Override
    public Entity getServerEnitity() {
        return this.serverEntity;
    }

    @Override
    public String getDefaultXMLLang() {
        return "en_US";
    }

    @Override
    public StanzaProcessor getStanzaProcessor() {
        return this.stanzaProcessor;
    }

    @Override
    public StanzaRelay getStanzaRelay() {
        return this.stanzaRelay;
    }

    @Override
    public ServerFeatures getServerFeatures() {
        return this.serverFeatures;
    }

    @Override
    public XMPPServerConnectorRegistry getServerConnectorRegistry() {
        return this.serverConnectorRegistry;
    }

    public void addDictionary(HandlerDictionary namespaceHandlerDictionary) {
        this.stanzaHandlerLookup.addDictionary(namespaceHandlerDictionary);
    }

    protected void addDictionaries(List<HandlerDictionary> dictionaries) {
        for (HandlerDictionary dictionary : dictionaries) {
            this.addDictionary(dictionary);
        }
    }

    public void setTlsContextFactory(TLSContextFactory tlsContextFactory) {
        try {
            this.sslContext = tlsContextFactory.getSSLContext();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Override
    public UserAuthorization getUserAuthorization() {
        return (UserAuthorization)this.storageProviderRegistry.retrieve(UserAuthorization.class);
    }

    @Override
    public ResourceRegistry getResourceRegistry() {
        return this.resourceRegistry;
    }

    @Override
    public LatestPresenceCache getPresenceCache() {
        return this.presenceCache;
    }

    @Override
    public void registerServerRuntimeContextService(ServerRuntimeContextService service) {
        if (service == null) {
            throw new IllegalStateException("service must not be null");
        }
        if (this.serverRuntimeContextServiceMap.get(service.getServiceName()) != null) {
            throw new IllegalStateException("service already registered: " + service.getServiceName());
        }
        this.serverRuntimeContextServiceMap.put(service.getServiceName(), service);
    }

    @Override
    public ServerRuntimeContextService getServerRuntimeContextService(String name) {
        return this.serverRuntimeContextServiceMap.get(name);
    }

    public void setStorageProviderRegistry(StorageProviderRegistry storageProviderRegistry) {
        this.logger.info("replacing the storage provider registry with " + storageProviderRegistry.getClass().getCanonicalName());
        this.storageProviderRegistry = storageProviderRegistry;
    }

    @Override
    public StorageProvider getStorageProvider(Class<? extends StorageProvider> clazz) {
        return this.storageProviderRegistry.retrieve(clazz);
    }

    @Override
    public void addModules(List<Module> modules) {
        for (Module module : modules) {
            this.addModuleInternal(module);
        }
        for (Module module : modules) {
            module.initialize(this);
        }
    }

    @Override
    public void addModule(Module module) {
        this.addModuleInternal(module);
        module.initialize(this);
    }

    protected void addModuleInternal(Module module) {
        List<HandlerDictionary> handlerDictionaryList;
        this.logger.info("adding module... {} ({})", (Object)module.getName(), (Object)module.getVersion());
        List<ServerRuntimeContextService> serviceList = module.getServerServices();
        if (serviceList != null) {
            for (ServerRuntimeContextService serverRuntimeContextService : serviceList) {
                this.registerServerRuntimeContextService(serverRuntimeContextService);
                if (!(serverRuntimeContextService instanceof StorageProvider)) continue;
                StorageProvider storageProvider = (StorageProvider)((Object)serverRuntimeContextService);
                this.storageProviderRegistry.add(storageProvider);
            }
        }
        if ((handlerDictionaryList = module.getHandlerDictionaries()) != null) {
            for (HandlerDictionary handlerDictionary : handlerDictionaryList) {
                this.addDictionary(handlerDictionary);
            }
        }
        if (module instanceof Component) {
            this.registerComponent((Component)((Object)module));
        }
        this.modules.add(module);
    }

    @Override
    public List<Module> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    @Override
    public <T> T getModule(Class<T> clazz) {
        for (Module module : this.modules) {
            if (!module.getClass().equals(clazz)) continue;
            return (T)module;
        }
        return null;
    }

    @Override
    public void registerComponent(Component component) {
        this.componentMap.put(component.getSubdomain(), component);
    }

    @Override
    public StanzaProcessor getComponentStanzaProcessor(Entity entity) {
        String serverDomain = this.getServerEnitity().getDomain();
        if (!EntityUtils.isAddressingServerComponent(entity, this.getServerEnitity())) {
            return null;
        }
        String domain = entity.getDomain();
        String subdomain = domain.replace("." + serverDomain, "");
        Component component = this.componentMap.get(subdomain);
        if (component == null) {
            return null;
        }
        return component.getStanzaProcessor();
    }
}

