/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.interactive.annotation;

import java.io.IOException;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.graphics.color.PDGamma;
import org.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.pdfbox.pdmodel.interactive.action.PDAdditionalActions;
import org.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationLine;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationRubberStamp;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationSquareCircle;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationText;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationTextMarkup;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationUnknown;
import org.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.pdfbox.util.BitFlagHelper;

public abstract class PDAnnotation
implements COSObjectable {
    public static final int FLAG_INVISIBLE = 1;
    public static final int FLAG_HIDDEN = 2;
    public static final int FLAG_PRINTED = 4;
    public static final int FLAG_NO_ZOOM = 8;
    public static final int FLAG_NO_ROTATE = 16;
    public static final int FLAG_NO_VIEW = 32;
    public static final int FLAG_READ_ONLY = 64;
    public static final int FLAG_LOCKED = 128;
    public static final int FLAG_TOGGLE_NO_VIEW = 256;
    private COSDictionary dictionary;

    public static PDAnnotation createAnnotation(COSBase base) throws IOException {
        PDAnnotation annot = null;
        if (base instanceof COSDictionary) {
            COSDictionary annotDic = (COSDictionary)base;
            String subtype = annotDic.getNameAsString(COSName.SUBTYPE);
            annot = subtype.equals("Stamp") ? new PDAnnotationRubberStamp(annotDic) : (subtype.equals("Link") ? new PDAnnotationLink(annotDic) : (subtype.equals("Text") ? new PDAnnotationText(annotDic) : (subtype.equals("Line") ? new PDAnnotationLine(annotDic) : (subtype.equals("Square") || subtype.equals("Circle") ? new PDAnnotationSquareCircle(annotDic) : (subtype.equals("Link") ? new PDAnnotationLink(annotDic) : (subtype.equals("FileAttachment") ? new PDAnnotationFileAttachment(annotDic) : (subtype.equals("Highlight") || subtype.equals("Underline") || subtype.equals("Squiggly") || subtype.equals("StrikeOut") ? new PDAnnotationTextMarkup(annotDic) : new PDAnnotationUnknown(annotDic))))))));
        } else {
            throw new IOException("Error: Unknown annotation type " + base);
        }
        return annot;
    }

    public PDAnnotation() {
        this.dictionary = new COSDictionary();
        this.dictionary.setItem(COSName.TYPE, (COSBase)COSName.getPDFName("Annot"));
    }

    public PDAnnotation(COSDictionary dict) {
        this.dictionary = dict;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    public PDRectangle getRectangle() {
        COSArray rectArray = (COSArray)this.dictionary.getDictionaryObject(COSName.getPDFName("Rect"));
        PDRectangle rectangle = null;
        if (rectArray != null) {
            rectangle = new PDRectangle(rectArray);
        }
        return rectangle;
    }

    public void setRectangle(PDRectangle rectangle) {
        this.dictionary.setItem(COSName.getPDFName("Rect"), (COSBase)rectangle.getCOSArray());
    }

    public int getAnnotationFlags() {
        return this.getDictionary().getInt("F", 0);
    }

    public void setAnnotationFlags(int flags) {
        this.getDictionary().setInt("F", flags);
    }

    public COSBase getCOSObject() {
        return this.getDictionary();
    }

    public String getAppearanceStream() {
        String retval = null;
        COSName name = (COSName)this.getDictionary().getDictionaryObject(COSName.getPDFName("AS"));
        if (name != null) {
            retval = name.getName();
        }
        return retval;
    }

    public void setAppearanceStream(String as) {
        if (as == null) {
            this.getDictionary().removeItem(COSName.getPDFName("AS"));
        } else {
            this.getDictionary().setItem(COSName.getPDFName("AS"), (COSBase)COSName.getPDFName(as));
        }
    }

    public PDAppearanceDictionary getAppearance() {
        PDAppearanceDictionary ap = null;
        COSDictionary apDic = (COSDictionary)this.dictionary.getDictionaryObject(COSName.getPDFName("AP"));
        if (apDic != null) {
            ap = new PDAppearanceDictionary(apDic);
        }
        return ap;
    }

    public void setAppearance(PDAppearanceDictionary appearance) {
        COSDictionary ap = null;
        if (appearance != null) {
            ap = appearance.getDictionary();
        }
        this.dictionary.setItem(COSName.getPDFName("AP"), (COSBase)ap);
    }

    public boolean isInvisible() {
        return BitFlagHelper.getFlag(this.getDictionary(), "F", 1);
    }

    public void setInvisible(boolean invisible) {
        BitFlagHelper.setFlag(this.getDictionary(), "F", 1, invisible);
    }

    public boolean isHidden() {
        return BitFlagHelper.getFlag(this.getDictionary(), "F", 2);
    }

    public void setHidden(boolean hidden) {
        BitFlagHelper.setFlag(this.getDictionary(), "F", 2, hidden);
    }

    public boolean isPrinted() {
        return BitFlagHelper.getFlag(this.getDictionary(), "F", 4);
    }

    public void setPrinted(boolean printed) {
        BitFlagHelper.setFlag(this.getDictionary(), "F", 4, printed);
    }

    public boolean isNoZoom() {
        return BitFlagHelper.getFlag(this.getDictionary(), "F", 8);
    }

    public void setNoZoom(boolean noZoom) {
        BitFlagHelper.setFlag(this.getDictionary(), "F", 8, noZoom);
    }

    public boolean isNoRotate() {
        return BitFlagHelper.getFlag(this.getDictionary(), "F", 16);
    }

    public void setNoRotate(boolean noRotate) {
        BitFlagHelper.setFlag(this.getDictionary(), "F", 16, noRotate);
    }

    public boolean isNoView() {
        return BitFlagHelper.getFlag(this.getDictionary(), "F", 32);
    }

    public void setNoView(boolean noView) {
        BitFlagHelper.setFlag(this.getDictionary(), "F", 32, noView);
    }

    public boolean isReadOnly() {
        return BitFlagHelper.getFlag(this.getDictionary(), "F", 64);
    }

    public void setReadOnly(boolean readOnly) {
        BitFlagHelper.setFlag(this.getDictionary(), "F", 64, readOnly);
    }

    public boolean isLocked() {
        return BitFlagHelper.getFlag(this.getDictionary(), "F", 128);
    }

    public void setLocked(boolean locked) {
        BitFlagHelper.setFlag(this.getDictionary(), "F", 128, locked);
    }

    public boolean isToggleNoView() {
        return BitFlagHelper.getFlag(this.getDictionary(), "F", 256);
    }

    public void setToggleNoView(boolean toggleNoView) {
        BitFlagHelper.setFlag(this.getDictionary(), "F", 256, toggleNoView);
    }

    public PDAction getAction() throws IOException {
        COSDictionary action = (COSDictionary)this.getDictionary().getDictionaryObject(COSName.A);
        return PDActionFactory.createAction(action);
    }

    public void setAction(PDAction action) {
        this.getDictionary().setItem(COSName.A, (COSObjectable)action);
    }

    public PDAdditionalActions getActions() {
        COSDictionary aa = (COSDictionary)this.dictionary.getDictionaryObject("AA");
        PDAdditionalActions retval = null;
        if (aa != null) {
            retval = new PDAdditionalActions(aa);
        }
        return retval;
    }

    public void setActions(PDAdditionalActions actions) {
        this.dictionary.setItem("AA", (COSObjectable)actions);
    }

    public String getContents() {
        return this.dictionary.getString(COSName.CONTENTS);
    }

    public void setContents(String value) {
        this.dictionary.setString(COSName.CONTENTS, value);
    }

    public void setBorderStyle(PDBorderStyleDictionary bs) {
        this.getDictionary().setItem("BS", (COSObjectable)bs);
    }

    public PDBorderStyleDictionary getBoderStyle() {
        COSDictionary bs = (COSDictionary)this.getDictionary().getItem(COSName.getPDFName("BS"));
        if (bs != null) {
            return new PDBorderStyleDictionary(bs);
        }
        return null;
    }

    public String getModifiedDate() {
        return this.getDictionary().getString("M");
    }

    public void setModifiedDate(String m) {
        this.getDictionary().setString("M", m);
    }

    public String getAnnotationName() {
        return this.getDictionary().getString("NM");
    }

    public void setAnnotationName(String nm) {
        this.getDictionary().setString("NM", nm);
    }

    public void setColour(PDGamma c) {
        this.getDictionary().setItem("C", (COSObjectable)c);
    }

    public PDGamma getColour() {
        COSArray c = (COSArray)this.getDictionary().getItem(COSName.getPDFName("C"));
        if (c != null) {
            return new PDGamma(c);
        }
        return null;
    }
}

