/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentBodyTag;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.MyfacesStateManager;
import org.apache.myfaces.application.jsp.JspViewHandlerImpl;
import org.apache.myfaces.shared_impl.renderkit.html.HtmlLinkRendererBase;
import org.apache.myfaces.shared_impl.util.LocaleUtils;

public class ViewTag
extends UIComponentBodyTag {
    private static final Log log = LogFactory.getLog((Class)ViewTag.class);
    private static final String PARTIAL_STATE_SAVING_METHOD_PARAM_NAME = "javax.faces.PARTIAL_STATE_SAVING_METHOD";
    private static final String PARTIAL_STATE_SAVING_METHOD_ON = "true";
    private static final String PARTIAL_STATE_SAVING_METHOD_OFF = "false";
    private Boolean _partialStateSaving = null;
    private String _locale;

    private boolean isPartialStateSavingOn(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this._partialStateSaving != null) {
            return this._partialStateSaving;
        }
        String stateSavingMethod = context.getExternalContext().getInitParameter(PARTIAL_STATE_SAVING_METHOD_PARAM_NAME);
        if (stateSavingMethod == null) {
            this._partialStateSaving = Boolean.FALSE;
            context.getExternalContext().log("No context init parameter 'javax.faces.PARTIAL_STATE_SAVING_METHOD' found; no partial state saving method defined, assuming default partial state saving method off.");
        } else if (stateSavingMethod.equals(PARTIAL_STATE_SAVING_METHOD_ON)) {
            this._partialStateSaving = Boolean.TRUE;
        } else if (stateSavingMethod.equals(PARTIAL_STATE_SAVING_METHOD_OFF)) {
            this._partialStateSaving = Boolean.FALSE;
        } else {
            this._partialStateSaving = Boolean.FALSE;
            context.getExternalContext().log("Illegal partial state saving method '" + stateSavingMethod + "', default partial state saving will be used (partial state saving off).");
        }
        return this._partialStateSaving;
    }

    public String getComponentType() {
        return "javax.faces.ViewRoot";
    }

    public String getRendererType() {
        return null;
    }

    public void setLocale(String locale) {
        this._locale = locale;
    }

    public int doStartTag() throws JspException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering ViewTag.doStartTag");
        }
        super.doStartTag();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        try {
            responseWriter.startDocument();
        }
        catch (IOException e) {
            log.error((Object)"Error writing startDocument", (Throwable)e);
            throw new JspException((Throwable)e);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"leaving ViewTag.doStartTag");
        }
        return 2;
    }

    protected boolean isSuppressed() {
        return true;
    }

    public int doEndTag() throws JspException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering ViewTag.doEndTag");
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        try {
            responseWriter.endDocument();
        }
        catch (IOException e) {
            log.error((Object)"Error writing endDocument", (Throwable)e);
            throw new JspException((Throwable)e);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"leaving ViewTag.doEndTag");
        }
        return super.doEndTag();
    }

    public int doAfterBody() throws JspException {
        FacesContext facesContext;
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering ViewTag.doAfterBody");
        }
        if (!this.isPartialStateSavingOn(facesContext = FacesContext.getCurrentInstance())) {
            try {
                BodyContent bodyContent = this.getBodyContent();
                if (bodyContent != null) {
                    StateManager stateManager = facesContext.getApplication().getStateManager();
                    StateManager.SerializedView serializedView = stateManager.saveSerializedView(facesContext);
                    ResponseWriter bufferWriter = facesContext.getResponseWriter();
                    bufferWriter.flush();
                    ResponseWriter realWriter = bufferWriter.cloneWithWriter((Writer)this.getPreviousOut());
                    facesContext.setResponseWriter(realWriter);
                    String bodyStr = bodyContent.getString();
                    int form_marker = bodyStr.indexOf("<!--@@JSF_FORM_STATE_MARKER@@-->");
                    int url_marker = bodyStr.indexOf("JSF_URL_STATE_MARKER=DUMMY");
                    int lastMarkerEnd = 0;
                    while (form_marker != -1 || url_marker != -1) {
                        if (url_marker == -1 || form_marker != -1 && form_marker < url_marker) {
                            realWriter.write(bodyStr, lastMarkerEnd, form_marker - lastMarkerEnd);
                            stateManager.writeState(facesContext, serializedView);
                            lastMarkerEnd = form_marker + JspViewHandlerImpl.FORM_STATE_MARKER_LEN;
                            form_marker = bodyStr.indexOf("<!--@@JSF_FORM_STATE_MARKER@@-->", lastMarkerEnd);
                            continue;
                        }
                        realWriter.write(bodyStr, lastMarkerEnd, url_marker - lastMarkerEnd);
                        if (stateManager instanceof MyfacesStateManager) {
                            ((MyfacesStateManager)stateManager).writeStateAsUrlParams(facesContext, serializedView);
                        } else {
                            log.error((Object)"Current StateManager is no MyfacesStateManager and does not support saving state in url parameters.");
                        }
                        lastMarkerEnd = url_marker + HtmlLinkRendererBase.URL_STATE_MARKER_LEN;
                        url_marker = bodyStr.indexOf("JSF_URL_STATE_MARKER=DUMMY", lastMarkerEnd);
                    }
                    realWriter.write(bodyStr, lastMarkerEnd, bodyStr.length() - lastMarkerEnd);
                }
            }
            catch (IOException e) {
                log.error((Object)"Error writing body content", (Throwable)e);
                throw new JspException((Throwable)e);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"leaving ViewTag.doAfterBody");
        }
        return super.doAfterBody();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setProperties(UIComponent component) {
        block6: {
            Locale locale;
            block5: {
                block7: {
                    super.setProperties(component);
                    if (this._locale == null) break block6;
                    if (!UIComponentTag.isValueReference((String)this._locale)) break block7;
                    FacesContext context = FacesContext.getCurrentInstance();
                    ValueBinding vb = context.getApplication().createValueBinding(this._locale);
                    Object localeValue = vb.getValue(context);
                    if (localeValue instanceof Locale) {
                        locale = (Locale)localeValue;
                        break block5;
                    } else if (localeValue instanceof String) {
                        locale = LocaleUtils.toLocale((String)localeValue);
                        break block5;
                    } else {
                        if (localeValue != null) {
                            throw new IllegalArgumentException("Locale or String class expected. Expression: " + this._locale + ". Return class: " + localeValue.getClass().getName());
                        }
                        throw new IllegalArgumentException("Locale or String class expected. Expression: " + this._locale + ". Return value null");
                    }
                }
                locale = LocaleUtils.toLocale(this._locale);
            }
            ((UIViewRoot)component).setLocale(locale);
            Config.set((ServletRequest)this.pageContext.getRequest(), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)locale);
        }
    }
}

